/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.PaymentAdjustmentFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BloodLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(BloodLogic.class);

    BloodLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        for (Day day : processor.getResourceManager().getNavigator().getDayList()) {
            if (!day.isLineFlagPresent(LineFlags.DATA_HCPCS_BLOOD_PRODUCT)) continue;
            Set<LineItemInternal> revCode39Lines = day.getLineItemList().stream().filter(this::is39x).collect(Collectors.toSet());
            Set<LineItemInternal> revCode38Lines = day.getLineItemList().stream().filter(this::is38x).collect(Collectors.toSet());
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_BLOOD_PRODUCT) || !line.getFlags().noneSet(LineFlags.INPATIENT_LINE, LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                this.processBloodLine(claim, line, revCode39Lines, revCode38Lines);
            }
        }
        return false;
    }

    private void processBloodLine(OceClaimInternal claim, LineItemInternal line, Set<LineItemInternal> revCode39Lines, Set<LineItemInternal> revCode38Lines) {
        if (this.is39x(line)) {
            this.process39x(claim, line, revCode39Lines, revCode38Lines);
        } else if (this.is38x(line)) {
            this.process38x(claim, line, revCode39Lines);
        } else {
            claim.assignEdit(EditValue.BLOOD_CODING_ERROR, line);
        }
    }

    private boolean is38x(LineItemInternal line) {
        return line != null && HardcodedRevenueCodeSet.isBloodProduct(line.getRevenueCode()) && line.getFlags().isSet(LineFlags.DATA_HCPCS_BLOOD_PRODUCT);
    }

    private boolean is39x(LineItemInternal line) {
        return line != null && HardcodedRevenueCodeSet.isBloodProcessing(line.getRevenueCode()) && line.getFlags().isSet(LineFlags.DATA_HCPCS_BLOOD_PRODUCT);
    }

    private void process39x(OceClaimInternal claim, LineItemInternal line, Set<LineItemInternal> revCode39Lines, Set<LineItemInternal> revCode38Lines) {
        if (line.isHcpcsModifierPresent("BL")) {
            this.process39xWithBL(claim, line, revCode39Lines, revCode38Lines);
        } else {
            this.process39xWithoutBL(claim, line, revCode38Lines);
        }
    }

    private void process38x(OceClaimInternal claim, LineItemInternal line, Set<LineItemInternal> revCode39Lines) {
        if (revCode39Lines.stream().noneMatch(x -> x.getHcpcs().equals(line.getHcpcs()))) {
            claim.assignEdit(EditValue.BLOOD_CODING_ERROR, line);
        }
    }

    private void process39xWithBL(OceClaimInternal claim, LineItemInternal line, Set<LineItemInternal> revCode39Lines, Set<LineItemInternal> revCode38Lines) {
        boolean performSummingLogic = true;
        Set hcpcsMatches = revCode38Lines.stream().filter(x -> x.getHcpcs().equals(line.getHcpcs())).collect(Collectors.toSet());
        if (hcpcsMatches.isEmpty()) {
            claim.assignEdit(EditValue.BLOOD_CODING_ERROR, line);
            performSummingLogic = false;
        } else {
            for (LineItemInternal hcpcsMatch : hcpcsMatches) {
                if (hcpcsMatch.isHcpcsModifierPresent("BL")) continue;
                claim.assignEdit(EditValue.BLOOD_CODING_ERROR, line);
                claim.assignEdit(EditValue.BLOOD_CODING_ERROR, hcpcsMatch);
                performSummingLogic = false;
            }
        }
        if (performSummingLogic) {
            int bl39Sum;
            Set<LineItemInternal> matches38 = revCode38Lines.stream().filter(x -> x.getHcpcs().equals(line.getHcpcs())).filter(x -> x.isHcpcsModifierPresent("BL")).collect(Collectors.toSet());
            Set<LineItemInternal> matches39 = revCode39Lines.stream().filter(x -> x.getHcpcs().equals(line.getHcpcs())).filter(x -> x.isHcpcsModifierPresent("BL")).collect(Collectors.toSet());
            int bl38Sum = matches38.stream().mapToInt(LineItemInternal::getUnitsAsPrimitive).sum();
            if (bl38Sum != (bl39Sum = matches39.stream().mapToInt(LineItemInternal::getUnitsAsPrimitive).sum())) {
                claim.assignEdit(EditValue.BLOOD_CODING_ERROR);
                matches38.forEach(x -> claim.assignEdit(EditValue.BLOOD_CODING_ERROR, (LineItemInternal)x));
                matches39.forEach(x -> claim.assignEdit(EditValue.BLOOD_CODING_ERROR, (LineItemInternal)x));
            } else {
                matches38.forEach(x -> x.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_BLOOD_PRODUCT));
                matches39.forEach(x -> x.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_BLOOD_PROCESS));
                matches38.forEach(x -> x.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_BLOOD_PRODUCT.getValue()));
                matches39.forEach(x -> x.setPaymentAdjustmentFlag01(PaymentAdjustmentFlags.PAYMENT_ADJUSTMENT_BLOOD_PROCESS.getValue()));
            }
        }
    }

    private void process39xWithoutBL(OceClaimInternal claim, LineItemInternal line, Set<LineItemInternal> revCode38Lines) {
        for (LineItemInternal revCode38Line : revCode38Lines) {
            if (!revCode38Line.getHcpcs().equals(line.getHcpcs())) continue;
            claim.assignEdit(EditValue.BLOOD_CODING_ERROR, line);
            claim.assignEdit(EditValue.BLOOD_CODING_ERROR, revCode38Line);
        }
    }
}

