/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.MapCompositeDao;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.dao.data.row.MapCompositeRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.PaymentIndicator;
import gov.cms.oce.model.internal.StatusIndicator;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.model.rsc.Sequencer;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeImagingLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CompositeImagingLogic.class);

    CompositeImagingLogic() {
    }

    private final CompositeLine createCompositeLine(LineItemInternal line, MapCompositeRowInternal mapCompositeRow, DataApcRowInternal dataApcRow) {
        return new CompositeLine(line, Apc.create(mapCompositeRow.getCompositeApc()), StatusIndicator.create(dataApcRow.getStatusIndicator()), PaymentIndicator.create(dataApcRow.getPaymentIndicator()));
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapCompositeDao mapCompositeDao = processor.getResourceManager().getDataDaoFactory().getMapCompositeDao();
        DataApcDao dataApcDao = processor.getResourceManager().getDataDaoFactory().getDataApcDao();
        short version = claim.getVersionAsPrimitive();
        for (Day day : navigator.getDayList()) {
            CompositeGroupList compositeGroupList = new CompositeGroupList();
            boolean nonStandardCtScanPresentOnDay = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!nonStandardCtScanPresentOnDay && line.getFlags().isSet(LineFlags.DATA_HCPCS_NON_STANDARD_CT_SCAN) && line.isHcpcsModifierPresent("CT")) {
                    nonStandardCtScanPresentOnDay = true;
                }
                if (!line.getFlags().noneSet((LineFlags)new LineFlags[]{LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.COMPOSITE_LINE}) || line.isRejectedDenied() && !line.getFlags().isSet(LineFlags.INPUT_LINE_EDIT_BYPASS)) continue;
                MapCompositeRowInternal mapCompositeRow = mapCompositeDao.getRow(line.getHcpcs(), (Short)version);
                if (mapCompositeRow == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No composite row found for CPT/HCPCS {} on {}, line {}", line.getHcpcs(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                    continue;
                }
                DataApcRowInternal dataApcRow = dataApcDao.getRow(mapCompositeRow.getCompositeApc(), (Short)version);
                if (dataApcRow == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("No APC row found for composite APC {} for CPT/HCPCS {} on {}, line {}", mapCompositeRow.getCompositeApc(), line.getHcpcs(), line.getDay().getIndex(), line.getDay().getLineIndex(line));
                    continue;
                }
                if (0 >= dataApcRow.getComposite3Id() || !"A".equals(mapCompositeRow.getListType())) continue;
                Family family = Family.getFamilyFromCompositeId(dataApcRow.getComposite3Id());
                CompositeGroup compositeGroup = compositeGroupList.getCompositeGroup(family);
                CompositeLine compositeLine = this.createCompositeLine(line, mapCompositeRow, dataApcRow);
                compositeGroup.addCompositeLine(compositeLine);
                if (compositeGroup.getPrimeCompositeLine() == null) {
                    compositeGroup.setPrimeCompositeLine(compositeLine);
                    compositeGroup.setPrimeCompositeApc(compositeLine.compositeApc);
                    continue;
                }
                if (compositeGroup.isContrastPresent() || dataApcRow.getComposite3Id() != Composite3IdGroups.CTA_WITH_CONTRAST.getIndex() && dataApcRow.getComposite3Id() != Composite3IdGroups.MRI_WITH_CONTRAST.getIndex()) continue;
                compositeGroup.setContrastPresent(true);
                compositeGroup.setPrimeCompositeApc(compositeLine.compositeApc);
            }
            for (CompositeGroup compositeGroup : compositeGroupList.list) {
                if (compositeGroup.getPrimeCompositeLine() == null) continue;
                if (1 < compositeGroup.getTotalUnits()) {
                    Sequencer<String> c = processor.getResourceManager().getCompositeAdjustmentFlagSequencer();
                    String compositeAdjustmentFlag = c.getNextValue();
                    CompositeLine primeCompositeLine = compositeGroup.getPrimeCompositeLine();
                    CompositeApc primeCompositeApc = compositeGroup.getPrimeCompositeApc();
                    OceClaimUtility.assignComposite(primeCompositeLine.line, primeCompositeApc.apc, primeCompositeApc.statusIndicator, primeCompositeApc.paymentIndicator, compositeAdjustmentFlag);
                    if (nonStandardCtScanPresentOnDay) {
                        primeCompositeLine.line.getFlags().set(LineFlags.PAYMENT_ADJUSTMENT_CT_SCAN_REDUCTION);
                        for (LineItemInternal line : day.getLineItemList()) {
                            if (line.equals(primeCompositeLine.line) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_NON_STANDARD_CT_SCAN) || !line.isHcpcsModifierPresent("CT") || !line.getFlags().noneSet((LineFlags)new LineFlags[]{LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.COMPOSITE_LINE})) continue;
                            line.getFlags().unset(LineFlags.PAYMENT_ADJUSTMENT_CT_SCAN_REDUCTION);
                        }
                    }
                    for (CompositeLine compositeLine : compositeGroup.compositeLineList) {
                        if (compositeLine.equals(primeCompositeLine)) continue;
                        if (compositeLine.line.isHcpcsModifierPresent("52", "73")) {
                            OceClaimUtility.assignConditionalApc(compositeLine.line);
                            continue;
                        }
                        OceClaimUtility.packageLine(compositeLine.line);
                        compositeLine.line.getCompositeAdjustmentFlag().setValue(compositeAdjustmentFlag);
                        compositeLine.line.getFlags().set(LineFlags.COMPOSITE_LINE);
                    }
                    continue;
                }
                for (CompositeLine compositeLine : compositeGroup.compositeLineList) {
                    if (!compositeLine.line.isNotPackaged() || !compositeLine.line.getFlags().isNotSet(LineFlags.COMPOSITE_LINE)) continue;
                    OceClaimUtility.assignConditionalApc(compositeLine.line);
                }
            }
        }
        return false;
    }

    private final class CompositeGroupList {
        private final List<CompositeGroup> list = new ArrayList<CompositeGroup>(Family.values().length);

        CompositeGroupList() {
            for (Family family : Family.values()) {
                this.list.add(new CompositeGroup(family));
            }
        }

        public final CompositeGroup getCompositeGroup(Family family) {
            return this.list.get(family.ordinal());
        }
    }

    private final class CompositeGroup {
        private final Family family;
        private final List<CompositeLine> compositeLineList = new ArrayList<CompositeLine>();
        private CompositeLine primeCompositeLine;
        private CompositeApc primeCompositeApc;
        boolean contrastPresent;

        CompositeGroup(Family family) {
            this.family = family;
        }

        final boolean addCompositeLine(CompositeLine compositeLine) {
            return this.compositeLineList.add(compositeLine);
        }

        final CompositeLine getPrimeCompositeLine() {
            return this.primeCompositeLine;
        }

        final void setPrimeCompositeLine(CompositeLine line) {
            this.primeCompositeLine = line;
        }

        final CompositeApc getPrimeCompositeApc() {
            return this.primeCompositeApc;
        }

        final void setPrimeCompositeApc(CompositeApc primeCompositeApc) {
            this.primeCompositeApc = primeCompositeApc;
        }

        final boolean isContrastPresent() {
            return this.contrastPresent;
        }

        final void setContrastPresent(boolean contrastPresent) {
            this.contrastPresent = contrastPresent;
        }

        final int getTotalUnits() {
            int units = 0;
            for (CompositeLine compositeLine : this.compositeLineList) {
                if (compositeLine.line.isHcpcsModifierPresent("52", "73")) continue;
                if (compositeLine.line.getFlags().anySet(LineFlags.DATA_HCPCS_BILATERAL_INDEPENDENT, LineFlags.DATA_HCPCS_BILATERAL_CONDITIONAL) && compositeLine.line.isHcpcsModifierPresent("50")) {
                    units += 2;
                    continue;
                }
                units += compositeLine.line.getUnitsAsPrimitive();
            }
            return units;
        }
    }

    private final class CompositeLine {
        private final LineItemInternal line;
        private CompositeApc compositeApc;

        CompositeLine(LineItemInternal line, Apc apc, StatusIndicator statusIndicator, PaymentIndicator paymentIndicator) {
            this.line = line;
            this.compositeApc = new CompositeApc(apc, statusIndicator, paymentIndicator);
        }
    }

    private final class CompositeApc {
        private final Apc apc;
        private final StatusIndicator statusIndicator;
        private final PaymentIndicator paymentIndicator;

        CompositeApc(Apc apc, StatusIndicator statusIndicator, PaymentIndicator paymentIndicator) {
            this.apc = apc;
            this.statusIndicator = statusIndicator;
            this.paymentIndicator = paymentIndicator;
        }
    }

    private static enum Family {
        ULTRASOUND,
        CTA,
        MRI;


        static final Family getFamilyFromCompositeId(int index) {
            if (index == 1) {
                return Family.values()[0];
            }
            if (index == 2 || index == 3) {
                return Family.values()[1];
            }
            if (index == 4 || index == 5) {
                return Family.values()[2];
            }
            return null;
        }
    }

    private static enum Composite3IdGroups {
        ULTRASOUND(1),
        CTA_WITHOUT_CONTRAST(2),
        CTA_WITH_CONTRAST(3),
        MRI_WITHOUT_CONTRAST(4),
        MRI_WITH_CONTRAST(5);

        private final int index;

        private Composite3IdGroups(int index) {
            this.index = index;
        }

        final int getIndex() {
            return this.index;
        }
    }
}

