/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.time.temporal.ChronoField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComprehensiveObservationLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ComprehensiveObservationLogic.class);

    ComprehensiveObservationLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isPrimaryComprehensiveChosen() && !claim.isStatusIndicatorPresent("T")) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            Day hourlyObservationDay = null;
            LineItemInternal hourlyObservationLine = null;
            block0: for (Day day : navigator.getDayList()) {
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_OBSERVATION_HOURLY) || line.isEditPresent(EditValue.MULTIPLE_HOURLY_OBSERVATION_PRESENT) || !line.isUnitsGreaterThan(7)) continue;
                    hourlyObservationDay = day;
                    hourlyObservationLine = line;
                    break block0;
                }
            }
            if (hourlyObservationLine == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("No hourly observation reported.");
                }
            } else {
                LineItemInternal highestPayingVisit = null;
                if (0 < hourlyObservationDay.getIndex()) {
                    Day dayBeforeHourlyObservationDay = navigator.getDayList().get(hourlyObservationDay.getIndex() - 1);
                    for (LineItemInternal line : dayBeforeHourlyObservationDay.getLineItemList()) {
                        if (!line.getFlags().isSet(LineFlags.OBSERVATION_VISIT) || !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT) || highestPayingVisit != null && !line.isApcPaymentGreaterThan(highestPayingVisit)) continue;
                        highestPayingVisit = line;
                    }
                }
                for (LineItemInternal line : hourlyObservationDay.getLineItemList()) {
                    if (!line.getFlags().anySet(LineFlags.OBSERVATION_VISIT, LineFlags.DATA_HCPCS_OBSERVATION_DIRECT_ADMIT) || highestPayingVisit != null && !line.isApcPaymentGreaterThan(highestPayingVisit)) continue;
                    highestPayingVisit = line;
                }
                if (highestPayingVisit == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No observation visit or direct admit");
                    }
                    if (hourlyObservationDay.getDate().get(ChronoField.DAY_OF_YEAR) == 1) {
                        claim.assignEdit(EditValue.OBSERVATION_CRITERIA_NOT_MET_FOR_FIRST_DAY_OF_YEAR, hourlyObservationLine);
                    }
                } else {
                    Apc comprehensiveObservationApc = Apc.create(HardcodedApcSet.CAPC_OBSERVATION.getApc());
                    OceClaimUtility.assignApc(processor, highestPayingVisit, comprehensiveObservationApc);
                    claim.setPrimaryComprehensive(highestPayingVisit);
                    OceClaimUtility.reduceUnits(highestPayingVisit);
                }
            }
        }
        return false;
    }
}

