/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorneaTransplantLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(CorneaTransplantLogic.class);

    CorneaTransplantLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        for (Day day : processor.getResourceManager().getNavigator().getDayList()) {
            boolean transplantPresent = false;
            boolean tissueProcessingPresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_CORNEA_TRANSPLANT)) {
                    transplantPresent = true;
                    if (!tissueProcessingPresent) continue;
                    break;
                }
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_CORNEA_TISSUE_PROCESSING) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                tissueProcessingPresent = true;
                if (!transplantPresent) continue;
                break;
            }
            if (transplantPresent || !tissueProcessingPresent) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_CORNEA_TISSUE_PROCESSING)) continue;
                claim.assignEdit(EditValue.CORNEA_TISSUE_MISSING_CORNEA_TRANSPLANT, line);
            }
        }
        return false;
    }
}

