/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImplantationDeviceInconsistencyLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ImplantationDeviceInconsistencyLogic.class);

    ImplantationDeviceInconsistencyLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (!claim.isStatusIndicatorPresent("S", "T", "J1")) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (LineItemInternal line : navigator.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.matchesStatusIndicator("H", "U")) continue;
                claim.assignEdit(EditValue.IMPLANTATION_PROCEDURE_CONFLICT, line);
            }
        }
        return false;
    }
}

