/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.MapAddonPhDao;
import gov.cms.oce.dao.data.row.MapAddonPhRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImplantationPrimaryCodeRequiredForAddonCodeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(ImplantationPrimaryCodeRequiredForAddonCodeLogic.class);

    ImplantationPrimaryCodeRequiredForAddonCodeLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        MapAddonPhDao dao = processor.getResourceManager().getDataDaoFactory().getMapAddonPhDao();
        short version = claim.getVersionAsPrimitive();
        for (Day day : navigator.getDayList()) {
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().isSet(LineFlags.DATA_HCPCS_PH_ADDON) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                boolean foundCompanion = false;
                for (LineItemInternal otherLine : day.getLineItemList()) {
                    MapAddonPhRowInternal row;
                    if (line.equals(otherLine) || (row = dao.getRow(line, otherLine, (Short)version)) == null) continue;
                    foundCompanion = true;
                    break;
                }
                if (foundCompanion) continue;
                claim.assignEdit(EditValue.ADDON_CODE_MISSING_PRIMARY_CODE, line);
            }
        }
        return false;
    }
}

