/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.DayFlags;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedHcpcsSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InpatientDayDeniedLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(InpatientDayDeniedLogic.class);

    InpatientDayDeniedLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        if (claim.getFlags().isNotSet(ClaimFlags.INPATIENT_APC_ASSIGNED)) {
            Navigator navigator = processor.getResourceManager().getNavigator();
            for (Day day : navigator.getDayList()) {
                if (!day.getFlags().isNotSet(DayFlags.INPATIENT_DAY) || day.isEditPresent(EditValue.MULTIPLE_ER_DIED_MODIFIERS_PRESENT, EditValue.ER_DIED_MODIFIER_REQUIRES_ER_DIED_OR_TRANSFERRED_PATIENT_STATUS)) continue;
                boolean tProcedureOrComprehensivePresentOnDay = claim.isPrimaryComprehensiveChosen() || day.isStatusIndicatorPresent("T");
                for (LineItemInternal line : day.getLineItemList()) {
                    if (line.matchesHcpcs(HardcodedHcpcsSet.TKA_ANESTHESIA) && claim.getFlags().isSet(ClaimFlags.TOTAL_KNEE_ARTHROPLASTY) || !line.matchesStatusIndicator("C") || !line.getFlags().isNotSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) || !line.getFlags().isNotSet(LineFlags.DATA_HCPCS_SEPARATE_PROCEDURE) && (!line.getFlags().isSet(LineFlags.DATA_HCPCS_SEPARATE_PROCEDURE) || tProcedureOrComprehensivePresentOnDay)) continue;
                    claim.assignEdit(EditValue.PAYABLE_INPATIENT_PROCEDURE_PRESENT, line);
                    line.getFlags().set((LineFlags)new LineFlags[]{LineFlags.INPATIENT_LINE, LineFlags.OBSERVATION_LINE});
                    day.getFlags().set(DayFlags.DAY_DENIED);
                    day.getFlags().set(DayFlags.DAY_DENIED_E1849);
                    claim.getFlags().set(ClaimFlags.DAY_DENIED);
                    claim.getFlags().set(ClaimFlags.DAY_DENIED_E1849);
                }
                if (!day.getFlags().isSet(DayFlags.DAY_DENIED_E1849)) continue;
                for (LineItemInternal line : day.getLineItemList()) {
                    if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                    claim.assignEdit(EditValue.INPATIENT_PROCEDURE_CONFLICT, line);
                    line.getFlags().set(LineFlags.INPATIENT_LINE);
                }
            }
        }
        return false;
    }
}

