/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.OceClaimUtility;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinePrinter
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(LinePrinter.class);
    private final List<String> claimIdList = new ArrayList<String>();

    public LinePrinter() {
    }

    public LinePrinter(String ... claimIdList) {
        for (String claimId : claimIdList) {
            this.claimIdList.add(claimId);
        }
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        if (this.claimIdList.isEmpty() || claim.matchesClaimId(this.claimIdList)) {
            logger.error("==============================================");
            for (LineItemInternal line : navigator.getLineItemList()) {
                OceClaimUtility.print(claim, line, true);
            }
        }
        return false;
    }
}

