/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.dao.data.OffsetApcDao;
import gov.cms.oce.dao.data.row.OffsetApcRowInternal;
import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.HardcodedApcSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.model.rsc.OffsetGroups;
import gov.cms.oce.model.rsc.ValueCodeValue;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import gov.cms.oce.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OffsetDrugBiologicialLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(OffsetDrugBiologicialLogic.class);
    private static final OffsetGroups.OffsetApcGroupId DRUG_BIOLOGICAL = OffsetGroups.OffsetApcGroupId.DRUG_BIOLOGICAL;
    private static final OffsetGroups.OffsetApcListId[] OFFSET_APC_LIST_ID = new OffsetGroups.OffsetApcListId[]{OffsetGroups.OffsetApcListId.PT_CONTRAST, OffsetGroups.OffsetApcListId.PT_SKIN_PRODUCT, OffsetGroups.OffsetApcListId.PT_STRESS_AGENT};

    OffsetDrugBiologicialLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        OffsetApcDao offsetApcDao = processor.getResourceManager().getDataDaoFactory().getOffsetApcDao();
        short version = claim.getVersionAsPrimitive();
        ArrayList<ApcOffsetGroupDay> apcOffsetGroupDayList = null;
        for (Day day : navigator.getDayList()) {
            ArrayList<LineItemInternal> drugBiologicalList = null;
            ArrayList<ApcOffsetGroup> apcOffsetGroupList = null;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_EMPTY_HCPCS, LineFlags.INPUT_INVALID_HCPCS, LineFlags.INPUT_LINE_IGNORED_BY_LIAF)) continue;
                if (line.getFlags().anySet(LineFlags.DATA_HCPCS_PASSTHROUGH_SKIN_PRODUCT, LineFlags.DATA_HCPCS_PASSTHROUGH_CONTRAST, LineFlags.DATA_HCPCS_PASSTHROUGH_STRESS_AGENT)) {
                    if (!line.getFlags().isNotSet(LineFlags.RADIO_PHARMACEUTICAL_CONSUMED)) continue;
                    if (drugBiologicalList == null) {
                        drugBiologicalList = new ArrayList<LineItemInternal>(6);
                    }
                    drugBiologicalList.add(line);
                    continue;
                }
                if (line.matchesApc(HardcodedApcSet.APC_ZERO)) continue;
                String apcValue = line.getPaymentApc().getValue();
                if (apcOffsetGroupList == null) {
                    OffsetApcRowInternal row = offsetApcDao.getRow(DRUG_BIOLOGICAL, OFFSET_APC_LIST_ID, apcValue, (Short)version);
                    if (row == null) continue;
                    apcOffsetGroupList = new ArrayList<ApcOffsetGroup>();
                    apcOffsetGroupList.add(new ApcOffsetGroup(apcValue, row.getAmount(), line.getUnitsAsPrimitive()));
                    continue;
                }
                ApcOffsetGroup existingGroup = null;
                for (ApcOffsetGroup apcOffsetGroup : apcOffsetGroupList) {
                    if (!apcOffsetGroup.apc.equals(apcValue)) continue;
                    existingGroup = apcOffsetGroup;
                    break;
                }
                if (existingGroup == null) {
                    int i;
                    ApcOffsetGroup apcOffsetGroup;
                    OffsetApcRowInternal row = offsetApcDao.getRow(DRUG_BIOLOGICAL, OFFSET_APC_LIST_ID, apcValue, (Short)version);
                    if (row == null) continue;
                    apcOffsetGroup = new ApcOffsetGroup(apcValue, row.getAmount(), line.getUnitsAsPrimitive());
                    for (i = 0; i < apcOffsetGroupList.size() && ((ApcOffsetGroup)apcOffsetGroupList.get(i)).amount >= apcOffsetGroup.amount; ++i) {
                    }
                    apcOffsetGroupList.add(i, apcOffsetGroup);
                    continue;
                }
                Iterator iterator = existingGroup;
                ((ApcOffsetGroup)iterator).units = ((ApcOffsetGroup)iterator).units + line.getUnitsAsPrimitive();
            }
            if (drugBiologicalList == null || apcOffsetGroupList == null) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("No pass-through drugs/biologicals or drug/biological procedures found on day {}", (Object)(day.getIndex() + 1));
                continue;
            }
            if (apcOffsetGroupDayList == null) {
                apcOffsetGroupDayList = new ArrayList<ApcOffsetGroupDay>(navigator.getDayCount() * 2);
            }
            ApcOffsetGroupDay apcOffsetGroupDay = new ApcOffsetGroupDay(apcOffsetGroupList, drugBiologicalList);
            apcOffsetGroupDayList.add(apcOffsetGroupDay);
        }
        if (apcOffsetGroupDayList == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("No pass-through drugs/biologicals or drug/biological procedures found on claim.");
            }
        } else {
            ApcOffsetClaim apcOffsetClaim = new ApcOffsetClaim(apcOffsetGroupDayList);
            apcOffsetClaim.consume(claim);
        }
        return false;
    }

    private final class ApcOffsetClaim {
        private final List<ApcOffsetGroupDay> apcOffsetGroupDayList;

        ApcOffsetClaim(List<ApcOffsetGroupDay> apcOffsetGroupDayList) {
            this.apcOffsetGroupDayList = apcOffsetGroupDayList;
        }

        private final ApcOffsetGroupDay getHighestPayingApcOffsetDay() {
            ApcOffsetGroupDay highestPayingApcOffsetGroupDay = null;
            for (ApcOffsetGroupDay apcOffsetGroupDay : this.apcOffsetGroupDayList) {
                if (!apcOffsetGroupDay.available || highestPayingApcOffsetGroupDay != null && highestPayingApcOffsetGroupDay.getAmount() >= apcOffsetGroupDay.getAmount()) continue;
                highestPayingApcOffsetGroupDay = apcOffsetGroupDay;
            }
            return highestPayingApcOffsetGroupDay;
        }

        private final void consume(OceClaimInternal claim) {
            ApcOffsetGroupDay highestPayingApcOffsetGroupDay;
            if (!claim.getValueCodeOutputList().isValueCodeSet(ValueCodeValue.QR.position) && (highestPayingApcOffsetGroupDay = this.getHighestPayingApcOffsetDay()) != null) {
                highestPayingApcOffsetGroupDay.consume(claim, ValueCodeValue.QR, LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_1ST);
            }
            if (!claim.getValueCodeOutputList().isValueCodeSet(ValueCodeValue.QS.position) && (highestPayingApcOffsetGroupDay = this.getHighestPayingApcOffsetDay()) != null) {
                highestPayingApcOffsetGroupDay.consume(claim, ValueCodeValue.QS, LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_2ND);
            }
            if (!claim.getValueCodeOutputList().isValueCodeSet(ValueCodeValue.QT.position) && (highestPayingApcOffsetGroupDay = this.getHighestPayingApcOffsetDay()) != null) {
                highestPayingApcOffsetGroupDay.consume(claim, ValueCodeValue.QT, LineFlags.PAYMENT_ADJUSTMENT_DRUG_OR_BIOLOGICAL_OFFSET_3RD);
            }
        }
    }

    private final class ApcOffsetGroupDay {
        private final List<LineItemInternal> drugBiologicalList;
        private final List<ApcOffsetGroup> apcOffsetGroupList;
        private boolean available = true;

        private ApcOffsetGroupDay(List<ApcOffsetGroup> apcOffsetGroupList, List<LineItemInternal> drugBiologicalList) {
            this.apcOffsetGroupList = apcOffsetGroupList == null ? Collections.emptyList() : apcOffsetGroupList;
            this.drugBiologicalList = drugBiologicalList == null ? Collections.emptyList() : drugBiologicalList;
        }

        private final int getCount() {
            int drugBiologicalCount = this.drugBiologicalList.size();
            int apcOffsetCount = 0;
            for (ApcOffsetGroup apcOffsetGroup : this.apcOffsetGroupList) {
                apcOffsetCount += apcOffsetGroup.units;
            }
            return drugBiologicalCount < apcOffsetCount ? drugBiologicalCount : apcOffsetCount;
        }

        private final int getAmount(int count) {
            int amount = 0;
            for (ApcOffsetGroup apcOffsetGroup : this.apcOffsetGroupList) {
                if (count < apcOffsetGroup.units) {
                    amount += apcOffsetGroup.amount * count;
                    count = 0;
                } else {
                    amount += apcOffsetGroup.amount * apcOffsetGroup.units;
                    count -= apcOffsetGroup.units;
                }
                if (count >= 1) continue;
                break;
            }
            return amount;
        }

        private final int getAmount() {
            return this.getAmount(this.getCount());
        }

        private final void consume(OceClaimInternal claim, ValueCodeValue valueCodeValue, LineFlags flag) {
            int count = this.getCount();
            StringBuilder amountString = new StringBuilder().append(this.getAmount(count));
            StringUtilities.pad(amountString, 9, '0');
            claim.getValueCodeOutputList().setValue(valueCodeValue.position, valueCodeValue.code, amountString.toString());
            for (LineItemInternal drugBiological : this.drugBiologicalList) {
                drugBiological.getFlags().set(flag);
                if (--count >= 1) continue;
                break;
            }
            this.available = false;
        }
    }

    private final class ApcOffsetGroup {
        private final String apc;
        private final int amount;
        private int units;

        private ApcOffsetGroup(String apc, int amount, int units) {
            this.apc = apc;
            this.amount = amount;
            this.units = units;
        }
    }
}

