/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RevenueCodeRequiresHcpcsLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(RevenueCodeRequiresHcpcsLogic.class);

    RevenueCodeRequiresHcpcsLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (LineItemInternal line : navigator.getLineItemList()) {
            if (!line.getFlags().isSet(LineFlags.INPUT_EMPTY_HCPCS) || !line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_INVALID_REVENUE_CODE, LineFlags.DATA_REVENUE_BYPASS_E48) || line.matchesStatusIndicator("N", "F")) continue;
            claim.assignEdit(EditValue.REVENUE_CODE_REQUIRES_HCPCS, line);
        }
        return false;
    }
}

