/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.RevenueCode;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SameDayMultipleMedicalVisitsLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(SameDayMultipleMedicalVisitsLogic.class);

    SameDayMultipleMedicalVisitsLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            if (day.isEmpty()) continue;
            HashMap<RevenueCode, LineGroup> revenueCodeMap = new HashMap<RevenueCode, LineGroup>();
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE, LineFlags.INPUT_EMPTY_REVENUE_CODE) || !line.matchesStatusIndicator("V")) continue;
                revenueCodeMap.computeIfAbsent(line.getRevenueCode(), v -> new LineGroup()).addLine(line);
            }
            for (LineGroup lineGroup : revenueCodeMap.values()) {
                if (1 >= lineGroup.getTotalUnitCount()) continue;
                for (LineItemInternal line : lineGroup.getLineList()) {
                    claim.assignEdit(EditValue.MULTIPLE_MEDICAL_VISITS_WITHOUT_CCG0_PRESENT, line);
                }
            }
        }
        return false;
    }

    class LineGroup {
        private final List<LineItemInternal> lineList = new ArrayList<LineItemInternal>();

        LineGroup() {
        }

        final List<LineItemInternal> getLineList() {
            return this.lineList;
        }

        final boolean addLine(LineItemInternal line) {
            return this.lineList.add(line);
        }

        final int getTotalUnitCount() {
            return this.lineList.stream().mapToInt(line -> line.getUnitsAsPrimitive()).sum();
        }
    }
}

