/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SkinSubstitute2Logic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(SkinSubstitute2Logic.class);

    SkinSubstitute2Logic() {
    }

    private boolean isLineNotPaired(Day day, LineFlags skinFlag) {
        for (LineItemInternal line : day.getLineItemList()) {
            if (line.getFlags().isSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF) && line.getActionFlag().getValue() != 2 || !line.getFlags().isSet(skinFlag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        for (Day day : processor.getResourceManager().getNavigator().getDayList()) {
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || (!line.getFlags().isSet(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_SG_LO) || !this.isLineNotPaired(day, LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_LO)) && (!line.getFlags().isSet(LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_SG_HI) || !this.isLineNotPaired(day, LineFlags.DATA_HCPCS_SKIN_SUBSTITUTE_HI))) continue;
                claim.assignEdit(EditValue.SKIN_SUBSTITUTE_PROCEDURE_MISSING_PRODUCT, line);
            }
        }
        return false;
    }
}

