/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.logic.processing;

import gov.cms.oce.logic.Logic;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.model.rsc.HardcodedRevenueCodeSet;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.Navigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TraumaResponseCodeRequiresRevenueCodeLogic
implements Logic {
    private static final Logger logger = LoggerFactory.getLogger(TraumaResponseCodeRequiresRevenueCodeLogic.class);

    TraumaResponseCodeRequiresRevenueCodeLogic() {
    }

    @Override
    public final boolean apply(ClaimProcessor processor) {
        OceClaimInternal claim = processor.getInternalClaim();
        Navigator navigator = processor.getResourceManager().getNavigator();
        for (Day day : navigator.getDayList()) {
            boolean traumaCodePresent = false;
            boolean traumaRevenueCodePresent = false;
            boolean criticalCarePresent = false;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE)) continue;
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_TRAUMA_REVENUE_CODE)) {
                    traumaCodePresent = true;
                }
                if (line.getFlags().isSet(LineFlags.DATA_HCPCS_TRAUMA_CRITICAL_CARE)) {
                    criticalCarePresent = true;
                }
                if (!HardcodedRevenueCodeSet.isTrauma(line.getRevenueCode())) continue;
                traumaRevenueCodePresent = true;
            }
            if (!traumaCodePresent || traumaRevenueCodePresent && criticalCarePresent) continue;
            for (LineItemInternal line : day.getLineItemList()) {
                if (!line.getFlags().noneSet(LineFlags.INPUT_LINE_IGNORED_BY_LIAF, LineFlags.INPATIENT_LINE) || !line.getFlags().isSet(LineFlags.DATA_HCPCS_TRAUMA_REVENUE_CODE)) continue;
                claim.assignEdit(EditValue.TRAUMA_RESPONSE_CODE_REQUIRES_REVENUE_CODE_CRITCIAL_CARE, line);
            }
        }
        return false;
    }
}

