/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.external;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceClaimImpl;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceDiagnosisCodeImpl;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceHcpcsModifierImpl;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceLineItemImpl;
import gov.cms.oce.model.external.OceValueCode;
import gov.cms.oce.model.external.OceValueCodeImpl;
import java.util.List;

public final class OceClaimFactory {
    private static final OceClaimFactory INSTANCE = new OceClaimFactory();

    private OceClaimFactory() {
    }

    public static final OceClaimFactory getInstance() {
        return INSTANCE;
    }

    public final OceClaim createClaim() {
        return new OceClaimImpl();
    }

    public final OceDiagnosisCode createDiagnosisCode() {
        return new OceDiagnosisCodeImpl();
    }

    public final OceDiagnosisCode createDiagnosisCode(String diagnosis, String presentOnAdmission) {
        return new OceDiagnosisCodeImpl(diagnosis, presentOnAdmission);
    }

    public final OceHcpcsModifier createHcpcsModifier() {
        return new OceHcpcsModifierImpl();
    }

    public final OceHcpcsModifier createHcpcsModifier(String value) {
        return new OceHcpcsModifierImpl(value);
    }

    public final OceLineItem createLineItem() {
        return new OceLineItemImpl();
    }

    public final OceLineItem createLineItem(String actionFlagInput, String serviceDate, String revenueCode, String hcpcs, List<OceHcpcsModifier> hcpcsModifierInputList, String units, String charge, List<String> contractorEditBypassList, String contractorApc, String contractorStatusIndicator, String contractorPaymentIndicator, String contractorDiscountingFormula, String contractorRejectionDenialFlag, String contractorPackagingFlag, String contractorPaymentAdjustmentFlag01, String contractorPaymentMethodFlag, String contractorPaymentAdjustmentFlag02) {
        return new OceLineItemImpl(actionFlagInput, serviceDate, revenueCode, hcpcs, hcpcsModifierInputList, units, charge, contractorEditBypassList, contractorApc, contractorStatusIndicator, contractorPaymentIndicator, contractorDiscountingFormula, contractorRejectionDenialFlag, contractorPackagingFlag, contractorPaymentAdjustmentFlag01, contractorPaymentMethodFlag, contractorPaymentAdjustmentFlag02);
    }

    public final OceValueCode createValueCode() {
        return new OceValueCodeImpl();
    }

    public final OceValueCode createValueCode(String code, String value) {
        return new OceValueCodeImpl(code, value);
    }
}

