/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.model.internal.DiagnosisCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class DiagnosisCodeList {
    private final List<DiagnosisCode> list = new ArrayList<DiagnosisCode>();

    DiagnosisCodeList() {
    }

    public final List<DiagnosisCode> getValue() {
        return this.list;
    }

    public final int getCount() {
        return this.list.size();
    }

    public final int getIndex(DiagnosisCode diagnosisCode) {
        return this.list.indexOf(diagnosisCode);
    }

    public final void addValue(String code, String presentOnAdmission) {
        DiagnosisCode diagnosisCode = new DiagnosisCode(code);
        diagnosisCode.getPresentOnAdmission().setValue(presentOnAdmission);
        this.list.add(diagnosisCode);
    }

    public final void setValue(int index, String code, String presentOnAdmission) {
        DiagnosisCode diagnosisCode = new DiagnosisCode(code);
        diagnosisCode.getPresentOnAdmission().setValue(presentOnAdmission);
        this.list.set(index, diagnosisCode);
    }

    public final int hashCode() {
        return Objects.hash(this.list);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DiagnosisCodeList o = (DiagnosisCodeList)object;
        return Objects.equals(this.list, o.list);
    }
}

