/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.internal;

import gov.cms.oce.logic.LogicProcessor;
import gov.cms.oce.logic.NoLogicPhasePathFactoryException;
import gov.cms.oce.logic.OceLogicPhasePathFactory;
import gov.cms.oce.logic.UnconfiguredLogicPhasePathException;
import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.OceResourceManager;
import gov.cms.oce.model.rsc.ClaimProcessorFlags;
import gov.cms.oce.processor.ClaimProcessor;
import gov.cms.oce.processor.ResourceManager;
import gov.cms.oce.util.FlagSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OceClaimProcessor
implements ClaimProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OceClaimProcessor.class);
    private final ResourceManager resourceManager = new OceResourceManager();
    private final FlagSet<ClaimProcessorFlags> flags = new FlagSet<ClaimProcessorFlags>(ClaimProcessorFlags.class);
    private OceClaim externalClaim;
    private OceClaimInternal internalClaim;

    @Override
    public final ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public final FlagSet<ClaimProcessorFlags> getFlags() {
        return this.flags;
    }

    @Override
    public final OceClaim getExternalClaim() {
        return this.externalClaim;
    }

    @Override
    public final OceClaimInternal getInternalClaim() {
        return this.internalClaim;
    }

    @Override
    public final boolean process(OceClaim externalClaim) {
        if (logger.isDebugEnabled()) {
            logger.debug("Check/reset processor status.");
        }
        if (this.getFlags().isSet(ClaimProcessorFlags.RESET)) {
            // empty if block
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Initializing internal claim object for claim ID \"{}\"", (Object)externalClaim.getProcessingInformation().getClaimId());
        }
        this.externalClaim = externalClaim;
        this.internalClaim = new OceClaimInternal();
        if (logger.isDebugEnabled()) {
            logger.debug("Register the logic phase path factory for this claim processing job.");
        }
        LogicProcessor logicProcessor = this.resourceManager.getLogicProcessor();
        logicProcessor.register(OceLogicPhasePathFactory.getInstance());
        if (logger.isDebugEnabled()) {
            logger.debug("Configure logic phases using registered logic phase path factory and execute each in serial.");
        }
        try {
            boolean abort = logicProcessor.configureAndExecuteAll(this);
            if (abort && logger.isDebugEnabled()) {
                logger.debug("Abnormal abort reported.");
            }
        }
        catch (NoLogicPhasePathFactoryException e) {
            logger.error("Logic phase path factory is missing.", e);
        }
        catch (UnconfiguredLogicPhasePathException e) {
            logger.error("Logic phase path configuration missing.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Claim processing complete.");
        }
        return false;
    }
}

