/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.model.rsc;

import gov.cms.oce.dao.data.DataApcDao;
import gov.cms.oce.dao.data.row.DataApcRowInternal;
import gov.cms.oce.model.internal.Apc;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.processor.ClaimProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HardcodedApcSet {
    APC_ZERO("00000", 0, 0),
    MH_APC("00034", 0, 61),
    PH_APC1_2009("00172", 0, 61),
    PH_APC2_2009("00173", 0, 61),
    PH_APC1_2011("00175", 0, 61),
    PH_APC2_2011("00176", 0, 61),
    INPATIENT_APC("00375", 0, 61),
    CRITICAL_CARE_APC("05041", 62, 0),
    CMHC_APC1_2016("05851", 62, 65),
    CMHC_APC2_2016("05852", 62, 65),
    CMHC_APC_2017("05853", 66, 0),
    PH_APC1_2016("05861", 62, 65),
    PH_APC2_2016("05862", 62, 65),
    PH_APC_2017("05863", 66, 0),
    CAPC_INPATIENT_APC("05881", 62, 0),
    MH_APC_2016("08010", 62, 0),
    CAPC_OBSERVATION("08011", 62, 0);

    private static final Logger logger;
    private static Map<String, HardcodedApcSet> internalMap;
    private final String apc;
    private final short versionStarted;
    private final short versionEnded;

    private HardcodedApcSet(String apc, short versionStarted, short versionEnded) {
        this.apc = apc;
        this.versionStarted = versionStarted;
        this.versionEnded = versionEnded;
    }

    public static final boolean matchesApc(Apc apc, HardcodedApcSet value) {
        if (apc == null) {
            return false;
        }
        return apc.getValue().equals(value.apc);
    }

    public static final HardcodedApcSet getMentalHealthCompositeApc(OceClaimInternal claim) {
        if (claim.isClaimVersionAfter(65)) {
            return PH_APC_2017;
        }
        if (claim.isClaimVersionAfter(61)) {
            return PH_APC2_2016;
        }
        return PH_APC2_2011;
    }

    public static final HardcodedApcSet getPartialHospitalizationCompositeApc(OceClaimInternal claim, int phpCount) {
        if (claim.matchesBillType("13")) {
            if (claim.isClaimVersionAfter(65)) {
                return PH_APC_2017;
            }
            if (claim.isClaimVersionAfter(61)) {
                return phpCount < 4 ? PH_APC1_2016 : PH_APC2_2016;
            }
            return phpCount < 4 ? PH_APC1_2011 : PH_APC2_2011;
        }
        if (claim.isClaimVersionAfter(65)) {
            return CMHC_APC_2017;
        }
        if (claim.isClaimVersionAfter(61)) {
            return phpCount < 4 ? CMHC_APC1_2016 : CMHC_APC2_2016;
        }
        return phpCount < 4 ? PH_APC1_2009 : PH_APC2_2009;
    }

    public static final int getHardcodedApcPayment(ClaimProcessor processor, HardcodedApcSet apc) {
        DataApcDao dataApcDao = processor.getResourceManager().getDataDaoFactory().getDataApcDao();
        short version = processor.getInternalClaim().getVersionAsPrimitive();
        DataApcRowInternal row = dataApcDao.getRow(apc.getApc(), (Short)version);
        return row == null ? 0 : row.getApcPayment();
    }

    public final String getApc() {
        return this.apc;
    }

    public final short getVersionStarted() {
        return this.versionStarted;
    }

    public final short getVersionEnded() {
        return this.versionEnded;
    }

    public static final HardcodedApcSet getHardcodedApc(String name) {
        return internalMap.get(name);
    }

    static {
        logger = LoggerFactory.getLogger(HardcodedApcSet.class);
        HashMap<String, HardcodedApcSet> tmp = new HashMap<String, HardcodedApcSet>();
        for (HardcodedApcSet hardcodedApc : HardcodedApcSet.values()) {
            tmp.put(hardcodedApc.apc, hardcodedApc);
        }
        internalMap = Collections.unmodifiableMap(tmp);
    }
}

