/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceValueCode;
import gov.cms.oce.model.internal.ConditionCode;
import gov.cms.oce.model.internal.DiagnosisCode;
import gov.cms.oce.model.internal.HcpcsModifier;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OccurrenceCode;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.internal.ValueCode;
import gov.cms.oce.model.rsc.EditValue;
import gov.cms.oce.util.StringUtilities;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.FieldDefinition;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelLogger {
    private static final Logger logger = LoggerFactory.getLogger(ModelLogger.class);

    private ModelLogger() {
        throw new AssertionError();
    }

    public static final synchronized void print(ClaimModel claimModel) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("=======| CDL CLAIM : START (\"{}\") |=======", (Object)claimModel.getRecord("C").get("CId", 0));
        for (RecordModel recordModel : claimModel.getRecords()) {
            RecordDefinition recordDefinition = recordModel.getDefinition();
            logger.trace("R: \"{}\".", (Object)recordDefinition.getId());
            for (FieldDefinition fieldDefinition : recordDefinition.getFields()) {
                if (fieldDefinition.getId().contains("Extra")) continue;
                int counter = -1;
                for (String field : recordModel.get(fieldDefinition)) {
                    logger.trace("F: \"{}\" \"{}\" = \"{}\".", fieldDefinition.getId(), ++counter, field);
                }
            }
        }
        logger.trace("=======| CDL CLAIM : END (\"{}\") |=======", (Object)claimModel.getRecord("C").get("CId", 0));
    }

    public static final synchronized void print(OceClaim claim) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("=======| EXTERNAL CLAIM : START (\"{}\") |=======", (Object)claim.getProcessingInformation().getClaimId());
        logger.trace("DebugFlag=\"{}\"", (Object)claim.getProcessingInformation().getDebugFlag());
        logger.trace("LinesProcessed=\"{}\"", (Object)claim.getProcessingInformation().getLinesProcessed());
        logger.trace("ReturnCode=\"{}\"", (Object)claim.getProcessingInformation().getReturnCode());
        logger.trace("TimeStarted=\"{}\"", (Object)claim.getProcessingInformation().getTimeStarted());
        logger.trace("TimeEnded=\"{}\"", (Object)claim.getProcessingInformation().getTimeEnded());
        logger.trace("Version=\"{}\"", (Object)claim.getProcessingInformation().getVersion());
        logger.trace("Age=\"{}\"", (Object)claim.getAge());
        logger.trace("Sex=\"{}\"", (Object)claim.getSex());
        logger.trace("DateStarted=\"{}\"", (Object)claim.getDateStarted());
        logger.trace("DateEnded=\"{}\"", (Object)claim.getDateEnded());
        logger.trace("ConditionCodeInputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getConditionCodeInputList()));
        logger.trace("OccurrenceCodeInputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getOccurrenceCodeInputList()));
        for (OceValueCode valueCode : claim.getValueCodeInputList()) {
            logger.trace("ValueCodeInputList Code=\"{}\" Value=\"{}\"", (Object)valueCode.getCode(), (Object)valueCode.getValue());
        }
        logger.trace("BillType=\"{}\"", (Object)claim.getBillType());
        logger.trace("NationalProviderId=\"{}\"", (Object)claim.getNationalProviderId());
        logger.trace("CmsCertificationNumber=\"{}\"", (Object)claim.getCmsCertificationNumber());
        logger.trace("PatientStatus=\"{}\"", (Object)claim.getPatientStatus());
        logger.trace("OppsFlag=\"{}\"", (Object)claim.getOppsFlag());
        logger.trace("PrincipalDiagnosisCode=\"{}\" POA=\"{}\"", (Object)claim.getPrincipalDiagnosisCode().getDiagnosis(), (Object)claim.getPrincipalDiagnosisCode().getPresentOnAdmission());
        logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getPrincipalDiagnosisCode().getEditList()));
        for (OceDiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList()) {
            logger.trace("ReasonForVisitDiagnosisCode=\"{}\" POA=\"{}\"", (Object)diagnosisCode.getDiagnosis(), (Object)diagnosisCode.getPresentOnAdmission());
            logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), diagnosisCode.getEditList()));
        }
        for (OceDiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList()) {
            logger.trace("SecondaryDiagnosisCode=\"{}\" POA=\"{}\"", (Object)diagnosisCode.getDiagnosis(), (Object)diagnosisCode.getPresentOnAdmission());
            logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), diagnosisCode.getEditList()));
        }
        int lineCounter = -1;
        for (OceLineItem lineItem : claim.getLineItemList()) {
            logger.trace("Line=\"{}\"", (Object)(++lineCounter));
            ModelLogger.print(lineItem);
        }
        logger.trace("ClaimProcessedFlag=\"{}\"", (Object)claim.getClaimProcessedFlag());
        logger.trace("ClaimDisposition=\"{}\"", (Object)claim.getClaimDisposition());
        logger.trace("ClaimRejectionDisposition=\"{}\"", (Object)claim.getClaimRejectionDisposition());
        logger.trace("ClaimDenialDisposition=\"{}\"", (Object)claim.getClaimDenialDisposition());
        logger.trace("ClaimSuspensionDisposition=\"{}\"", (Object)claim.getClaimSuspensionDisposition());
        logger.trace("ClaimReturnToProviderDisposition=\"{}\"", (Object)claim.getClaimReturnToProviderDisposition());
        logger.trace("LineRejectionDisposition=\"{}\"", (Object)claim.getLineRejectionDisposition());
        logger.trace("LineDenialDisposition=\"{}\"", (Object)claim.getLineDenialDisposition());
        logger.trace("ClaimRejectionEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getClaimRejectionEditList()));
        logger.trace("ClaimDenialEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getClaimDenialEditList()));
        logger.trace("ClaimReturnToProviderEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getClaimReturnToProviderEditList()));
        logger.trace("ClaimSuspensionEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getClaimSuspensionEditList()));
        logger.trace("LineRejectionEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getLineRejectionEditList()));
        logger.trace("LineDenialEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getLineDenialEditList()));
        logger.trace("ApcReturnBufferFlag=\"{}\"", (Object)claim.getApcReturnBufferFlag());
        logger.trace("NoppsBillFlag=\"{}\"", (Object)claim.getNoppsBillFlag());
        logger.trace("ConditionCodeOutputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getConditionCodeOutputList()));
        for (OceValueCode valueCode : claim.getValueCodeOutputList()) {
            logger.trace("ValueCodeOutputList Code=\"{}\" Value=\"{}\"", (Object)valueCode.getCode(), (Object)valueCode.getValue());
        }
        logger.trace("=======| EXTERNAL CLAIM : END (\"{}\") |=======", (Object)claim.getProcessingInformation().getClaimId());
    }

    public static final synchronized void print(OceLineItem lineItem) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("ActionFlagInput=\"{}\"", (Object)lineItem.getActionFlagInput());
        logger.trace("ServiceDate=\"{}\"", (Object)lineItem.getServiceDate());
        logger.trace("ServiceDateEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getServiceDateEditList()));
        logger.trace("RevenueCode=\"{}\"", (Object)lineItem.getRevenueCode());
        logger.trace("RevenueEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getRevenueEditList()));
        logger.trace("HCPCS=\"{}\"", (Object)lineItem.getHcpcs());
        logger.trace("HcpcsEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getHcpcsEditList()));
        for (OceHcpcsModifier hcpcsModifier : lineItem.getHcpcsModifierInputList()) {
            logger.trace("HcpcsModifier=\"{}\"", (Object)hcpcsModifier.getHcpcsModifier());
            logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), hcpcsModifier.getEditList()));
        }
        logger.trace("UnitsInput=\"{}\"", (Object)lineItem.getUnitsInput());
        logger.trace("Charge=\"{}\"", (Object)lineItem.getCharge());
        logger.trace("ContractorEditBypassList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getContractorEditBypassList()));
        logger.trace("ContractorApc=\"{}\"", (Object)lineItem.getContractorApc());
        logger.trace("ContractorStatusIndicator=\"{}\"", (Object)lineItem.getContractorStatusIndicator());
        logger.trace("ContractorPaymentIndicator=\"{}\"", (Object)lineItem.getContractorPaymentIndicator());
        logger.trace("ContractorDiscountingFormula=\"{}\"", (Object)lineItem.getContractorDiscountingFormula());
        logger.trace("ContractorRejectionDenialFlag=\"{}\"", (Object)lineItem.getContractorRejectionDenialFlag());
        logger.trace("ContractorPackagingFlag=\"{}\"", (Object)lineItem.getContractorPackagingFlag());
        logger.trace("ContractorPaymentAdjustmentFlag=\"{}\"", (Object)lineItem.getContractorPaymentAdjustmentFlag01());
        logger.trace("ContractorPaymentMethodFlag=\"{}\"", (Object)lineItem.getContractorPaymentMethodFlag());
        logger.trace("ActionFlagOutput=\"{}\"", (Object)lineItem.getActionFlagOutput());
        logger.trace("HcpcsApc=\"{}\"", (Object)lineItem.getHcpcsApc());
        logger.trace("PaymentApc=\"{}\"", (Object)lineItem.getPaymentApc());
        logger.trace("StatusIndicator=\"{}\"", (Object)lineItem.getStatusIndicator());
        logger.trace("PaymentIndicator=\"{}\"", (Object)lineItem.getPaymentIndicator());
        logger.trace("DiscountingFormula=\"{}\"", (Object)lineItem.getDiscountingFormula());
        logger.trace("RejectionDenialFlag=\"{}\"", (Object)lineItem.getRejectionDenialFlag());
        logger.trace("PackagingFlag=\"{}\"", (Object)lineItem.getPackagingFlag());
        logger.trace("PaymentAdjustmentFlag=\"{}\"", (Object)lineItem.getPaymentAdjustmentFlag01());
        logger.trace("PaymentMethodFlag=\"{}\"", (Object)lineItem.getPaymentMethodFlag());
        logger.trace("CompositeAdjustmentFlag=\"{}\"", (Object)lineItem.getCompositeAdjustmentFlag());
        logger.trace("UnitsOutput=\"{}\"", (Object)lineItem.getUnitsOutput());
        logger.trace("HcpcsModifierOutputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getHcpcsModifierOutputList().stream().map(OceHcpcsModifier::getHcpcsModifier).collect(Collectors.toList())));
    }

    public static final synchronized void print(OceClaimInternal claim) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("=======| INTERNAL CLAIM : START (\"{}\") |=======", (Object)claim.getProcessingInformation().getClaimId());
        logger.trace("DebugFlag=\"{}\"", (Object)claim.getProcessingInformation().getDebugFlag());
        logger.trace("LinesProcessed=\"{}\"", (Object)claim.getProcessingInformation().getLinesProcessed());
        logger.trace("ReturnCode=\"{}\"", (Object)claim.getProcessingInformation().getReturnCode());
        logger.trace("TimeStarted=\"{}\"", (Object)claim.getProcessingInformation().getTimeStarted());
        logger.trace("TimeEnded=\"{}\"", (Object)claim.getProcessingInformation().getTimeEnded());
        logger.trace("Version=\"{}\"", (Object)claim.getProcessingInformation().getVersion());
        logger.trace("Age=\"{}\"", (Object)claim.getAge().getValue());
        logger.trace("Sex=\"{}\"", (Object)claim.getSex().getValue());
        logger.trace("DateStarted=\"{}\"", (Object)claim.getDateStarted().getValue());
        logger.trace("DateEnded=\"{}\"", (Object)claim.getDateEnded().getValue());
        logger.trace("ConditionCodeInputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getConditionCodeInputList().getValue().stream().map(ConditionCode::getValue).collect(Collectors.toList())));
        logger.trace("OccurrenceCodeInputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getOccurrenceCodeInputList().getValue().stream().map(OccurrenceCode::getValue).collect(Collectors.toList())));
        for (ValueCode valueCode : claim.getValueCodeInputList().getValue()) {
            logger.trace("ValueCodeInputList Code=\"{}\" Value=\"{}\"", (Object)valueCode.getCode(), (Object)valueCode.getValue());
        }
        logger.trace("BillType=\"{}\"", (Object)claim.getBillType().getValue());
        logger.trace("NationalProviderId=\"{}\"", (Object)claim.getNationalProviderId().getValue());
        logger.trace("CmsCertificationNumber=\"{}\"", (Object)claim.getCmsCertificationNumber().getValue());
        logger.trace("PatientStatus=\"{}\"", (Object)claim.getPatientStatus().getValue());
        logger.trace("OppsFlag=\"{}\"", (Object)claim.getOppsFlag().getValue());
        logger.trace("PrincipalDiagnosisCode=\"{}\" POA=\"{}\"", (Object)claim.getPrincipalDiagnosisCode().getValue(), (Object)claim.getPrincipalDiagnosisCode().getPresentOnAdmission().getValue());
        logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getPrincipalDiagnosisCode().getEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        for (DiagnosisCode diagnosisCode : claim.getReasonForVisitDiagnosisCodeList().getValue()) {
            logger.trace("ReasonForVisitDiagnosisCode=\"{}\" POA=\"{}\"", (Object)diagnosisCode.getValue(), (Object)diagnosisCode.getPresentOnAdmission().getValue());
            logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), diagnosisCode.getEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        }
        for (DiagnosisCode diagnosisCode : claim.getSecondaryDiagnosisCodeList().getValue()) {
            logger.trace("SecondaryDiagnosisCode=\"{}\" POA=\"{}\"", (Object)diagnosisCode.getValue(), (Object)diagnosisCode.getPresentOnAdmission().getValue());
            logger.trace("Edits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), diagnosisCode.getEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        }
        int lineCounter = -1;
        for (LineItemInternal lineItem : claim.getLineItemList().getValue()) {
            logger.trace("Line=\"{}\"", (Object)(++lineCounter));
            ModelLogger.print(lineItem);
        }
        logger.trace("ClaimProcessedFlag=\"{}\"", (Object)claim.getClaimProcessedFlag().getValue());
        logger.trace("ClaimDisposition=\"{}\"", (Object)claim.getClaimDisposition().getValue());
        logger.trace("ClaimRejectionDisposition=\"{}\"", (Object)claim.getClaimRejectionDisposition().getValue());
        logger.trace("ClaimDenialDisposition=\"{}\"", (Object)claim.getClaimDenialDisposition().getValue());
        logger.trace("ClaimSuspensionDisposition=\"{}\"", (Object)claim.getClaimSuspensionDisposition().getValue());
        logger.trace("ClaimReturnToProviderDisposition=\"{}\"", (Object)claim.getClaimReturnToProviderDisposition().getValue());
        logger.trace("LineRejectionDisposition=\"{}\"", (Object)claim.getLineRejectionDisposition().getValue());
        logger.trace("LineDenialDisposition=\"{}\"", (Object)claim.getLineDenialDisposition().getValue());
        logger.trace("ClaimRejectionEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getClaimRejectionEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        logger.trace("ClaimDenialEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getClaimDenialEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        logger.trace("ClaimReturnToProviderEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getReturnToProviderEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        logger.trace("ClaimSuspensionEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getSuspensionEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        logger.trace("LineRejectionEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getLineRejectionEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        logger.trace("LineDenialEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getLineDenialEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        logger.trace("ApcReturnBufferFlag=\"{}\"", (Object)claim.getApcReturnBufferFlag().getValue());
        logger.trace("NoppsBillFlag=\"{}\"", (Object)claim.getNoppsBillFlag().getValue());
        logger.trace("ConditionCodeOutputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), claim.getConditionCodeOutputList().getValue().stream().map(ConditionCode::getValue).collect(Collectors.toList())));
        for (ValueCode valueCode : claim.getValueCodeOutputList().getValue()) {
            logger.trace("ValueCodeOutputList Code=\"{}\" Value=\"{}\"", (Object)valueCode.getCode(), (Object)valueCode.getValue());
        }
        logger.trace("=======| INTERNAL CLAIM : END (\"{}\") |=======", (Object)claim.getProcessingInformation().getClaimId());
    }

    public static final synchronized void print(LineItemInternal lineItem) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("=======| INTERNAL LINE : START |=======");
        logger.trace("ActionFlagInput=\"{}\"", (Object)lineItem.getActionFlag().getValue());
        logger.trace("ServiceDate=\"{}\"", (Object)lineItem.getServiceDate().getValue());
        logger.trace("RevenueCode=\"{}\"", (Object)lineItem.getRevenueCode().getValue());
        logger.trace("HCPCS=\"{}\"", (Object)lineItem.getHcpcs().getValue());
        logger.trace("LineEditList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        for (HcpcsModifier hcpcsModifier : lineItem.getHcpcsModifierInputList().getValue()) {
            logger.trace("HcpcsModifierInput=\"{}\"", (Object)hcpcsModifier.getValue());
            logger.trace("HcpcsModifierInputEdits=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), hcpcsModifier.getEditList().stream().map(e -> e.getEditValue().getValue()).collect(Collectors.toList())));
        }
        logger.trace("UnitsInput=\"{}\"", (Object)lineItem.getUnits().getValue());
        logger.trace("Charge=\"{}\"", (Object)lineItem.getCharge().getValue());
        logger.trace("ContractorEditBypassList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getEditBypass().getEditBypassList().getValue().stream().map(EditValue::getValue).collect(Collectors.toList())));
        logger.trace("ContractorApc=\"{}\"", (Object)lineItem.getEditBypass().getApc().getValue());
        logger.trace("ContractorStatusIndicator=\"{}\"", (Object)lineItem.getEditBypass().getStatusIndicator().getValue());
        logger.trace("ContractorPaymentIndicator=\"{}\"", (Object)lineItem.getEditBypass().getPaymentIndicator().getValue());
        logger.trace("ContractorDiscountingFormula=\"{}\"", (Object)lineItem.getEditBypass().getDiscountingFormula().getValue());
        logger.trace("ContractorRejectionDenialFlag=\"{}\"", (Object)lineItem.getEditBypass().getRejectionDenialFlag().getValue());
        logger.trace("ContractorPackagingFlag=\"{}\"", (Object)lineItem.getEditBypass().getPackagingFlag().getValue());
        logger.trace("ContractorPaymentAdjustmentFlag01=\"{}\"", (Object)lineItem.getEditBypass().getPaymentAdjustmentFlag01().getValue());
        logger.trace("ContractorPaymentMethodFlag=\"{}\"", (Object)lineItem.getEditBypass().getPaymentMethodFlag().getValue());
        logger.trace("ContractorPaymentAdjustmentFlag02=\"{}\"", (Object)lineItem.getEditBypass().getPaymentAdjustmentFlag02().getValue());
        logger.trace("ActionFlagOutput=\"{}\"", (Object)lineItem.getActionFlag().getValue());
        logger.trace("HcpcsApc=\"{}\"", (Object)lineItem.getHcpcsApc().getValue());
        logger.trace("PaymentApc=\"{}\"", (Object)lineItem.getPaymentApc().getValue());
        logger.trace("StatusIndicator=\"{}\"", (Object)lineItem.getStatusIndicator().getValue());
        logger.trace("PaymentIndicator=\"{}\"", (Object)lineItem.getPaymentIndicator().getValue());
        logger.trace("DiscountingFormula=\"{}\"", (Object)lineItem.getDiscountingFormula().getValue());
        logger.trace("RejectionDenialFlag=\"{}\"", (Object)lineItem.getRejectionDenialFlag().getValue());
        logger.trace("PackagingFlag=\"{}\"", (Object)lineItem.getPackagingFlag().getValue());
        logger.trace("PaymentAdjustmentFlag01=\"{}\"", (Object)lineItem.getPaymentAdjustmentFlag01().getValue());
        logger.trace("PaymentMethodFlag=\"{}\"", (Object)lineItem.getPaymentMethodFlag().getValue());
        logger.trace("CompositeAdjustmentFlag=\"{}\"", (Object)lineItem.getCompositeAdjustmentFlag().getValue());
        logger.trace("UnitsOutput=\"{}\"", (Object)lineItem.getUnits().getValue());
        logger.trace("HcpcsModifierOutputList=\"{}\"", (Object)StringUtilities.concatenator(new StringBuilder(), lineItem.getHcpcsModifierOutputList().getValue().stream().map(HcpcsModifier::getValue).collect(Collectors.toList())));
        logger.trace("PaymentAdjustmentFlag02=\"{}\"", (Object)lineItem.getPaymentAdjustmentFlag02().getValue());
        logger.trace("=======| INTERNAL LINE : END |=======");
    }
}

