/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util;

import gov.cms.oce.logic.PolicyConfiguration;
import gov.cms.oce.model.internal.ClaimDate;
import gov.cms.oce.model.internal.LineItemInternal;
import gov.cms.oce.model.internal.OceClaimInternal;
import gov.cms.oce.model.rsc.ClaimFlags;
import gov.cms.oce.model.rsc.LineFlags;
import gov.cms.oce.util.DateRange;
import gov.cms.oce.util.Day;
import gov.cms.oce.util.DaySpan;
import gov.cms.oce.util.LineSpan;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Navigator {
    private static final Logger logger = LoggerFactory.getLogger(Navigator.class);
    private OceClaimInternal claim;
    private List<Day> dayList;
    private List<DaySpan> weekList;
    private DateRange claimDateRange;
    private DateRange serviceDateRange;
    private DateRange dayDateRange;
    private boolean initialized;

    public Navigator() {
    }

    public Navigator(OceClaimInternal claim) {
        this.initialize(claim);
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final boolean initialize(OceClaimInternal claim) {
        this.claim = claim;
        try {
            this.createClaimDateRange();
            this.createServiceDateRange();
            this.createDayDateRange();
            this.createDayAndWeekLists();
            this.initialized = true;
        }
        catch (Exception e) {
            logger.error("Navigator initialization failed.", e);
        }
        return this.initialized;
    }

    public final DateRange getClaimDateRange() {
        return this.claimDateRange;
    }

    public final DateRange getServiceDateRange() {
        return this.serviceDateRange;
    }

    public final int getLineItemCount() {
        return this.claim.getLineItemList().getValue().size();
    }

    public final List<LineItemInternal> getLineItemList() {
        return this.claim.getLineItemList().getValue();
    }

    public final Iterator<LineItemInternal> lineIterator() {
        return this.claim.getLineItemList().getValue().listIterator();
    }

    public final int getDayCount() {
        return this.dayList == null ? 0 : this.dayList.size();
    }

    public final List<Day> getDayList() {
        return this.dayList;
    }

    public final Iterator<Day> dayIterator() {
        return this.dayList.listIterator();
    }

    public final int getWeekCount() {
        return this.weekList == null ? 0 : this.weekList.size();
    }

    public final List<DaySpan> getWeekList() {
        return this.weekList;
    }

    public final Iterator<DaySpan> weekIterator() {
        return this.weekList.listIterator();
    }

    private final void createClaimDateRange() {
        ClaimDate dateStarted = this.claim.getDateStarted();
        ClaimDate dateEnded = this.claim.getDateEnded();
        if (dateStarted.isValid() && dateEnded.isValid()) {
            if (this.claim.getFlags().isSet(ClaimFlags.INPUT_DATE_STARTED_AFTER_DATE_ENDED)) {
                if (PolicyConfiguration.getPolicy(PolicyConfiguration.AUTO_CORRECT_CLAIM_DATES) == 1) {
                    this.claimDateRange = new DateRange(dateEnded.getValueAsDate(), dateStarted.getValueAsDate());
                }
            } else {
                this.claimDateRange = new DateRange(dateStarted.getValueAsDate(), dateEnded.getValueAsDate());
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn("Claim date range could not be created given invalid start date: \"{}\" and/or invalid end date: \"{}\".", (Object)dateStarted.getValue(), (Object)dateEnded.getValue());
        }
    }

    private final void createServiceDateRange() {
        LocalDate earliestDate = null;
        LocalDate latestDate = null;
        for (LineItemInternal line : this.claim.getLineItemList().getValue()) {
            if (line.getServiceDate().isValid()) {
                LocalDate serviceDate = line.getServiceDate().getValueAsDate();
                if (earliestDate == null) {
                    earliestDate = serviceDate;
                    latestDate = serviceDate;
                } else if (serviceDate.isAfter(latestDate)) {
                    latestDate = serviceDate;
                } else if (serviceDate.isBefore(earliestDate)) {
                    earliestDate = serviceDate;
                }
                if (serviceDate.isBefore(this.claimDateRange.getDateStarted())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Line service date is earlier than claim start date line \"{}\".", (Object)(this.claim.getLineItemList().getValue().indexOf(line) + 1));
                    }
                    line.getFlags().set(LineFlags.INPUT_SERVICE_DATE_EARLIER_THAN_CLAIM_START_DATE);
                    continue;
                }
                if (!serviceDate.isAfter(this.claimDateRange.getDateEnded())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Line service date is later than claim end date line \"{}\".", (Object)(this.claim.getLineItemList().getValue().indexOf(line) + 1));
                }
                line.getFlags().set(LineFlags.INPUT_SERVICE_DATE_LATER_THAN_CLAIM_END_DATE);
                continue;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn("Service date range could not be created given invalid service date: \"{}\".", (Object)earliestDate);
        }
        if (earliestDate != null) {
            this.serviceDateRange = new DateRange(earliestDate, latestDate);
        } else if (logger.isWarnEnabled()) {
            logger.warn("Service date range could not be created given earliest service date: \"{}\" and latest service date: \"{}\"", (Object)earliestDate, (Object)latestDate);
        }
    }

    private final void createDayDateRange() {
        LocalDate earliestDate = null;
        earliestDate = this.claimDateRange.getDateStarted().isBefore(this.serviceDateRange.getDateStarted()) ? this.claimDateRange.getDateStarted() : this.serviceDateRange.getDateStarted();
        LocalDate latestDate = null;
        latestDate = this.claimDateRange.getDateEnded().isAfter(this.serviceDateRange.getDateEnded()) ? this.claimDateRange.getDateEnded() : this.serviceDateRange.getDateEnded();
        this.dayDateRange = new DateRange(earliestDate, latestDate);
    }

    private final void createDayAndWeekLists() {
        int daySpan = (int)this.dayDateRange.getDaySpan();
        if (0 < daySpan) {
            ArrayList<DaySpan> temporaryWeekList = new ArrayList<DaySpan>(7);
            ArrayList<Day> temporaryDayList = new ArrayList<Day>(daySpan);
            DaySpan temporaryWeek = null;
            Day temporaryDay = null;
            LocalDate currentDate = LocalDate.ofEpochDay(this.dayDateRange.getDateStarted().toEpochDay());
            int index = 0;
            do {
                LocalDate dateCopy = LocalDate.ofEpochDay(currentDate.toEpochDay());
                temporaryDay = new Day(index, dateCopy);
                temporaryDayList.add(temporaryDay);
                if (temporaryWeek == null || currentDate.getDayOfWeek() == DayOfWeek.SUNDAY) {
                    temporaryWeek = new DaySpan(temporaryWeekList.size(), dateCopy);
                    temporaryWeekList.add(temporaryWeek);
                }
                temporaryWeek.getList().add(temporaryDay);
                currentDate = currentDate.plusDays(1L);
            } while (++index < daySpan);
            Day firstDay = (Day)temporaryDayList.get(0);
            if (firstDay == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("No day objects created for claim \"{}\". This indicates that no valid line items exist on the claim.", (Object)this.claim.getClaimId());
                }
            } else {
                for (LineItemInternal line : this.claim.getLineItemList().getValue()) {
                    if (line.getServiceDate().isValid()) {
                        index = (int)ChronoUnit.DAYS.between(firstDay.getDate(), line.getServiceDate().getValueAsDate());
                        Day day = (Day)temporaryDayList.get(index);
                        day.getLineItemList().add(line);
                        line.setDay(day);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Line couldn't be included in day object as service date is invalid.");
                }
            }
            temporaryWeekList.trimToSize();
            this.weekList = Collections.unmodifiableList(temporaryWeekList);
            temporaryDayList.trimToSize();
            this.dayList = Collections.unmodifiableList(temporaryDayList);
        } else if (logger.isWarnEnabled()) {
            logger.warn("Claim \"{}\" contains no days.", (Object)this.claim.getClaimId());
        }
    }

    public final List<DaySpan> getDaySpanList(int daySpan, int dayOffset) {
        ArrayList<DaySpan> daySpanList = new ArrayList<DaySpan>(8);
        int daySpanIndex = -1;
        for (Day day : this.dayList) {
            if (0 < dayOffset && daySpanIndex < 0 || (dayOffset + day.getIndex()) % daySpan == 0) {
                daySpanList.add(new DaySpan(++daySpanIndex, day.getDate()));
            }
            ((DaySpan)daySpanList.get(daySpanIndex)).getList().add(day);
        }
        daySpanList.trimToSize();
        return Collections.unmodifiableList(daySpanList);
    }

    public final List<DaySpan> getDaySpanList(int daySpan) {
        return this.getDaySpanList(daySpan, 0);
    }

    public final List<DaySpan> getFollowingDayWindowList(int daySpan) {
        if (daySpan < 1) {
            throw new IllegalArgumentException("Windowing day functions require a day span value of 1 or more.");
        }
        ArrayList<DaySpan> daySpanList = new ArrayList<DaySpan>(8);
        int dayListSize = this.dayList.size();
        int daySpanIndex = -1;
        for (Day day : this.dayList) {
            DaySpan currentSpan = new DaySpan(++daySpanIndex, day.getDate());
            int dayCountLimit = daySpanIndex + daySpan < dayListSize ? daySpanIndex + daySpan : dayListSize;
            for (int dayCounter = daySpanIndex; dayCounter < dayCountLimit; ++dayCounter) {
                currentSpan.getList().add(this.dayList.get(dayCounter));
            }
            daySpanList.add(currentSpan);
        }
        daySpanList.trimToSize();
        return Collections.unmodifiableList(daySpanList);
    }

    public final List<DaySpan> getPrecedingDayWindowList(int daySpan) {
        if (daySpan < 1) {
            throw new IllegalArgumentException("Windowing day functions require a day span value of 1 or more.");
        }
        ArrayList<DaySpan> daySpanList = new ArrayList<DaySpan>(8);
        int daySpanIndex = -1;
        for (Day day : this.dayList) {
            int dayCounter;
            DaySpan currentSpan = new DaySpan(++daySpanIndex, day.getDate());
            int dayCountLimit = daySpanIndex;
            int n = dayCounter = daySpanIndex < daySpan ? 0 : daySpanIndex - daySpan + 1;
            while (dayCounter <= dayCountLimit) {
                currentSpan.getList().add(this.dayList.get(dayCounter));
                ++dayCounter;
            }
            daySpanList.add(currentSpan);
        }
        daySpanList.trimToSize();
        return Collections.unmodifiableList(daySpanList);
    }

    public final List<LineSpan> getFollowingLineWindowList(int daySpan) {
        List<DaySpan> daySpanList = this.getFollowingDayWindowList(daySpan);
        ArrayList<LineSpan> lineSpanList = new ArrayList<LineSpan>(8);
        int daySpanIndex = -1;
        for (DaySpan currentDaySpan : daySpanList) {
            LineSpan currentLineSpan = new LineSpan(++daySpanIndex);
            for (Day day : currentDaySpan.getList()) {
                for (LineItemInternal line : day.getLineItemList()) {
                    currentLineSpan.getList().add(line);
                }
            }
            lineSpanList.add(currentLineSpan);
        }
        lineSpanList.trimToSize();
        return Collections.unmodifiableList(lineSpanList);
    }

    public final List<LineSpan> getPrecedingLineWindowList(int daySpan) {
        List<DaySpan> daySpanList = this.getPrecedingDayWindowList(daySpan);
        ArrayList<LineSpan> lineSpanList = new ArrayList<LineSpan>(8);
        int daySpanIndex = -1;
        for (DaySpan currentDaySpan : daySpanList) {
            LineSpan currentLineSpan = new LineSpan(++daySpanIndex);
            for (Day day : currentDaySpan.getList()) {
                for (LineItemInternal line : day.getLineItemList()) {
                    currentLineSpan.getList().add(line);
                }
            }
            lineSpanList.add(currentLineSpan);
        }
        lineSpanList.trimToSize();
        return Collections.unmodifiableList(lineSpanList);
    }
}

