/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter;

import gov.cms.oce.model.external.OceClaim;
import gov.cms.oce.model.external.OceClaimFactory;
import gov.cms.oce.model.external.OceDiagnosisCode;
import gov.cms.oce.model.external.OceHcpcsModifier;
import gov.cms.oce.model.external.OceLineItem;
import gov.cms.oce.model.external.OceValueCode;
import gov.cms.oce.util.converter.rsc.UnexpectedInputLengthException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringClaimToOceClaimConverter {
    private static final Logger logger = LoggerFactory.getLogger(StringClaimToOceClaimConverter.class);

    public final OceClaim convert(String buffer) {
        String tmpPoa;
        String tmpDx;
        int i;
        List<Object> list;
        if (buffer.length() != 35011) {
            throw new UnexpectedInputLengthException("Claim input string length does not match expected length (35011).");
        }
        OceClaim claim = OceClaimFactory.getInstance().createClaim();
        claim.getProcessingInformation().setClaimId(buffer.substring(0, 17).trim());
        claim.setAge(buffer.substring(17, 20).trim());
        claim.setSex(buffer.substring(20, 21).trim());
        claim.setDateStarted(buffer.substring(21, 29).trim());
        claim.setDateEnded(buffer.substring(29, 37).trim());
        claim.setBillType(buffer.substring(37, 40).trim());
        claim.setNationalProviderId(buffer.substring(40, 53).trim());
        claim.setCmsCertificationNumber(buffer.substring(53, 59).trim());
        claim.setPatientStatus(buffer.substring(59, 61).trim());
        claim.setOppsFlag(buffer.substring(61, 62).trim());
        String tmp = buffer.substring(62, 122);
        if ("".equals(tmp.trim())) {
            if (logger.isTraceEnabled()) {
                logger.trace("No occurrence code input to load.");
            }
        } else {
            list = claim.getOccurrenceCodeInputList();
            for (i = 0; i < 30; ++i) {
                list.add(tmp.substring(i * 2, i * 2 + 2).trim());
            }
        }
        if ("".equals((tmp = buffer.substring(122, 182)).trim())) {
            if (logger.isTraceEnabled()) {
                logger.trace("No condition code input to load.");
            }
        } else {
            list = claim.getConditionCodeInputList();
            for (i = 0; i < 30; ++i) {
                list.add(tmp.substring(i * 2, i * 2 + 2).trim());
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Loading reason for visit diagnosis codes.");
        }
        if ("".equals((tmp = buffer.substring(182, 206)).trim())) {
            if (logger.isTraceEnabled()) {
                logger.trace("No reason for visit diagnosis codes to load.");
            }
        } else {
            list = claim.getReasonForVisitDiagnosisCodeList();
            for (i = 0; i < 3 && !"".equals(tmpDx = tmp.substring(i * 8, i * 8 + 7).trim()); ++i) {
                list.add((String)((Object)OceClaimFactory.getInstance().createDiagnosisCode()));
                ((OceDiagnosisCode)list.get(i)).setDiagnosis(tmpDx);
                tmpPoa = tmp.substring(i * 8 + 7, i * 8 + 8).trim();
                if ("".equals(tmpPoa)) continue;
                ((OceDiagnosisCode)list.get(i)).setPresentOnAdmission(tmpPoa);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Loading principal diagnosis code.");
        }
        claim.setPrincipalDiagnosisCode(OceClaimFactory.getInstance().createDiagnosisCode());
        tmp = buffer.substring(206, 214);
        if ("".equals(tmp.trim())) {
            logger.trace("No principal diagnosis to load.");
        } else {
            String tmpPoa2;
            String tmpDx2 = tmp.substring(0, 7).trim();
            if (!"".equals(tmpDx2)) {
                claim.getPrincipalDiagnosisCode().setDiagnosis(tmpDx2);
            }
            if (!"".equals(tmpPoa2 = tmp.substring(7).trim())) {
                claim.getPrincipalDiagnosisCode().setPresentOnAdmission(tmpPoa2);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Loading secondary diagnosis codes.");
        }
        if ("".equals((tmp = buffer.substring(214, 406)).trim())) {
            if (logger.isTraceEnabled()) {
                logger.trace("No secondary diagnosis codes to load.");
            }
        } else {
            list = claim.getSecondaryDiagnosisCodeList();
            for (int i2 = 0; i2 < 24 && !"".equals(tmpDx = tmp.substring(i2 * 8, i2 * 8 + 7).trim()); ++i2) {
                list.add(OceClaimFactory.getInstance().createDiagnosisCode());
                ((OceDiagnosisCode)list.get(i2)).setDiagnosis(tmpDx);
                tmpPoa = tmp.substring(i2 * 8 + 7, i2 * 8 + 8).trim();
                if ("".equals(tmpPoa)) continue;
                ((OceDiagnosisCode)list.get(i2)).setPresentOnAdmission(tmpPoa);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Loading value codes.");
        }
        if ("".equals((tmp = buffer.substring(406, 802)).trim())) {
            if (logger.isTraceEnabled()) {
                logger.trace("No value codes to load.");
            }
        } else {
            String tmpCode;
            list = claim.getValueCodeInputList();
            for (int i3 = 0; i3 < 36 && !"".equals(tmpCode = tmp.substring(i3 * 11, i3 * 11 + 2).trim()); ++i3) {
                list.add(OceClaimFactory.getInstance().createValueCode());
                ((OceValueCode)list.get(i3)).setCode(tmpCode);
                String tmpValue = tmp.substring(i3 * 11 + 2, i3 * 11 + 11).trim();
                ((OceValueCode)list.get(i3)).setValue(tmpValue);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Receipt Date");
        }
        claim.setReceiptDate(buffer.substring(802, 810).trim());
        if (logger.isTraceEnabled()) {
            logger.trace("Debug Flag");
        }
        tmp = buffer.substring(810, 811).trim();
        claim.getProcessingInformation().setDebugFlag(tmp);
        int lineLength = 76;
        int lineOffset = 811;
        int lineCount = 0;
        for (int i4 = 0; i4 < 450; ++i4) {
            String line = buffer.substring(811 + i4 * 76, 887 + i4 * 76);
            String tmpServiceDate = line.substring(0, 8).trim();
            String tmpRevenueCode = line.substring(8, 12).trim();
            String tmpCptHcpcsHipps = line.substring(12, 17).trim();
            if ("".equals(tmpServiceDate) && "".equals(tmpRevenueCode) && "".equals(tmpCptHcpcsHipps)) {
                if (!logger.isTraceEnabled()) break;
                logger.trace("Missing Service Date, Revenue Code, and CPT/HIPPS/HCPCS, abort processing further lines.");
                break;
            }
            OceLineItem oceLineItem = OceClaimFactory.getInstance().createLineItem();
            oceLineItem.setServiceDate(tmpServiceDate);
            oceLineItem.setRevenueCode(tmpRevenueCode);
            oceLineItem.setHcpcs(tmpCptHcpcsHipps);
            tmp = line.substring(17, 27);
            if ("".equals(tmp.trim())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("No CPT/HCPCS modifiers to load.");
                }
            } else {
                String modifier;
                List<OceHcpcsModifier> modifierList = oceLineItem.getHcpcsModifierInputList();
                for (int j = 0; j < 5 && !"".equals(modifier = tmp.substring(j * 2, j * 2 + 2).trim()); ++j) {
                    modifierList.add(OceClaimFactory.getInstance().createHcpcsModifier());
                    modifierList.get(j).setHcpcsModifier(modifier);
                }
            }
            oceLineItem.setUnitsInput(line.substring(27, 36).trim());
            oceLineItem.setCharge(line.substring(36, 46).trim());
            oceLineItem.setActionFlagInput(line.substring(46, 47).trim());
            tmp = line.substring(47, 59);
            if ("".equals(tmp.trim())) {
                if (logger.isTraceEnabled()) {
                    logger.trace("No contractor bypass edits to load.");
                }
            } else {
                String tmpEdit;
                for (int j = 0; j < 4 && !"".equals(tmpEdit = tmp.substring(j * 3, j * 3 + 3).trim()); ++j) {
                    oceLineItem.addContractorEditBypass(tmpEdit);
                }
            }
            oceLineItem.setContractorApc(line.substring(59, 64).trim());
            oceLineItem.setContractorStatusIndicator(line.substring(64, 66).trim());
            oceLineItem.setContractorPaymentIndicator(line.substring(66, 68).trim());
            oceLineItem.setContractorDiscountingFormula(line.substring(68, 69).trim());
            oceLineItem.setContractorRejectionDenialFlag(line.substring(69, 70).trim());
            oceLineItem.setContractorPackagingFlag(line.substring(70, 71).trim());
            oceLineItem.setContractorPaymentAdjustmentFlag01(line.substring(71, 73).trim());
            oceLineItem.setContractorPaymentMethodFlag(line.substring(73, 74).trim());
            oceLineItem.setContractorPaymentAdjustmentFlag02(line.substring(74, 76).trim());
            claim.getLineItemList().add(oceLineItem);
            ++lineCount;
        }
        claim.getProcessingInformation().setLinesProcessed(lineCount);
        return claim;
    }
}

