/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.Claim;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClaimDefinition
implements Claim<RecordDefinition> {
    final String id;
    final List<RecordDefinition> records;

    private ClaimDefinition() {
        this(null, null);
    }

    public ClaimDefinition(String id, List<RecordDefinition> records) {
        this.id = id;
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final boolean isInput() {
        for (RecordDefinition r : this.records) {
            if (!r.input) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isOutput() {
        for (RecordDefinition r : this.records) {
            if (!r.output) continue;
            return true;
        }
        return false;
    }

    @Override
    public final RecordDefinition getRecord(String id, int index) {
        for (RecordDefinition r : this.records) {
            if (!id.equals(r.id) || --index >= 0) continue;
            return r;
        }
        return null;
    }

    @Override
    public final RecordDefinition getRecord(String id) {
        return this.getRecord(id, 0);
    }

    @Override
    public final List<RecordDefinition> getRecords() {
        return this.records;
    }

    @Override
    public final List<RecordDefinition> getRecords(String id) {
        ArrayList<RecordDefinition> list = new ArrayList<RecordDefinition>();
        for (RecordDefinition r : this.records) {
            if (!id.equals(r.id)) continue;
            list.add(r);
        }
        return list;
    }

    @Override
    public final boolean contains(RecordDefinition record) {
        for (RecordDefinition r : this.records) {
            if (r != record) continue;
            return true;
        }
        return false;
    }
}

