/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.oce.util.converter.rsc;

import gov.cms.oce.util.converter.rsc.ClaimDefinition;
import gov.cms.oce.util.converter.rsc.ClaimModel;
import gov.cms.oce.util.converter.rsc.RecordDefinition;
import gov.cms.oce.util.converter.rsc.RecordModel;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowLoader {
    private static final Logger logger = LoggerFactory.getLogger(RowLoader.class);
    private final LineNumberReader reader;
    private final String filePath;
    private long count;

    private RowLoader() throws IOException {
        this(null);
    }

    public RowLoader(String filePath) throws IOException {
        this.reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(filePath), StandardCharsets.UTF_8));
        this.filePath = filePath;
        this.count = 0L;
    }

    public final String getFilePath() {
        return this.filePath;
    }

    public final long getClaimCount() {
        return this.count;
    }

    public final ClaimModel next(ClaimDefinition claimDefinition) throws IOException {
        long lastClaim = this.count;
        ClaimModel claim = new ClaimModel(claimDefinition);
        return lastClaim < this.next(claim) ? claim : null;
    }

    public final long next(ClaimModel claim) throws IOException {
        String line;
        RecordDefinition definition = claim.getDefinition().getRecords().get(0);
        while ((line = this.reader.readLine()) != null) {
            if (!"".equals(line.trim()) && '#' != line.trim().charAt(0)) {
                claim.addRecord(new RecordModel(definition, line));
                return ++this.count;
            }
            logger.warn("Empty Line (Ignored). Line Number:\"{}\", File:\"{}\"", (Object)this.reader.getLineNumber(), (Object)this.filePath);
        }
        return this.count;
    }

    public static final void unload(Writer out, ClaimModel claim) throws IOException {
        for (RecordModel record : claim.getRecords()) {
            out.write(record.getData());
            out.write(10);
        }
        out.flush();
    }

    public static final void unload(ClaimModel claim, String file) throws IOException {
        FileWriter out = new FileWriter(file, true);
        RowLoader.unload(out, claim);
        ((Writer)out).close();
    }

    public static final void unload(ClaimModel[] claims, String file) throws IOException {
        FileWriter out = new FileWriter(file, true);
        for (ClaimModel claim : claims) {
            if (claim == null) continue;
            RowLoader.unload(out, claim);
        }
        ((Writer)out).close();
    }

    public static final void unload(List<ClaimModel> claims, String file) throws IOException {
        FileWriter out = new FileWriter(file, true);
        for (ClaimModel claim : claims) {
            if (claim == null) continue;
            RowLoader.unload(out, claim);
        }
        ((Writer)out).close();
    }
}

