/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import lombok.Generated;

@Schema(description="The IPF additional variables.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-ADDITIONAL-VARIABLES", value="<structure>")})})
public class AdditionalVariableData {
    @BigDecimalScale
    @Schema(description="The adjusted per diem amount.", example="720.60", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-ADJUSTED-PER-DIEM-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal adjustedPerDiemAmount;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99999")
    @Digits(integer=7, fraction=5)
    @Schema(description="The base labor amount.", example="45.99999", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-LABOR-BASE-AMT", value="PIC 9(07)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99999") @Digits(integer=7, fraction=5) @FixedValue BigDecimal baseLaborAmount;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99999")
    @Digits(integer=7, fraction=5)
    @Schema(description="The base non-labor amount.", example="12000.50505", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-NLABOR-BASE-AMT", value="PIC 9(07)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99999") @Digits(integer=7, fraction=5) @FixedValue BigDecimal baseNonLaborAmount;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="99999.99")
    @Digits(integer=5, fraction=2)
    @Schema(description="The budget rate amount.", example="9800.50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-BUDGNUT-RATE-AMT", value="PIC 9(05)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.99") @Digits(integer=5, fraction=2) @FixedValue BigDecimal budgetRateAmount;
    @BigDecimalScale
    @Schema(description="The electro-convulsive therapy payment.", example="854.36", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-ECT-PAYMENT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal electroConvulsiveTherapyPayment;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="99999.99")
    @Digits(integer=5, fraction=2)
    @Schema(description="The electro-convulsive therapy rate amount.", example="7459.30", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-ECT-RATE-AMT", value="PIC 9(05)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.99") @Digits(integer=5, fraction=2) @FixedValue BigDecimal electroConvulsiveTherapyRateAmount;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The factor payment.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-FAC-PAYMENT", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal factorPayment;
    @BigDecimalScale
    @Schema(description="The federal payment.", example="1275.50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-FED-PAYMENT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal federalPayment;
    @BigDecimalScale
    @Schema(description="The outlier-adjusted cost.", example="99.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-ADJ-COST", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierAdjustedCost;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99999")
    @Digits(integer=7, fraction=5)
    @Schema(description="The outlier base labor amount.", example="50.25232", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-LABOR-BASE-AMT", value="PIC 9(07)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99999") @Digits(integer=7, fraction=5) @FixedValue BigDecimal outlierBaseLaborAmount;
    @BigDecimalScale(scale=5)
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99999")
    @Digits(integer=7, fraction=5)
    @Schema(description="The outlier base non-labor amount.", example="75.22559", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-NLABOR-BASE-AMT", value="PIC 9(07)V9(05)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99999") @Digits(integer=7, fraction=5) @FixedValue BigDecimal outlierBaseNonLaborAmount;
    @BigDecimalScale
    @Schema(description="The outlier cost.", example="8900.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-COST", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierCost;
    @BigDecimalScale
    @Schema(description="The outlier payment,", example="55.21", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTLIER-PAYMENT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierPayment;
    @BigDecimalScale
    @Schema(description="The outlier per diem amount.", example="77.25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-PER-DIEM-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierPerDiemAmount;
    @BigDecimalScale
    @Schema(description="The outlier threshold-adjusted amount.", example="42.24", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-THRES-ADJ-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierThresholdAdjustedAmount;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The outlier threshold amount.", example="50.25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-OUTL-THRES-AMT", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal outlierThresholdAmount;
    @BigDecimalScale
    @Schema(description="The stop-loss amount.", example="6050.90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-100PCT-STOPLOS-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal stopLossAmount;
    @BigDecimalScale
    @Schema(description="The teaching payment.", example="6643.90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-TEACH-PAYMENT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal teachingPayment;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The wage-adjusted amount.", example="360.33", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="IPF-WAGE-ADJ-AMT", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal wageAdjustedAmount;

    @Generated
    public BigDecimal getAdjustedPerDiemAmount() {
        return this.adjustedPerDiemAmount;
    }

    @Generated
    public BigDecimal getBaseLaborAmount() {
        return this.baseLaborAmount;
    }

    @Generated
    public BigDecimal getBaseNonLaborAmount() {
        return this.baseNonLaborAmount;
    }

    @Generated
    public BigDecimal getBudgetRateAmount() {
        return this.budgetRateAmount;
    }

    @Generated
    public BigDecimal getElectroConvulsiveTherapyPayment() {
        return this.electroConvulsiveTherapyPayment;
    }

    @Generated
    public BigDecimal getElectroConvulsiveTherapyRateAmount() {
        return this.electroConvulsiveTherapyRateAmount;
    }

    @Generated
    public BigDecimal getFactorPayment() {
        return this.factorPayment;
    }

    @Generated
    public BigDecimal getFederalPayment() {
        return this.federalPayment;
    }

    @Generated
    public BigDecimal getOutlierAdjustedCost() {
        return this.outlierAdjustedCost;
    }

    @Generated
    public BigDecimal getOutlierBaseLaborAmount() {
        return this.outlierBaseLaborAmount;
    }

    @Generated
    public BigDecimal getOutlierBaseNonLaborAmount() {
        return this.outlierBaseNonLaborAmount;
    }

    @Generated
    public BigDecimal getOutlierCost() {
        return this.outlierCost;
    }

    @Generated
    public BigDecimal getOutlierPayment() {
        return this.outlierPayment;
    }

    @Generated
    public BigDecimal getOutlierPerDiemAmount() {
        return this.outlierPerDiemAmount;
    }

    @Generated
    public BigDecimal getOutlierThresholdAdjustedAmount() {
        return this.outlierThresholdAdjustedAmount;
    }

    @Generated
    public BigDecimal getOutlierThresholdAmount() {
        return this.outlierThresholdAmount;
    }

    @Generated
    public BigDecimal getStopLossAmount() {
        return this.stopLossAmount;
    }

    @Generated
    public BigDecimal getTeachingPayment() {
        return this.teachingPayment;
    }

    @Generated
    public BigDecimal getWageAdjustedAmount() {
        return this.wageAdjustedAmount;
    }

    @Generated
    public void setAdjustedPerDiemAmount(BigDecimal adjustedPerDiemAmount) {
        this.adjustedPerDiemAmount = adjustedPerDiemAmount;
    }

    @Generated
    public void setBaseLaborAmount(BigDecimal baseLaborAmount) {
        this.baseLaborAmount = baseLaborAmount;
    }

    @Generated
    public void setBaseNonLaborAmount(BigDecimal baseNonLaborAmount) {
        this.baseNonLaborAmount = baseNonLaborAmount;
    }

    @Generated
    public void setBudgetRateAmount(BigDecimal budgetRateAmount) {
        this.budgetRateAmount = budgetRateAmount;
    }

    @Generated
    public void setElectroConvulsiveTherapyPayment(BigDecimal electroConvulsiveTherapyPayment) {
        this.electroConvulsiveTherapyPayment = electroConvulsiveTherapyPayment;
    }

    @Generated
    public void setElectroConvulsiveTherapyRateAmount(BigDecimal electroConvulsiveTherapyRateAmount) {
        this.electroConvulsiveTherapyRateAmount = electroConvulsiveTherapyRateAmount;
    }

    @Generated
    public void setFactorPayment(BigDecimal factorPayment) {
        this.factorPayment = factorPayment;
    }

    @Generated
    public void setFederalPayment(BigDecimal federalPayment) {
        this.federalPayment = federalPayment;
    }

    @Generated
    public void setOutlierAdjustedCost(BigDecimal outlierAdjustedCost) {
        this.outlierAdjustedCost = outlierAdjustedCost;
    }

    @Generated
    public void setOutlierBaseLaborAmount(BigDecimal outlierBaseLaborAmount) {
        this.outlierBaseLaborAmount = outlierBaseLaborAmount;
    }

    @Generated
    public void setOutlierBaseNonLaborAmount(BigDecimal outlierBaseNonLaborAmount) {
        this.outlierBaseNonLaborAmount = outlierBaseNonLaborAmount;
    }

    @Generated
    public void setOutlierCost(BigDecimal outlierCost) {
        this.outlierCost = outlierCost;
    }

    @Generated
    public void setOutlierPayment(BigDecimal outlierPayment) {
        this.outlierPayment = outlierPayment;
    }

    @Generated
    public void setOutlierPerDiemAmount(BigDecimal outlierPerDiemAmount) {
        this.outlierPerDiemAmount = outlierPerDiemAmount;
    }

    @Generated
    public void setOutlierThresholdAdjustedAmount(BigDecimal outlierThresholdAdjustedAmount) {
        this.outlierThresholdAdjustedAmount = outlierThresholdAdjustedAmount;
    }

    @Generated
    public void setOutlierThresholdAmount(BigDecimal outlierThresholdAmount) {
        this.outlierThresholdAmount = outlierThresholdAmount;
    }

    @Generated
    public void setStopLossAmount(BigDecimal stopLossAmount) {
        this.stopLossAmount = stopLossAmount;
    }

    @Generated
    public void setTeachingPayment(BigDecimal teachingPayment) {
        this.teachingPayment = teachingPayment;
    }

    @Generated
    public void setWageAdjustedAmount(BigDecimal wageAdjustedAmount) {
        this.wageAdjustedAmount = wageAdjustedAmount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalVariableData)) {
            return false;
        }
        AdditionalVariableData other = (AdditionalVariableData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$adjustedPerDiemAmount = this.getAdjustedPerDiemAmount();
        BigDecimal other$adjustedPerDiemAmount = other.getAdjustedPerDiemAmount();
        if (this$adjustedPerDiemAmount == null ? other$adjustedPerDiemAmount != null : !((Object)this$adjustedPerDiemAmount).equals(other$adjustedPerDiemAmount)) {
            return false;
        }
        BigDecimal this$baseLaborAmount = this.getBaseLaborAmount();
        BigDecimal other$baseLaborAmount = other.getBaseLaborAmount();
        if (this$baseLaborAmount == null ? other$baseLaborAmount != null : !((Object)this$baseLaborAmount).equals(other$baseLaborAmount)) {
            return false;
        }
        BigDecimal this$baseNonLaborAmount = this.getBaseNonLaborAmount();
        BigDecimal other$baseNonLaborAmount = other.getBaseNonLaborAmount();
        if (this$baseNonLaborAmount == null ? other$baseNonLaborAmount != null : !((Object)this$baseNonLaborAmount).equals(other$baseNonLaborAmount)) {
            return false;
        }
        BigDecimal this$budgetRateAmount = this.getBudgetRateAmount();
        BigDecimal other$budgetRateAmount = other.getBudgetRateAmount();
        if (this$budgetRateAmount == null ? other$budgetRateAmount != null : !((Object)this$budgetRateAmount).equals(other$budgetRateAmount)) {
            return false;
        }
        BigDecimal this$electroConvulsiveTherapyPayment = this.getElectroConvulsiveTherapyPayment();
        BigDecimal other$electroConvulsiveTherapyPayment = other.getElectroConvulsiveTherapyPayment();
        if (this$electroConvulsiveTherapyPayment == null ? other$electroConvulsiveTherapyPayment != null : !((Object)this$electroConvulsiveTherapyPayment).equals(other$electroConvulsiveTherapyPayment)) {
            return false;
        }
        BigDecimal this$electroConvulsiveTherapyRateAmount = this.getElectroConvulsiveTherapyRateAmount();
        BigDecimal other$electroConvulsiveTherapyRateAmount = other.getElectroConvulsiveTherapyRateAmount();
        if (this$electroConvulsiveTherapyRateAmount == null ? other$electroConvulsiveTherapyRateAmount != null : !((Object)this$electroConvulsiveTherapyRateAmount).equals(other$electroConvulsiveTherapyRateAmount)) {
            return false;
        }
        BigDecimal this$factorPayment = this.getFactorPayment();
        BigDecimal other$factorPayment = other.getFactorPayment();
        if (this$factorPayment == null ? other$factorPayment != null : !((Object)this$factorPayment).equals(other$factorPayment)) {
            return false;
        }
        BigDecimal this$federalPayment = this.getFederalPayment();
        BigDecimal other$federalPayment = other.getFederalPayment();
        if (this$federalPayment == null ? other$federalPayment != null : !((Object)this$federalPayment).equals(other$federalPayment)) {
            return false;
        }
        BigDecimal this$outlierAdjustedCost = this.getOutlierAdjustedCost();
        BigDecimal other$outlierAdjustedCost = other.getOutlierAdjustedCost();
        if (this$outlierAdjustedCost == null ? other$outlierAdjustedCost != null : !((Object)this$outlierAdjustedCost).equals(other$outlierAdjustedCost)) {
            return false;
        }
        BigDecimal this$outlierBaseLaborAmount = this.getOutlierBaseLaborAmount();
        BigDecimal other$outlierBaseLaborAmount = other.getOutlierBaseLaborAmount();
        if (this$outlierBaseLaborAmount == null ? other$outlierBaseLaborAmount != null : !((Object)this$outlierBaseLaborAmount).equals(other$outlierBaseLaborAmount)) {
            return false;
        }
        BigDecimal this$outlierBaseNonLaborAmount = this.getOutlierBaseNonLaborAmount();
        BigDecimal other$outlierBaseNonLaborAmount = other.getOutlierBaseNonLaborAmount();
        if (this$outlierBaseNonLaborAmount == null ? other$outlierBaseNonLaborAmount != null : !((Object)this$outlierBaseNonLaborAmount).equals(other$outlierBaseNonLaborAmount)) {
            return false;
        }
        BigDecimal this$outlierCost = this.getOutlierCost();
        BigDecimal other$outlierCost = other.getOutlierCost();
        if (this$outlierCost == null ? other$outlierCost != null : !((Object)this$outlierCost).equals(other$outlierCost)) {
            return false;
        }
        BigDecimal this$outlierPayment = this.getOutlierPayment();
        BigDecimal other$outlierPayment = other.getOutlierPayment();
        if (this$outlierPayment == null ? other$outlierPayment != null : !((Object)this$outlierPayment).equals(other$outlierPayment)) {
            return false;
        }
        BigDecimal this$outlierPerDiemAmount = this.getOutlierPerDiemAmount();
        BigDecimal other$outlierPerDiemAmount = other.getOutlierPerDiemAmount();
        if (this$outlierPerDiemAmount == null ? other$outlierPerDiemAmount != null : !((Object)this$outlierPerDiemAmount).equals(other$outlierPerDiemAmount)) {
            return false;
        }
        BigDecimal this$outlierThresholdAdjustedAmount = this.getOutlierThresholdAdjustedAmount();
        BigDecimal other$outlierThresholdAdjustedAmount = other.getOutlierThresholdAdjustedAmount();
        if (this$outlierThresholdAdjustedAmount == null ? other$outlierThresholdAdjustedAmount != null : !((Object)this$outlierThresholdAdjustedAmount).equals(other$outlierThresholdAdjustedAmount)) {
            return false;
        }
        BigDecimal this$outlierThresholdAmount = this.getOutlierThresholdAmount();
        BigDecimal other$outlierThresholdAmount = other.getOutlierThresholdAmount();
        if (this$outlierThresholdAmount == null ? other$outlierThresholdAmount != null : !((Object)this$outlierThresholdAmount).equals(other$outlierThresholdAmount)) {
            return false;
        }
        BigDecimal this$stopLossAmount = this.getStopLossAmount();
        BigDecimal other$stopLossAmount = other.getStopLossAmount();
        if (this$stopLossAmount == null ? other$stopLossAmount != null : !((Object)this$stopLossAmount).equals(other$stopLossAmount)) {
            return false;
        }
        BigDecimal this$teachingPayment = this.getTeachingPayment();
        BigDecimal other$teachingPayment = other.getTeachingPayment();
        if (this$teachingPayment == null ? other$teachingPayment != null : !((Object)this$teachingPayment).equals(other$teachingPayment)) {
            return false;
        }
        BigDecimal this$wageAdjustedAmount = this.getWageAdjustedAmount();
        BigDecimal other$wageAdjustedAmount = other.getWageAdjustedAmount();
        return !(this$wageAdjustedAmount == null ? other$wageAdjustedAmount != null : !((Object)this$wageAdjustedAmount).equals(other$wageAdjustedAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalVariableData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $adjustedPerDiemAmount = this.getAdjustedPerDiemAmount();
        result = result * 59 + ($adjustedPerDiemAmount == null ? 43 : ((Object)$adjustedPerDiemAmount).hashCode());
        BigDecimal $baseLaborAmount = this.getBaseLaborAmount();
        result = result * 59 + ($baseLaborAmount == null ? 43 : ((Object)$baseLaborAmount).hashCode());
        BigDecimal $baseNonLaborAmount = this.getBaseNonLaborAmount();
        result = result * 59 + ($baseNonLaborAmount == null ? 43 : ((Object)$baseNonLaborAmount).hashCode());
        BigDecimal $budgetRateAmount = this.getBudgetRateAmount();
        result = result * 59 + ($budgetRateAmount == null ? 43 : ((Object)$budgetRateAmount).hashCode());
        BigDecimal $electroConvulsiveTherapyPayment = this.getElectroConvulsiveTherapyPayment();
        result = result * 59 + ($electroConvulsiveTherapyPayment == null ? 43 : ((Object)$electroConvulsiveTherapyPayment).hashCode());
        BigDecimal $electroConvulsiveTherapyRateAmount = this.getElectroConvulsiveTherapyRateAmount();
        result = result * 59 + ($electroConvulsiveTherapyRateAmount == null ? 43 : ((Object)$electroConvulsiveTherapyRateAmount).hashCode());
        BigDecimal $factorPayment = this.getFactorPayment();
        result = result * 59 + ($factorPayment == null ? 43 : ((Object)$factorPayment).hashCode());
        BigDecimal $federalPayment = this.getFederalPayment();
        result = result * 59 + ($federalPayment == null ? 43 : ((Object)$federalPayment).hashCode());
        BigDecimal $outlierAdjustedCost = this.getOutlierAdjustedCost();
        result = result * 59 + ($outlierAdjustedCost == null ? 43 : ((Object)$outlierAdjustedCost).hashCode());
        BigDecimal $outlierBaseLaborAmount = this.getOutlierBaseLaborAmount();
        result = result * 59 + ($outlierBaseLaborAmount == null ? 43 : ((Object)$outlierBaseLaborAmount).hashCode());
        BigDecimal $outlierBaseNonLaborAmount = this.getOutlierBaseNonLaborAmount();
        result = result * 59 + ($outlierBaseNonLaborAmount == null ? 43 : ((Object)$outlierBaseNonLaborAmount).hashCode());
        BigDecimal $outlierCost = this.getOutlierCost();
        result = result * 59 + ($outlierCost == null ? 43 : ((Object)$outlierCost).hashCode());
        BigDecimal $outlierPayment = this.getOutlierPayment();
        result = result * 59 + ($outlierPayment == null ? 43 : ((Object)$outlierPayment).hashCode());
        BigDecimal $outlierPerDiemAmount = this.getOutlierPerDiemAmount();
        result = result * 59 + ($outlierPerDiemAmount == null ? 43 : ((Object)$outlierPerDiemAmount).hashCode());
        BigDecimal $outlierThresholdAdjustedAmount = this.getOutlierThresholdAdjustedAmount();
        result = result * 59 + ($outlierThresholdAdjustedAmount == null ? 43 : ((Object)$outlierThresholdAdjustedAmount).hashCode());
        BigDecimal $outlierThresholdAmount = this.getOutlierThresholdAmount();
        result = result * 59 + ($outlierThresholdAmount == null ? 43 : ((Object)$outlierThresholdAmount).hashCode());
        BigDecimal $stopLossAmount = this.getStopLossAmount();
        result = result * 59 + ($stopLossAmount == null ? 43 : ((Object)$stopLossAmount).hashCode());
        BigDecimal $teachingPayment = this.getTeachingPayment();
        result = result * 59 + ($teachingPayment == null ? 43 : ((Object)$teachingPayment).hashCode());
        BigDecimal $wageAdjustedAmount = this.getWageAdjustedAmount();
        result = result * 59 + ($wageAdjustedAmount == null ? 43 : ((Object)$wageAdjustedAmount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalVariableData(adjustedPerDiemAmount=" + this.getAdjustedPerDiemAmount() + ", baseLaborAmount=" + this.getBaseLaborAmount() + ", baseNonLaborAmount=" + this.getBaseNonLaborAmount() + ", budgetRateAmount=" + this.getBudgetRateAmount() + ", electroConvulsiveTherapyPayment=" + this.getElectroConvulsiveTherapyPayment() + ", electroConvulsiveTherapyRateAmount=" + this.getElectroConvulsiveTherapyRateAmount() + ", factorPayment=" + this.getFactorPayment() + ", federalPayment=" + this.getFederalPayment() + ", outlierAdjustedCost=" + this.getOutlierAdjustedCost() + ", outlierBaseLaborAmount=" + this.getOutlierBaseLaborAmount() + ", outlierBaseNonLaborAmount=" + this.getOutlierBaseNonLaborAmount() + ", outlierCost=" + this.getOutlierCost() + ", outlierPayment=" + this.getOutlierPayment() + ", outlierPerDiemAmount=" + this.getOutlierPerDiemAmount() + ", outlierThresholdAdjustedAmount=" + this.getOutlierThresholdAdjustedAmount() + ", outlierThresholdAmount=" + this.getOutlierThresholdAmount() + ", stopLossAmount=" + this.getStopLossAmount() + ", teachingPayment=" + this.getTeachingPayment() + ", wageAdjustedAmount=" + this.getWageAdjustedAmount() + ")";
    }

    @Generated
    public AdditionalVariableData() {
    }
}

