/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateEctPaymentForOutput
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        @FixedValue BigDecimal ectRate = calculationContext.getAdditionalVariables().getElectroConvulsiveTherapyRateAmount();
        BigDecimal laborShare = ectRate.multiply(calculationContext.getLaborShare()).multiply(calculationContext.getPaymentData().getFinalWageIndex());
        BigDecimal nonLaborShare = ectRate.multiply(calculationContext.getNonLaborShare()).multiply(calculationContext.getPaymentData().getCostOfLivingAdjustmentPercent());
        @FixedValue BigDecimal ectPayment = laborShare.add(nonLaborShare).setScale(2, RoundingMode.HALF_UP);
        ectPayment = ectPayment.multiply(BigDecimal.valueOf(calculationContext.getClaimData().getServiceUnits())).setScale(2, RoundingMode.HALF_UP);
        calculationContext.getAdditionalVariables().setElectroConvulsiveTherapyPayment(ectPayment);
    }
}

