/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import java.math.BigDecimal;

public class CalculateEmergencyAdjustmentForOutput
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        if (calculationContext.hasTemporaryReliefIndicator()) {
            this.setEmergencyAdjustmentAndDay1Value(calculationContext, calculationContext.getTemporaryReliefEmergencyAdjustment());
        } else {
            this.setEmergencyAdjustmentAndDay1Value(calculationContext, calculationContext.getDefaultEmergencyAdjustment());
        }
        if (calculationContext.isSourceOfAdmission()) {
            this.setEmergencyAdjustmentAndDay1Value(calculationContext, calculationContext.getSourceOfAdmissionEmergencyAdjustment());
        }
    }

    private void setEmergencyAdjustmentAndDay1Value(IpfPricerContext calculationContext, BigDecimal adjustmentValue) {
        calculationContext.getPaymentData().setEmergencyAdjustmentPercent(adjustmentValue);
        calculationContext.setDay1Value(adjustmentValue);
    }
}

