/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.assemble_pps_variables;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.tables.ProcedureTableEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CalculateProcedureComorbidity
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        @FixedValue BigDecimal comorbidityFactor = calculationContext.getPaymentData().getComorbidityFactor();
        Map<String, Boolean> comorbidityCategories = calculationContext.getComorbidityCategory();
        List<String> procedureCodes = calculationContext.getProcedureCodes();
        for (String procedureCode : procedureCodes) {
            String category;
            ProcedureTableEntry procedureComorbidity = calculationContext.getDataTables().getProcedureTableEntry(procedureCode);
            if (procedureComorbidity == null || Boolean.TRUE.equals(comorbidityCategories.get(category = procedureComorbidity.getCategory())) || !StringUtils.equals(category, "14")) continue;
            comorbidityCategories.put(category, true);
            comorbidityFactor = comorbidityFactor.multiply(BigDecimalUtils.defaultValue(calculationContext.getDiagnosticCodeAdjustment(category), BigDecimal.ONE)).setScale(4, RoundingMode.HALF_UP);
        }
        calculationContext.getPaymentData().setComorbidityFactor(comorbidityFactor);
    }
}

