/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.calculate_payment.calculate_outlier;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateOutlierPayment
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        IpfClaimData claimData = calculationContext.getClaimData();
        int lengthOfStay = claimData.getLengthOfStay();
        int daysUpTo9 = Math.min(9, lengthOfStay);
        int daysOver9 = Math.max(0, lengthOfStay - 9);
        this.setOutlierPayment(calculationContext, daysUpTo9, daysOver9);
    }

    protected void setOutlierPayment(IpfPricerContext calculationContext, @FixedValue int daysUpTo9, int daysOver9) {
        AdditionalVariableData additionalVariables = calculationContext.getAdditionalVariables();
        BigDecimal outlierPerDiem = additionalVariables.getOutlierPerDiemAmount();
        BigDecimal outlierPayment = outlierPerDiem.multiply(new BigDecimal(daysUpTo9)).multiply(new BigDecimal("0.80")).setScale(2, RoundingMode.HALF_UP);
        if (BigDecimalUtils.isZero(outlierPayment = outlierPayment.add(outlierPerDiem.multiply(new BigDecimal(daysOver9)).multiply(new BigDecimal("0.60"))).setScale(2, RoundingMode.HALF_UP))) {
            calculationContext.applyReturnCode(ReturnCode.NORMAL_PAYMENT_0);
        }
        additionalVariables.setOutlierPayment(outlierPayment);
    }
}

