/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.pre_processing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexEntry;

public class SetCbsaWageIndexInContext
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public boolean shouldExecute(IpfPricerContext calculationContext) {
        return calculationContext.getCbsaWageIndexEntry() == null;
    }

    @Override
    public void calculate(IpfPricerContext calculationContext) {
        CbsaWageIndexEntry wageIndex = calculationContext.getDataTables().getCbsaWageIndexEntry(calculationContext.getProviderData().getCbsaActualGeographicLocation(), calculationContext.getClaimData().getDischargeDate());
        if (wageIndex == null) {
            calculationContext.completeWithReturnCode(ReturnCode.STATISTICAL_AREA_NOT_FOUND_52);
            return;
        }
        calculationContext.setCbsaWageIndexEntry(wageIndex);
        if (BigDecimalUtils.isZero(wageIndex.getGeographicWageIndex())) {
            calculationContext.completeWithReturnCode(ReturnCode.STATISTICAL_AREA_NOT_FOUND_52);
        }
    }
}

