/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.rules.pre_processing;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.IpfPricerContext;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class SetWageIndexCap
implements CalculationRule<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerContext> {
    @Override
    public void calculate(IpfPricerContext calculationContext) {
        BigDecimal supplementalWageIndex;
        CbsaWageIndexEntry cbsaWageIndexEntry;
        BigDecimal wageIndex;
        InpatientProviderData providerData = calculationContext.getProviderData();
        IpfClaimData claimData = calculationContext.getClaimData();
        if ((StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "1") || StringUtils.equals(providerData.getSupplementalWageIndexIndicator(), "3") && LocalDateUtils.isAfterOrEqual(claimData.getDischargeDate(), IpfPricerContext.FISCAL_YEAR_2025_BEGIN)) && BigDecimalUtils.isLessThan((wageIndex = (cbsaWageIndexEntry = calculationContext.getCbsaWageIndexEntry()).getGeographicWageIndex()).subtract(supplementalWageIndex = providerData.getSupplementalWageIndex()).divide(supplementalWageIndex, 4, RoundingMode.HALF_UP), IpfPricerContext.WAGE_INDEX_REDUCTION_FOR_2021)) {
            calculationContext.setCbsaWageIndexEntry(cbsaWageIndexEntry.copyBuilder().geographicWageIndex(supplementalWageIndex.multiply(IpfPricerContext.WAGE_INDEX_ADJUSTMENT_FOR_2021).setScale(4, RoundingMode.HALF_UP)).build());
        }
    }
}

