/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.CodeFirstTableEntry;
import java.util.List;
import java.util.Map;

public class CodeFirstLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/codeFirst-%s.csv";
    private final CsvContentReader<CodeFirstTableEntry> contentProvider = new CsvContentReader<CodeFirstTableEntry>(CodeFirstTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public CodeFirstLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, CodeFirstTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, CodeFirstTableEntry> generate(String csvFile) {
        List<CodeFirstTableEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(CodeFirstTableEntry::getCode, content);
    }
}

