/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.DrgTableEntry;
import java.util.List;
import java.util.Map;

public class DrgLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/drg-%s.csv";
    private final CsvContentReader<DrgTableEntry> contentProvider = new CsvContentReader<DrgTableEntry>(DrgTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public DrgLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, DrgTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, DrgTableEntry> generate(String csvFile) {
        List<DrgTableEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(DrgTableEntry::getCode, content);
    }
}

