/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipf.core.tables.ProcedureTableEntry;
import java.util.List;
import java.util.Map;

public class ProcedureLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/procedures-%s.csv";
    private final CsvContentReader<ProcedureTableEntry> contentProvider = new CsvContentReader<ProcedureTableEntry>(ProcedureTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public ProcedureLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, ProcedureTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, ProcedureTableEntry> generate(String csvFile) {
        List<ProcedureTableEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(ProcedureTableEntry::getCode, content);
    }
}

