/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.web.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.validation.ValidationMethod;
import io.dropwizard.web.conf.HeaderFactory;
import java.util.Collections;
import java.util.Map;

public class FrameOptionsHeaderFactory
extends HeaderFactory {
    private static final String X_FRAME_OPTIONS = "X-Frame-Options";
    @JsonProperty
    private FrameOption option = FrameOption.DENY;
    @JsonProperty
    private String origin;

    @ValidationMethod(message="'origin' is required if option is 'ALLOW_FROM'")
    @JsonIgnore
    private boolean isOriginValid() {
        return this.option != FrameOption.ALLOW_FROM || this.origin != null && !this.origin.isEmpty();
    }

    public FrameOption getOption() {
        return this.option;
    }

    public void setOption(FrameOption option) {
        this.option = option;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Override
    public Map<String, String> buildHeaders() {
        StringBuilder valueBuilder = new StringBuilder(this.option.getValue());
        if (FrameOption.ALLOW_FROM == this.option) {
            valueBuilder.append(" ").append(this.origin);
        }
        return Collections.singletonMap(X_FRAME_OPTIONS, valueBuilder.toString());
    }

    public static enum FrameOption {
        DENY("DENY"),
        SAMEORIGIN("SAMEORIGIN"),
        ALLOW_FROM("ALLOW-FROM");

        private final String value;

        private FrameOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

