// Generated by delombok at Tue Feb 18 20:49:10 UTC 2025
package gov.cms.fiss.pricers.ipf.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;

@Schema(description = "The IPF additional variables.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-ADDITIONAL-VARIABLES", value = "<structure>")})})
public class AdditionalVariableData {
  @BigDecimalScale
  @Schema(description = "The adjusted per diem amount.", example = "720.60", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-ADJUSTED-PER-DIEM-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal adjustedPerDiemAmount;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9999999.99999")
  @Digits(integer = 7, fraction = 5)
  @Schema(description = "The base labor amount.", example = "45.99999", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-LABOR-BASE-AMT", value = "PIC 9(07)V9(05)")})})
  @FixedValue
  private BigDecimal baseLaborAmount;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9999999.99999")
  @Digits(integer = 7, fraction = 5)
  @Schema(description = "The base non-labor amount.", example = "12000.50505", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-NLABOR-BASE-AMT", value = "PIC 9(07)V9(05)")})})
  @FixedValue
  private BigDecimal baseNonLaborAmount;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("99999.99")
  @Digits(integer = 5, fraction = 2)
  @Schema(description = "The budget rate amount.", example = "9800.50", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-BUDGNUT-RATE-AMT", value = "PIC 9(05)V9(02)")})})
  @FixedValue
  private BigDecimal budgetRateAmount;
  @BigDecimalScale
  @Schema(description = "The electro-convulsive therapy payment.", example = "854.36", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-ECT-PAYMENT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal electroConvulsiveTherapyPayment;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("99999.99")
  @Digits(integer = 5, fraction = 2)
  @Schema(description = "The electro-convulsive therapy rate amount.", example = "7459.30", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-ECT-RATE-AMT", value = "PIC 9(05)V9(02)")})})
  @FixedValue
  private BigDecimal electroConvulsiveTherapyRateAmount;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The factor payment.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-FAC-PAYMENT", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal factorPayment;
  @BigDecimalScale
  @Schema(description = "The federal payment.", example = "1275.50", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-FED-PAYMENT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal federalPayment;
  @BigDecimalScale
  @Schema(description = "The outlier-adjusted cost.", example = "99.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-ADJ-COST", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierAdjustedCost;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9999999.99999")
  @Digits(integer = 7, fraction = 5)
  @Schema(description = "The outlier base labor amount.", example = "50.25232", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-LABOR-BASE-AMT", value = "PIC 9(07)V9(05)")})})
  @FixedValue
  private BigDecimal outlierBaseLaborAmount;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9999999.99999")
  @Digits(integer = 7, fraction = 5)
  @Schema(description = "The outlier base non-labor amount.", example = "75.22559", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-NLABOR-BASE-AMT", value = "PIC 9(07)V9(05)")})})
  @FixedValue
  private BigDecimal outlierBaseNonLaborAmount;
  @BigDecimalScale
  @Schema(description = "The outlier cost.", example = "8900.75", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-COST", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierCost;
  @BigDecimalScale
  @Schema(description = "The outlier payment,", example = "55.21", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTLIER-PAYMENT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierPayment;
  @BigDecimalScale
  @Schema(description = "The outlier per diem amount.", example = "77.25", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-PER-DIEM-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierPerDiemAmount;
  @BigDecimalScale
  @Schema(description = "The outlier threshold-adjusted amount.", example = "42.24", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-THRES-ADJ-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierThresholdAdjustedAmount;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The outlier threshold amount.", example = "50.25", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-OUTL-THRES-AMT", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal outlierThresholdAmount;
  @BigDecimalScale
  @Schema(description = "The stop-loss amount.", example = "6050.90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-100PCT-STOPLOS-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal stopLossAmount;
  @BigDecimalScale
  @Schema(description = "The teaching payment.", example = "6643.90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-TEACH-PAYMENT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal teachingPayment;
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999999.99")
  @Digits(integer = 7, fraction = 2)
  @Schema(description = "The wage-adjusted amount.", example = "360.33", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "IPF-WAGE-ADJ-AMT", value = "PIC 9(07)V9(02)")})})
  @FixedValue
  private BigDecimal wageAdjustedAmount;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAdjustedPerDiemAmount() {
    return this.adjustedPerDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBaseLaborAmount() {
    return this.baseLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBaseNonLaborAmount() {
    return this.baseNonLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBudgetRateAmount() {
    return this.budgetRateAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getElectroConvulsiveTherapyPayment() {
    return this.electroConvulsiveTherapyPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getElectroConvulsiveTherapyRateAmount() {
    return this.electroConvulsiveTherapyRateAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFactorPayment() {
    return this.factorPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalPayment() {
    return this.federalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierAdjustedCost() {
    return this.outlierAdjustedCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBaseLaborAmount() {
    return this.outlierBaseLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierBaseNonLaborAmount() {
    return this.outlierBaseNonLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierCost() {
    return this.outlierCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPayment() {
    return this.outlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPerDiemAmount() {
    return this.outlierPerDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierThresholdAdjustedAmount() {
    return this.outlierThresholdAdjustedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierThresholdAmount() {
    return this.outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getStopLossAmount() {
    return this.stopLossAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTeachingPayment() {
    return this.teachingPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageAdjustedAmount() {
    return this.wageAdjustedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdjustedPerDiemAmount(final BigDecimal adjustedPerDiemAmount) {
    this.adjustedPerDiemAmount = adjustedPerDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBaseLaborAmount(final BigDecimal baseLaborAmount) {
    this.baseLaborAmount = baseLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBaseNonLaborAmount(final BigDecimal baseNonLaborAmount) {
    this.baseNonLaborAmount = baseNonLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBudgetRateAmount(final BigDecimal budgetRateAmount) {
    this.budgetRateAmount = budgetRateAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setElectroConvulsiveTherapyPayment(final BigDecimal electroConvulsiveTherapyPayment) {
    this.electroConvulsiveTherapyPayment = electroConvulsiveTherapyPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setElectroConvulsiveTherapyRateAmount(final BigDecimal electroConvulsiveTherapyRateAmount) {
    this.electroConvulsiveTherapyRateAmount = electroConvulsiveTherapyRateAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFactorPayment(final BigDecimal factorPayment) {
    this.factorPayment = factorPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPayment(final BigDecimal federalPayment) {
    this.federalPayment = federalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierAdjustedCost(final BigDecimal outlierAdjustedCost) {
    this.outlierAdjustedCost = outlierAdjustedCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBaseLaborAmount(final BigDecimal outlierBaseLaborAmount) {
    this.outlierBaseLaborAmount = outlierBaseLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierBaseNonLaborAmount(final BigDecimal outlierBaseNonLaborAmount) {
    this.outlierBaseNonLaborAmount = outlierBaseNonLaborAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierCost(final BigDecimal outlierCost) {
    this.outlierCost = outlierCost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPayment(final BigDecimal outlierPayment) {
    this.outlierPayment = outlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPerDiemAmount(final BigDecimal outlierPerDiemAmount) {
    this.outlierPerDiemAmount = outlierPerDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierThresholdAdjustedAmount(final BigDecimal outlierThresholdAdjustedAmount) {
    this.outlierThresholdAdjustedAmount = outlierThresholdAdjustedAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierThresholdAmount(final BigDecimal outlierThresholdAmount) {
    this.outlierThresholdAmount = outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStopLossAmount(final BigDecimal stopLossAmount) {
    this.stopLossAmount = stopLossAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTeachingPayment(final BigDecimal teachingPayment) {
    this.teachingPayment = teachingPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageAdjustedAmount(final BigDecimal wageAdjustedAmount) {
    this.wageAdjustedAmount = wageAdjustedAmount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AdditionalVariableData)) return false;
    final AdditionalVariableData other = (AdditionalVariableData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$adjustedPerDiemAmount = this.getAdjustedPerDiemAmount();
    final java.lang.Object other$adjustedPerDiemAmount = other.getAdjustedPerDiemAmount();
    if (this$adjustedPerDiemAmount == null ? other$adjustedPerDiemAmount != null : !this$adjustedPerDiemAmount.equals(other$adjustedPerDiemAmount)) return false;
    final java.lang.Object this$baseLaborAmount = this.getBaseLaborAmount();
    final java.lang.Object other$baseLaborAmount = other.getBaseLaborAmount();
    if (this$baseLaborAmount == null ? other$baseLaborAmount != null : !this$baseLaborAmount.equals(other$baseLaborAmount)) return false;
    final java.lang.Object this$baseNonLaborAmount = this.getBaseNonLaborAmount();
    final java.lang.Object other$baseNonLaborAmount = other.getBaseNonLaborAmount();
    if (this$baseNonLaborAmount == null ? other$baseNonLaborAmount != null : !this$baseNonLaborAmount.equals(other$baseNonLaborAmount)) return false;
    final java.lang.Object this$budgetRateAmount = this.getBudgetRateAmount();
    final java.lang.Object other$budgetRateAmount = other.getBudgetRateAmount();
    if (this$budgetRateAmount == null ? other$budgetRateAmount != null : !this$budgetRateAmount.equals(other$budgetRateAmount)) return false;
    final java.lang.Object this$electroConvulsiveTherapyPayment = this.getElectroConvulsiveTherapyPayment();
    final java.lang.Object other$electroConvulsiveTherapyPayment = other.getElectroConvulsiveTherapyPayment();
    if (this$electroConvulsiveTherapyPayment == null ? other$electroConvulsiveTherapyPayment != null : !this$electroConvulsiveTherapyPayment.equals(other$electroConvulsiveTherapyPayment)) return false;
    final java.lang.Object this$electroConvulsiveTherapyRateAmount = this.getElectroConvulsiveTherapyRateAmount();
    final java.lang.Object other$electroConvulsiveTherapyRateAmount = other.getElectroConvulsiveTherapyRateAmount();
    if (this$electroConvulsiveTherapyRateAmount == null ? other$electroConvulsiveTherapyRateAmount != null : !this$electroConvulsiveTherapyRateAmount.equals(other$electroConvulsiveTherapyRateAmount)) return false;
    final java.lang.Object this$factorPayment = this.getFactorPayment();
    final java.lang.Object other$factorPayment = other.getFactorPayment();
    if (this$factorPayment == null ? other$factorPayment != null : !this$factorPayment.equals(other$factorPayment)) return false;
    final java.lang.Object this$federalPayment = this.getFederalPayment();
    final java.lang.Object other$federalPayment = other.getFederalPayment();
    if (this$federalPayment == null ? other$federalPayment != null : !this$federalPayment.equals(other$federalPayment)) return false;
    final java.lang.Object this$outlierAdjustedCost = this.getOutlierAdjustedCost();
    final java.lang.Object other$outlierAdjustedCost = other.getOutlierAdjustedCost();
    if (this$outlierAdjustedCost == null ? other$outlierAdjustedCost != null : !this$outlierAdjustedCost.equals(other$outlierAdjustedCost)) return false;
    final java.lang.Object this$outlierBaseLaborAmount = this.getOutlierBaseLaborAmount();
    final java.lang.Object other$outlierBaseLaborAmount = other.getOutlierBaseLaborAmount();
    if (this$outlierBaseLaborAmount == null ? other$outlierBaseLaborAmount != null : !this$outlierBaseLaborAmount.equals(other$outlierBaseLaborAmount)) return false;
    final java.lang.Object this$outlierBaseNonLaborAmount = this.getOutlierBaseNonLaborAmount();
    final java.lang.Object other$outlierBaseNonLaborAmount = other.getOutlierBaseNonLaborAmount();
    if (this$outlierBaseNonLaborAmount == null ? other$outlierBaseNonLaborAmount != null : !this$outlierBaseNonLaborAmount.equals(other$outlierBaseNonLaborAmount)) return false;
    final java.lang.Object this$outlierCost = this.getOutlierCost();
    final java.lang.Object other$outlierCost = other.getOutlierCost();
    if (this$outlierCost == null ? other$outlierCost != null : !this$outlierCost.equals(other$outlierCost)) return false;
    final java.lang.Object this$outlierPayment = this.getOutlierPayment();
    final java.lang.Object other$outlierPayment = other.getOutlierPayment();
    if (this$outlierPayment == null ? other$outlierPayment != null : !this$outlierPayment.equals(other$outlierPayment)) return false;
    final java.lang.Object this$outlierPerDiemAmount = this.getOutlierPerDiemAmount();
    final java.lang.Object other$outlierPerDiemAmount = other.getOutlierPerDiemAmount();
    if (this$outlierPerDiemAmount == null ? other$outlierPerDiemAmount != null : !this$outlierPerDiemAmount.equals(other$outlierPerDiemAmount)) return false;
    final java.lang.Object this$outlierThresholdAdjustedAmount = this.getOutlierThresholdAdjustedAmount();
    final java.lang.Object other$outlierThresholdAdjustedAmount = other.getOutlierThresholdAdjustedAmount();
    if (this$outlierThresholdAdjustedAmount == null ? other$outlierThresholdAdjustedAmount != null : !this$outlierThresholdAdjustedAmount.equals(other$outlierThresholdAdjustedAmount)) return false;
    final java.lang.Object this$outlierThresholdAmount = this.getOutlierThresholdAmount();
    final java.lang.Object other$outlierThresholdAmount = other.getOutlierThresholdAmount();
    if (this$outlierThresholdAmount == null ? other$outlierThresholdAmount != null : !this$outlierThresholdAmount.equals(other$outlierThresholdAmount)) return false;
    final java.lang.Object this$stopLossAmount = this.getStopLossAmount();
    final java.lang.Object other$stopLossAmount = other.getStopLossAmount();
    if (this$stopLossAmount == null ? other$stopLossAmount != null : !this$stopLossAmount.equals(other$stopLossAmount)) return false;
    final java.lang.Object this$teachingPayment = this.getTeachingPayment();
    final java.lang.Object other$teachingPayment = other.getTeachingPayment();
    if (this$teachingPayment == null ? other$teachingPayment != null : !this$teachingPayment.equals(other$teachingPayment)) return false;
    final java.lang.Object this$wageAdjustedAmount = this.getWageAdjustedAmount();
    final java.lang.Object other$wageAdjustedAmount = other.getWageAdjustedAmount();
    if (this$wageAdjustedAmount == null ? other$wageAdjustedAmount != null : !this$wageAdjustedAmount.equals(other$wageAdjustedAmount)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AdditionalVariableData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $adjustedPerDiemAmount = this.getAdjustedPerDiemAmount();
    result = result * PRIME + ($adjustedPerDiemAmount == null ? 43 : $adjustedPerDiemAmount.hashCode());
    final java.lang.Object $baseLaborAmount = this.getBaseLaborAmount();
    result = result * PRIME + ($baseLaborAmount == null ? 43 : $baseLaborAmount.hashCode());
    final java.lang.Object $baseNonLaborAmount = this.getBaseNonLaborAmount();
    result = result * PRIME + ($baseNonLaborAmount == null ? 43 : $baseNonLaborAmount.hashCode());
    final java.lang.Object $budgetRateAmount = this.getBudgetRateAmount();
    result = result * PRIME + ($budgetRateAmount == null ? 43 : $budgetRateAmount.hashCode());
    final java.lang.Object $electroConvulsiveTherapyPayment = this.getElectroConvulsiveTherapyPayment();
    result = result * PRIME + ($electroConvulsiveTherapyPayment == null ? 43 : $electroConvulsiveTherapyPayment.hashCode());
    final java.lang.Object $electroConvulsiveTherapyRateAmount = this.getElectroConvulsiveTherapyRateAmount();
    result = result * PRIME + ($electroConvulsiveTherapyRateAmount == null ? 43 : $electroConvulsiveTherapyRateAmount.hashCode());
    final java.lang.Object $factorPayment = this.getFactorPayment();
    result = result * PRIME + ($factorPayment == null ? 43 : $factorPayment.hashCode());
    final java.lang.Object $federalPayment = this.getFederalPayment();
    result = result * PRIME + ($federalPayment == null ? 43 : $federalPayment.hashCode());
    final java.lang.Object $outlierAdjustedCost = this.getOutlierAdjustedCost();
    result = result * PRIME + ($outlierAdjustedCost == null ? 43 : $outlierAdjustedCost.hashCode());
    final java.lang.Object $outlierBaseLaborAmount = this.getOutlierBaseLaborAmount();
    result = result * PRIME + ($outlierBaseLaborAmount == null ? 43 : $outlierBaseLaborAmount.hashCode());
    final java.lang.Object $outlierBaseNonLaborAmount = this.getOutlierBaseNonLaborAmount();
    result = result * PRIME + ($outlierBaseNonLaborAmount == null ? 43 : $outlierBaseNonLaborAmount.hashCode());
    final java.lang.Object $outlierCost = this.getOutlierCost();
    result = result * PRIME + ($outlierCost == null ? 43 : $outlierCost.hashCode());
    final java.lang.Object $outlierPayment = this.getOutlierPayment();
    result = result * PRIME + ($outlierPayment == null ? 43 : $outlierPayment.hashCode());
    final java.lang.Object $outlierPerDiemAmount = this.getOutlierPerDiemAmount();
    result = result * PRIME + ($outlierPerDiemAmount == null ? 43 : $outlierPerDiemAmount.hashCode());
    final java.lang.Object $outlierThresholdAdjustedAmount = this.getOutlierThresholdAdjustedAmount();
    result = result * PRIME + ($outlierThresholdAdjustedAmount == null ? 43 : $outlierThresholdAdjustedAmount.hashCode());
    final java.lang.Object $outlierThresholdAmount = this.getOutlierThresholdAmount();
    result = result * PRIME + ($outlierThresholdAmount == null ? 43 : $outlierThresholdAmount.hashCode());
    final java.lang.Object $stopLossAmount = this.getStopLossAmount();
    result = result * PRIME + ($stopLossAmount == null ? 43 : $stopLossAmount.hashCode());
    final java.lang.Object $teachingPayment = this.getTeachingPayment();
    result = result * PRIME + ($teachingPayment == null ? 43 : $teachingPayment.hashCode());
    final java.lang.Object $wageAdjustedAmount = this.getWageAdjustedAmount();
    result = result * PRIME + ($wageAdjustedAmount == null ? 43 : $wageAdjustedAmount.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "AdditionalVariableData(adjustedPerDiemAmount=" + this.getAdjustedPerDiemAmount() + ", baseLaborAmount=" + this.getBaseLaborAmount() + ", baseNonLaborAmount=" + this.getBaseNonLaborAmount() + ", budgetRateAmount=" + this.getBudgetRateAmount() + ", electroConvulsiveTherapyPayment=" + this.getElectroConvulsiveTherapyPayment() + ", electroConvulsiveTherapyRateAmount=" + this.getElectroConvulsiveTherapyRateAmount() + ", factorPayment=" + this.getFactorPayment() + ", federalPayment=" + this.getFederalPayment() + ", outlierAdjustedCost=" + this.getOutlierAdjustedCost() + ", outlierBaseLaborAmount=" + this.getOutlierBaseLaborAmount() + ", outlierBaseNonLaborAmount=" + this.getOutlierBaseNonLaborAmount() + ", outlierCost=" + this.getOutlierCost() + ", outlierPayment=" + this.getOutlierPayment() + ", outlierPerDiemAmount=" + this.getOutlierPerDiemAmount() + ", outlierThresholdAdjustedAmount=" + this.getOutlierThresholdAdjustedAmount() + ", outlierThresholdAmount=" + this.getOutlierThresholdAmount() + ", stopLossAmount=" + this.getStopLossAmount() + ", teachingPayment=" + this.getTeachingPayment() + ", wageAdjustedAmount=" + this.getWageAdjustedAmount() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalVariableData() {
  }
}
