// Generated by delombok at Tue Feb 18 20:49:10 UTC 2025
package gov.cms.fiss.pricers.ipf.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Schema(description = "The IPF claim data.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "BILL-IN-DATA", value = "<structure>")))
public class IpfClaimData extends ClaimData {
  @BigDecimalScale
  @NotNull
  @Schema(description = "The charges covered.", example = "1234.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-CHARGES-CLAIMED", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal coveredCharges;
  @ArraySchema(arraySchema = @Schema(description = "The diagnosis codes related to this claim.", example = "[ \"B101\", \"K909\", \"G392\", \"B324\" ]"), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-OTHER-DIAG-DATA", value = "PIC X(175)")})})
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be seven or fewer alphanumeric characters") String> diagnosisCodes;
  @Schema(description = "The diagnosis-related group.", example = "001", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-DRG", value = "PIC 9(03)")})})
  @ValidDiagnosisRelatedGroup
  private String diagnosisRelatedGroup;
  @Pattern(regexp = "[A-Z\\d]", message = "must be an alphanumeric character")
  @Schema(description = "The diagnosis-related group severity.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-DRG-SEVERITY", value = "PIC X")})})
  private String diagnosisRelatedGroupSeverity;
  @NotNull
  @Schema(description = "The discharge date.", example = "2020-10-30", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-DISCHARGE-DATE", value = "| D-CC PIC 9(02)" + " D-YY PIC 9(02)" + " D-MM PIC 9(02)" + " D-DD PIC 9(02)")})})
  @StrictLocalDate
  private LocalDate dischargeDate;
  @Max(99999)
  @Min(0)
  @Schema(description = "The length of stay.", example = "60", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-LOS", value = "PIC 9(05)")})})
  private int lengthOfStay;
  @Pattern(regexp = "[A-Z\\d]", message = "must be an alphanumeric character")
  @Schema(description = "The outlier occurrence indicator.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-OUTL-OCCUR-IND", value = "PIC X(01)")})})
  private String outlierOccurrenceIndicator;
  @Max(999)
  @Min(0)
  @Schema(description = "The patient\'s age.", example = "32", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-AGE", value = "PIC 9(03)")})})
  private int patientAge;
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be 2 digits")
  @Schema(description = "The patient status.", example = "01", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-PATIENT-STATUS", value = "PIC X(02)")})})
  private String patientStatus;
  @Max(999)
  @Min(0)
  @Schema(description = "The prior days.", example = "15", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-PRIOR-DAYS", value = "PIC 9(03)")})})
  private int priorDays;
  @ArraySchema(arraySchema = @Schema(description = "The procedure codes related to this claim.", example = "[\"G40\", \"J99\", \"F21\", \"B42\"]"), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-OTHER-PROC-DATA", value = "PIC X(175)")})})
  @NotNull
  @Size(max = 25)
  private List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be seven or fewer alphanumeric characters") String> procedureCodes = new ArrayList<>();
  @Max(999)
  @Min(0)
  @Schema(description = "The number of electro-convulsive therapy (ECT) units.", example = "15", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-ECT-NO-OF-UNITS", value = "PIC 9(03)")})})
  private int serviceUnits;
  @Pattern(regexp = "[A-Z\\d]", message = "must be an alphanumeric character")
  @Schema(description = "The admission source.", example = "D", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-SRC-OF-ADMISSION", value = "PIC X(01)")})})
  private String sourceOfAdmission;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoveredCharges() {
    return this.coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be seven or fewer alphanumeric characters") String> getDiagnosisCodes() {
    return this.diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosisRelatedGroup() {
    return this.diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDiagnosisRelatedGroupSeverity() {
    return this.diagnosisRelatedGroupSeverity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDischargeDate() {
    return this.dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOutlierOccurrenceIndicator() {
    return this.outlierOccurrenceIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getPatientAge() {
    return this.patientAge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPatientStatus() {
    return this.patientStatus;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getPriorDays() {
    return this.priorDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be seven or fewer alphanumeric characters") String> getProcedureCodes() {
    return this.procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getServiceUnits() {
    return this.serviceUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSourceOfAdmission() {
    return this.sourceOfAdmission;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredCharges(final BigDecimal coveredCharges) {
    this.coveredCharges = coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisCodes(final List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be seven or fewer alphanumeric characters") String> diagnosisCodes) {
    this.diagnosisCodes = diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroup(final String diagnosisRelatedGroup) {
    this.diagnosisRelatedGroup = diagnosisRelatedGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisRelatedGroupSeverity(final String diagnosisRelatedGroupSeverity) {
    this.diagnosisRelatedGroupSeverity = diagnosisRelatedGroupSeverity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeDate(final LocalDate dischargeDate) {
    this.dischargeDate = dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final int lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierOccurrenceIndicator(final String outlierOccurrenceIndicator) {
    this.outlierOccurrenceIndicator = outlierOccurrenceIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientAge(final int patientAge) {
    this.patientAge = patientAge;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientStatus(final String patientStatus) {
    this.patientStatus = patientStatus;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPriorDays(final int priorDays) {
    this.priorDays = priorDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProcedureCodes(final List<@Pattern(regexp = "[A-Z\\d]{1,7}", message = "must be seven or fewer alphanumeric characters") String> procedureCodes) {
    this.procedureCodes = procedureCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceUnits(final int serviceUnits) {
    this.serviceUnits = serviceUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSourceOfAdmission(final String sourceOfAdmission) {
    this.sourceOfAdmission = sourceOfAdmission;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IpfClaimData)) return false;
    final IpfClaimData other = (IpfClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getLengthOfStay() != other.getLengthOfStay()) return false;
    if (this.getPatientAge() != other.getPatientAge()) return false;
    if (this.getPriorDays() != other.getPriorDays()) return false;
    if (this.getServiceUnits() != other.getServiceUnits()) return false;
    final java.lang.Object this$coveredCharges = this.getCoveredCharges();
    final java.lang.Object other$coveredCharges = other.getCoveredCharges();
    if (this$coveredCharges == null ? other$coveredCharges != null : !this$coveredCharges.equals(other$coveredCharges)) return false;
    final java.lang.Object this$diagnosisCodes = this.getDiagnosisCodes();
    final java.lang.Object other$diagnosisCodes = other.getDiagnosisCodes();
    if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !this$diagnosisCodes.equals(other$diagnosisCodes)) return false;
    final java.lang.Object this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    final java.lang.Object other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
    if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) return false;
    final java.lang.Object this$diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
    final java.lang.Object other$diagnosisRelatedGroupSeverity = other.getDiagnosisRelatedGroupSeverity();
    if (this$diagnosisRelatedGroupSeverity == null ? other$diagnosisRelatedGroupSeverity != null : !this$diagnosisRelatedGroupSeverity.equals(other$diagnosisRelatedGroupSeverity)) return false;
    final java.lang.Object this$dischargeDate = this.getDischargeDate();
    final java.lang.Object other$dischargeDate = other.getDischargeDate();
    if (this$dischargeDate == null ? other$dischargeDate != null : !this$dischargeDate.equals(other$dischargeDate)) return false;
    final java.lang.Object this$outlierOccurrenceIndicator = this.getOutlierOccurrenceIndicator();
    final java.lang.Object other$outlierOccurrenceIndicator = other.getOutlierOccurrenceIndicator();
    if (this$outlierOccurrenceIndicator == null ? other$outlierOccurrenceIndicator != null : !this$outlierOccurrenceIndicator.equals(other$outlierOccurrenceIndicator)) return false;
    final java.lang.Object this$patientStatus = this.getPatientStatus();
    final java.lang.Object other$patientStatus = other.getPatientStatus();
    if (this$patientStatus == null ? other$patientStatus != null : !this$patientStatus.equals(other$patientStatus)) return false;
    final java.lang.Object this$procedureCodes = this.getProcedureCodes();
    final java.lang.Object other$procedureCodes = other.getProcedureCodes();
    if (this$procedureCodes == null ? other$procedureCodes != null : !this$procedureCodes.equals(other$procedureCodes)) return false;
    final java.lang.Object this$sourceOfAdmission = this.getSourceOfAdmission();
    final java.lang.Object other$sourceOfAdmission = other.getSourceOfAdmission();
    if (this$sourceOfAdmission == null ? other$sourceOfAdmission != null : !this$sourceOfAdmission.equals(other$sourceOfAdmission)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IpfClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getLengthOfStay();
    result = result * PRIME + this.getPatientAge();
    result = result * PRIME + this.getPriorDays();
    result = result * PRIME + this.getServiceUnits();
    final java.lang.Object $coveredCharges = this.getCoveredCharges();
    result = result * PRIME + ($coveredCharges == null ? 43 : $coveredCharges.hashCode());
    final java.lang.Object $diagnosisCodes = this.getDiagnosisCodes();
    result = result * PRIME + ($diagnosisCodes == null ? 43 : $diagnosisCodes.hashCode());
    final java.lang.Object $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
    result = result * PRIME + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
    final java.lang.Object $diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
    result = result * PRIME + ($diagnosisRelatedGroupSeverity == null ? 43 : $diagnosisRelatedGroupSeverity.hashCode());
    final java.lang.Object $dischargeDate = this.getDischargeDate();
    result = result * PRIME + ($dischargeDate == null ? 43 : $dischargeDate.hashCode());
    final java.lang.Object $outlierOccurrenceIndicator = this.getOutlierOccurrenceIndicator();
    result = result * PRIME + ($outlierOccurrenceIndicator == null ? 43 : $outlierOccurrenceIndicator.hashCode());
    final java.lang.Object $patientStatus = this.getPatientStatus();
    result = result * PRIME + ($patientStatus == null ? 43 : $patientStatus.hashCode());
    final java.lang.Object $procedureCodes = this.getProcedureCodes();
    result = result * PRIME + ($procedureCodes == null ? 43 : $procedureCodes.hashCode());
    final java.lang.Object $sourceOfAdmission = this.getSourceOfAdmission();
    result = result * PRIME + ($sourceOfAdmission == null ? 43 : $sourceOfAdmission.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IpfClaimData(coveredCharges=" + this.getCoveredCharges() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", diagnosisRelatedGroupSeverity=" + this.getDiagnosisRelatedGroupSeverity() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", outlierOccurrenceIndicator=" + this.getOutlierOccurrenceIndicator() + ", patientAge=" + this.getPatientAge() + ", patientStatus=" + this.getPatientStatus() + ", priorDays=" + this.getPriorDays() + ", procedureCodes=" + this.getProcedureCodes() + ", serviceUnits=" + this.getServiceUnits() + ", sourceOfAdmission=" + this.getSourceOfAdmission() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IpfClaimData() {
  }
}
