// Generated by delombok at Tue Feb 18 20:49:31 UTC 2025
package gov.cms.fiss.pricers.ipf.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipf.api.v2.AdditionalVariableData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimData;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.api.v2.IpfPaymentData;
import gov.cms.fiss.pricers.ipf.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ipf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ipf.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public abstract class IpfPricerContext extends CalculationContext<IpfClaimPricingRequest, IpfClaimPricingResponse> {
  public static final BigDecimal DEFAULT_COST_OF_LIVING_ADJUSTMENT = new BigDecimal("1.000");
  public static final LocalDate FISCAL_YEAR_2022_BEGIN = LocalDate.of(2021, 10, 1);
  public static final LocalDate FISCAL_YEAR_2022_END = LocalDate.of(2022, 9, 30);
  public static final LocalDate FISCAL_YEAR_2025_BEGIN = LocalDate.of(2024, 10, 1);
  // Reduction and adjustment are applied to values from 2020 to update them for use in 2021
  public static final BigDecimal WAGE_INDEX_REDUCTION_FOR_2021 = new BigDecimal("-0.05");
  public static final BigDecimal WAGE_INDEX_ADJUSTMENT_FOR_2021 = new BigDecimal("0.95");
  public static final String PATIENT_STATUS_EXP_TO_REMAIN_A_PATIENT_30 = "30";
  private static final BigDecimal RURAL_ADJUSTMENT = new BigDecimal("1.17");
  private static final BigDecimal TRANSITIONAL_RURAL_ADJUSTMENT = new BigDecimal("1.00");
  public static final BigDecimal DEFAULT_RURAL_ADJUSTMENT = new BigDecimal("1.00");
  private static final BigDecimal INTERN_RATIO_EXPONENT = new BigDecimal("0.5150");
  private static final BigDecimal DEFAULT_EMERGENCY_ADJUSTMENT = new BigDecimal("1.19");
  private static final BigDecimal TEMPORARY_RELIEF_EMERGENCY_ADJUSTMENT = new BigDecimal("1.31");
  private static final BigDecimal SOURCE_OF_ADMISSION_EMERGENCY_ADJUSTMENT = new BigDecimal("1.19");
  private static final List<BigDecimal> dayValues = List.of(new BigDecimal("1.12"), new BigDecimal("1.08"), new BigDecimal("1.05"), new BigDecimal("1.04"), new BigDecimal("1.02"), new BigDecimal("1.01"), new BigDecimal("1.01"), new BigDecimal("1.00"), new BigDecimal("1.00"), new BigDecimal("0.99"), new BigDecimal("0.99"), new BigDecimal("0.99"), new BigDecimal("0.99"), new BigDecimal("0.98"), new BigDecimal("0.97"), new BigDecimal("0.97"), new BigDecimal("0.96"), new BigDecimal("0.95"), new BigDecimal("0.95"), new BigDecimal("0.95"), new BigDecimal("0.92"));
  private static final Map<String, BigDecimal> diagnosticCodeAdjustment = Map.ofEntries(Map.entry("1", new BigDecimal("1.04")), Map.entry("2", new BigDecimal("1.13")), Map.entry("3", new BigDecimal("1.06")), Map.entry("4", new BigDecimal("1.11")), Map.entry("5", new BigDecimal("1.11")), Map.entry("6", new BigDecimal("1.07")), Map.entry("7", new BigDecimal("1.05")), Map.entry("8", new BigDecimal("1.13")), Map.entry("9", new BigDecimal("1.12")), Map.entry("10", new BigDecimal("1.07")), Map.entry("11", new BigDecimal("1.03")), Map.entry("12", new BigDecimal("1.11")), Map.entry("13", new BigDecimal("1.10")), Map.entry("14", new BigDecimal("1.12")), Map.entry("15", new BigDecimal("1.08")), Map.entry("16", new BigDecimal("1.09")), Map.entry("17", new BigDecimal("1.11")));
  private static final NavigableMap<Integer, BigDecimal> ageAdjustmentMap = new TreeMap<>(Map.of(0, new BigDecimal("1.00"), 45, new BigDecimal("1.01"), 50, new BigDecimal("1.02"), 55, new BigDecimal("1.04"), 60, new BigDecimal("1.07"), 65, new BigDecimal("1.10"), 70, new BigDecimal("1.13"), 75, new BigDecimal("1.15"), 80, new BigDecimal("1.17")));
  @JsonIgnore
  private final DataTables dataTables;
  private CbsaWageIndexEntry cbsaWageIndexEntry;
  private BigDecimal federalPayment;
  private BigDecimal perDiemAmount;
  private BigDecimal federalPortion;
  private BigDecimal teachingPortion = BigDecimalUtils.ZERO;
  @FixedValue
  private BigDecimal day1Value = new BigDecimal("0.00");
  Map<String, Boolean> comorbidityCategory = new HashMap<>();

  protected IpfPricerContext(IpfClaimPricingRequest input, IpfClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeOutput();
  }

  protected void initializeOutput() {
    getOutput().setCalculationVersion(getCalculationVersion());
    getOutput().getPaymentData().setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
  }

  public IpfClaimData getClaimData() {
    return getInput().getClaimData();
  }

  public List<String> getDiagnosisCodes() {
    List<String> codes = new ArrayList<>();
    if (getClaimData().getDiagnosisCodes() != null) {
      codes = getClaimData().getDiagnosisCodes();
    }
    return codes;
  }

  public List<String> getProcedureCodes() {
    List<String> codes = new ArrayList<>();
    if (getClaimData().getProcedureCodes() != null) {
      codes = getClaimData().getProcedureCodes();
    }
    return codes;
  }

  public InpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  public IpfPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  public AdditionalVariableData getAdditionalVariables() {
    return getPaymentData().getAdditionalVariables();
  }

  // accessors
  public abstract String getCalculationVersion();

  @FixedValue
  public abstract BigDecimal getHighQualityBudgetRate();

  @FixedValue
  public abstract BigDecimal getHighQualityEctRate();

  @FixedValue
  public abstract BigDecimal getLowQualityBudgetRate();

  @FixedValue
  public abstract BigDecimal getLowQualityEctRate();

  @FixedValue
  public abstract BigDecimal getOutlierThreshold();

  @FixedValue
  public abstract BigDecimal getLaborShare();

  @FixedValue
  public abstract BigDecimal getNonLaborShare();

  @FixedValue
  public BigDecimal getRuralAdjustment() {
    return RURAL_ADJUSTMENT;
  }

  @FixedValue
  public BigDecimal getTransitionalRuralAdjustment() {
    return TRANSITIONAL_RURAL_ADJUSTMENT;
  }

  @FixedValue
  public BigDecimal getDefaultRuralAdjustment() {
    return DEFAULT_RURAL_ADJUSTMENT;
  }

  @FixedValue
  public BigDecimal getDefaultEmergencyAdjustment() {
    return DEFAULT_EMERGENCY_ADJUSTMENT;
  }

  @FixedValue
  public BigDecimal getTemporaryReliefEmergencyAdjustment() {
    return TEMPORARY_RELIEF_EMERGENCY_ADJUSTMENT;
  }

  @FixedValue
  public BigDecimal getSourceOfAdmissionEmergencyAdjustment() {
    return SOURCE_OF_ADMISSION_EMERGENCY_ADJUSTMENT;
  }

  @FixedValue
  public BigDecimal getInternRatioExponent() {
    return INTERN_RATIO_EXPONENT;
  }

  public boolean matchesReturnCode(ReturnCode code) {
    return ReturnCode.fromCode(Integer.parseInt(getOutput().getReturnCodeData().getCode())) == code;
  }

  public void completeWithReturnCode(ReturnCode code) {
    applyReturnCode(code);
    setCalculationCompleted();
  }

  public void applyReturnCode(ReturnCode code) {
    getOutput().setReturnCodeData(code.toReturnCodeData());
  }

  public boolean isSourceOfAdmission() {
    return StringUtils.equals(getClaimData().getSourceOfAdmission(), "D");
  }

  public boolean isOutlierOccurrenceIndicator() {
    return StringUtils.equals(getClaimData().getOutlierOccurrenceIndicator(), "Y");
  }

  /**
   * Determine if provider record should include a cost of living adjustment.
   *
   * @return {@code true} if provider CCN indicates COLA expected; {@code false} otherwise
   */
  public boolean hasCostOfLivingAdjustment() {
    return StringUtils.equalsAny(getProviderData().getProviderCcn().substring(0, 2), "02", "12");
  }

  /**
   * Obtains the factor value associated with a given day of care.
   *
   * @param day the zero-indexed day since care started
   * @return the corresponding factor value
   */
  @FixedValue
  public BigDecimal getDayValue(int day) {
    // day == 0 is equivalent to day 1
    if (day == 0) {
      return day1Value;
    } else {
      return dayValues.get(day - 1);
    }
  }

  @FixedValue
  public BigDecimal getAgeAdjustment(int age) {
    return ageAdjustmentMap.floorEntry(age).getValue();
  }

  public void setDay1Value(BigDecimal value) {
    this.day1Value = value;
  }

  @FixedValue
  public BigDecimal getDiagnosticCodeAdjustment(String category) {
    return diagnosticCodeAdjustment.get(category);
  }

  public boolean hasTemporaryReliefIndicator() {
    return StringUtils.equals(getProviderData().getTemporaryReliefIndicator(), "Y");
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaWageIndexEntry getCbsaWageIndexEntry() {
    return this.cbsaWageIndexEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaWageIndexEntry(final CbsaWageIndexEntry cbsaWageIndexEntry) {
    this.cbsaWageIndexEntry = cbsaWageIndexEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalPayment() {
    return this.federalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPayment(final BigDecimal federalPayment) {
    this.federalPayment = federalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPerDiemAmount() {
    return this.perDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPerDiemAmount(final BigDecimal perDiemAmount) {
    this.perDiemAmount = perDiemAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalPortion() {
    return this.federalPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPortion(final BigDecimal federalPortion) {
    this.federalPortion = federalPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTeachingPortion() {
    return this.teachingPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTeachingPortion(final BigDecimal teachingPortion) {
    this.teachingPortion = teachingPortion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Boolean> getComorbidityCategory() {
    return this.comorbidityCategory;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidityCategory(final Map<String, Boolean> comorbidityCategory) {
    this.comorbidityCategory = comorbidityCategory;
  }
}
