// Generated by delombok at Tue Feb 18 20:49:31 UTC 2025
package gov.cms.fiss.pricers.ipf.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.ipf.IpfPricerConfiguration;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingRequest;
import gov.cms.fiss.pricers.ipf.api.v2.IpfClaimPricingResponse;
import gov.cms.fiss.pricers.ipf.core.tables.DataTables;

public class IpfPricerDispatch extends PricerDispatch<IpfClaimPricingRequest, IpfClaimPricingResponse, IpfPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(IpfPricerDispatch.class);

  public IpfPricerDispatch(IpfPricerConfiguration configuration) {
    super(configuration, o -> o.getReturnCodeData().getCode());
  }

  @Override
  protected void initializeReferences(IpfPricerConfiguration pricerConfiguration) {
    DataTables.loadDataTables(pricerConfiguration);
    for (final int supportedYear : pricerConfiguration.getSupportedYears()) {
      switch (supportedYear) {
      default: 
        yearReference.register(supportedYear, Ipf2020RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Ipf2021RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Ipf2022RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Ipf2023RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Ipf2024RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Ipf2025RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        break;
      }
    }
  }

  @Override
  protected ClaimProcessor<IpfClaimPricingRequest, IpfClaimPricingResponse> getProcessor(IpfClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
    return yearReference.fromFiscalYear(input.getClaimData().getDischargeDate(), "dischargeDate");
  }

  @Override
  protected boolean isErrorOutput(IpfClaimPricingResponse output) {
    return Integer.parseInt(output.getReturnCodeData().getCode()) >= 50;
  }
}
