// Generated by delombok at Tue Feb 18 20:49:31 UTC 2025
package gov.cms.fiss.pricers.ipf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.ipf.IpfPricerConfiguration;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;

/**
 * This class is responsible for holding all the CopyBook data tables for the pricer as well as
 * helper methods to access the data.
 */
public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  private final Map<String, ComorbidityTableEntry> comorbidityEntryMap;
  private final Map<String, CodeFirstTableEntry> codeFirstEntryMap;
  private final Map<String, DrgTableEntry> drgEntryMap;
  private final Map<String, ProcedureTableEntry> procedureTableEntryMap;

  public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, ComorbidityTableEntry> comorbidityEntryMap, Map<String, CodeFirstTableEntry> codeFirstEntryMap, Map<String, DrgTableEntry> drgEntryMap, Map<String, ProcedureTableEntry> procedureTableEntryMap) {
    this.cbsaTable = cbsaTable;
    this.comorbidityEntryMap = comorbidityEntryMap;
    this.codeFirstEntryMap = codeFirstEntryMap;
    this.drgEntryMap = drgEntryMap;
    this.procedureTableEntryMap = procedureTableEntryMap;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables with the given CSV ingestion configuration.
   */
  public static void loadDataTables(IpfPricerConfiguration configuration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = configuration.getCsvIngestionConfiguration();
    // Load all the tables
    for (final int pricerYear : configuration.getSupportedYears()) {
      final Map<String, ComorbidityTableEntry> comorbidityEntryMap = new ComorbidityLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
      final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaEntryMap = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
      final Map<String, CodeFirstTableEntry> codeFirstEntryMap = new CodeFirstLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
      final Map<String, DrgTableEntry> drgEntryMap = new DrgLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
      final Map<String, ProcedureTableEntry> procedureTableEntryMap = new ProcedureLookupGenerator(csvIngestionConfiguration).generate(pricerYear);
      YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaEntryMap, comorbidityEntryMap, codeFirstEntryMap, drgEntryMap, procedureTableEntryMap));
    }
  }

  public CbsaWageIndexEntry getCbsaWageIndexEntry(String code, LocalDate date) {
    final NavigableMap<LocalDate, CbsaWageIndexEntry> map = cbsaTable.get(code.trim());
    if (map == null) {
      return null;
    }
    final Entry<LocalDate, CbsaWageIndexEntry> kvPair = map.floorEntry(date);
    if (kvPair == null) {
      return null;
    }
    return map.floorEntry(date).getValue();
  }

  public ComorbidityTableEntry getComorbidityTableEntry(String code) {
    ComorbidityTableEntry entry = comorbidityEntryMap.get(code);
    return null == entry ? null : entry;
  }

  public CodeFirstTableEntry getCodeFirstEntry(String code) {
    CodeFirstTableEntry entry = codeFirstEntryMap.get(code);
    return null == entry ? null : entry;
  }

  public DrgTableEntry getDrgEntry(String code) {
    DrgTableEntry entry = drgEntryMap.get(code);
    return null == entry ? null : entry;
  }

  public ProcedureTableEntry getProcedureTableEntry(String code) {
    return procedureTableEntryMap.get(code);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
