/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

public class DefaultBigDecimalMath {
    private static MathContext defaultMathContext = DefaultBigDecimalMath.createDefaultMathContext();
    private static ThreadLocal<Deque<MathContext>> mathContextStack = new ThreadLocal();

    private static MathContext createDefaultMathContext() {
        int precision = DefaultBigDecimalMath.getIntSystemProperty("ch.obermuhlner.math.big.default.precision", MathContext.DECIMAL128.getPrecision());
        RoundingMode rounding = DefaultBigDecimalMath.getRoundingModeSystemProperty("ch.obermuhlner.math.big.default.rounding", MathContext.DECIMAL128.getRoundingMode());
        return new MathContext(precision, rounding);
    }

    private static void pushMathContext(MathContext mathContext) {
        Deque<MathContext> mathContexts = mathContextStack.get();
        if (mathContexts == null) {
            mathContexts = new ArrayDeque<MathContext>();
            mathContextStack.set(mathContexts);
        }
        mathContexts.addLast(mathContext);
    }

    private static MathContext popMathContext() {
        Deque<MathContext> mathContexts = mathContextStack.get();
        MathContext poppedMathContext = mathContexts.removeLast();
        if (mathContexts.isEmpty()) {
            mathContextStack.remove();
        }
        return poppedMathContext;
    }

    private static int getIntSystemProperty(String propertyKey, int defaultValue) {
        String propertyValue = System.getProperty(propertyKey, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            return DefaultBigDecimalMath.propertyException(propertyKey, propertyValue, defaultValue);
        }
    }

    private static RoundingMode getRoundingModeSystemProperty(String propertyKey, RoundingMode defaultValue) {
        String propertyValue = System.getProperty(propertyKey, defaultValue.name());
        try {
            return RoundingMode.valueOf(propertyValue);
        }
        catch (IllegalArgumentException ex) {
            return DefaultBigDecimalMath.propertyException(propertyKey, propertyValue, defaultValue);
        }
    }

    private static <T> T propertyException(String propertyKey, String propertyValue, T defaultValue) {
        System.err.println("Property '" + propertyKey + "' is not valid: " + propertyValue + " (using " + defaultValue + " instead)");
        return defaultValue;
    }

    public static void setDefaultMathContext(MathContext defaultMathContext) {
        Objects.requireNonNull(defaultMathContext);
        DefaultBigDecimalMath.defaultMathContext = defaultMathContext;
    }

    public static MathContext getDefaultMathContext() {
        return defaultMathContext;
    }

    public static void withLocalMathContext(int precision, Runnable runnable) {
        DefaultBigDecimalMath.withLocalMathContext(new MathContext(precision), runnable);
    }

    public static void withLocalMathContext(int precision, RoundingMode roundingMode, Runnable runnable) {
        DefaultBigDecimalMath.withLocalMathContext(new MathContext(precision, roundingMode), runnable);
    }

    public static void withLocalMathContext(MathContext mathContext, Runnable runnable) {
        try (LocalMathContext context = DefaultBigDecimalMath.createLocalMathContext(mathContext);){
            runnable.run();
        }
    }

    public static LocalMathContext createLocalMathContext(int precision) {
        return DefaultBigDecimalMath.createLocalMathContext(new MathContext(precision));
    }

    public static LocalMathContext createLocalMathContext(int precision, RoundingMode roundingMode) {
        return DefaultBigDecimalMath.createLocalMathContext(new MathContext(precision, roundingMode));
    }

    public static LocalMathContext createLocalMathContext(MathContext mathContext) {
        return new LocalMathContext(mathContext);
    }

    public static MathContext currentMathContext() {
        Deque<MathContext> mathContexts = mathContextStack.get();
        if (mathContexts == null || mathContexts.isEmpty()) {
            return defaultMathContext;
        }
        return mathContexts.getLast();
    }

    public static BigDecimal round(BigDecimal value) {
        return BigDecimalMath.round(value, defaultMathContext);
    }

    public static BigDecimal roundWithTrailingZeroes(BigDecimal value) {
        return BigDecimalMath.roundWithTrailingZeroes(value, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal add(BigDecimal x, BigDecimal y) {
        return x.add(y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal subtract(BigDecimal x, BigDecimal y) {
        return x.subtract(y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal multiply(BigDecimal x, BigDecimal y) {
        return x.multiply(y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal divide(BigDecimal x, BigDecimal y) {
        return x.divide(y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal remainder(BigDecimal x, BigDecimal y) {
        return x.remainder(y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal reciprocal(BigDecimal x) {
        return BigDecimalMath.reciprocal(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal factorial(BigDecimal x) {
        return BigDecimalMath.factorial(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal gamma(BigDecimal x) {
        return BigDecimalMath.gamma(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal bernoulli(int n) {
        return BigDecimalMath.bernoulli(n, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal pow(BigDecimal x, BigDecimal y) {
        return BigDecimalMath.pow(x, y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal pow(BigDecimal x, long y) {
        return BigDecimalMath.pow(x, y, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal sqrt(BigDecimal x) {
        return BigDecimalMath.sqrt(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal root(BigDecimal x, BigDecimal n) {
        return BigDecimalMath.root(x, n, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal log(BigDecimal x) {
        return BigDecimalMath.log(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal log2(BigDecimal x) {
        return BigDecimalMath.log2(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal log10(BigDecimal x) {
        return BigDecimalMath.log10(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal pi() {
        return BigDecimalMath.pi(DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal e() {
        return BigDecimalMath.e(DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal exp(BigDecimal x) {
        return BigDecimalMath.exp(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal sin(BigDecimal x) {
        return BigDecimalMath.sin(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal asin(BigDecimal x) {
        return BigDecimalMath.asin(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal cos(BigDecimal x) {
        return BigDecimalMath.cos(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal acos(BigDecimal x) {
        return BigDecimalMath.acos(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal tan(BigDecimal x) {
        return BigDecimalMath.tan(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal atan(BigDecimal x) {
        return BigDecimalMath.atan(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal atan2(BigDecimal y, BigDecimal x) {
        return BigDecimalMath.atan2(y, x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal cot(BigDecimal x) {
        return BigDecimalMath.cot(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal acot(BigDecimal x) {
        return BigDecimalMath.acot(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal sinh(BigDecimal x) {
        return BigDecimalMath.sinh(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal cosh(BigDecimal x) {
        return BigDecimalMath.cosh(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal tanh(BigDecimal x) {
        return BigDecimalMath.tanh(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal coth(BigDecimal x) {
        return BigDecimalMath.coth(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal asinh(BigDecimal x) {
        return BigDecimalMath.asinh(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal acosh(BigDecimal x) {
        return BigDecimalMath.acosh(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal atanh(BigDecimal x) {
        return BigDecimalMath.atanh(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static BigDecimal acoth(BigDecimal x) {
        return BigDecimalMath.acoth(x, DefaultBigDecimalMath.currentMathContext());
    }

    public static class LocalMathContext
    implements AutoCloseable {
        public final MathContext mathContext;

        LocalMathContext(MathContext mathContext) {
            this.mathContext = mathContext;
            DefaultBigDecimalMath.pushMathContext(mathContext);
        }

        @Override
        public void close() {
            DefaultBigDecimalMath.popMathContext();
        }
    }
}

