/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithElevenFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithNineFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalCapitalVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalOperatingVariableData;
import gov.cms.fiss.pricers.ipps.api.v2.AdditionalPaymentInformationData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="The additional variable information from claim pricing.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-ADDITIONAL-VARIABLES", value="<structure>")})})
public class AdditionalCalculationVariableData {
    @NotNull
    @Valid
    private AdditionalCapitalVariableData additionalCapitalVariables = new AdditionalCapitalVariableData();
    @NotNull
    @Valid
    private AdditionalOperatingVariableData additionalOperatingVariables = new AdditionalOperatingVariableData();
    @NotNull
    @Valid
    private AdditionalPaymentInformationData additionalPaymentInformation = new AdditionalPaymentInformationData();
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The claim cost threshold.", example="54364.62", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CST-THRESH", value="PIC 9(05)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal costThreshold;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The discharge fraction.", example="3.8745", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DSCHG-FRCTN", value="PIC 9(1)V9999")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal dischargeFraction;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99.9999")
    @Digits(integer=2, fraction=4)
    @Schema(description="The diagnosis-related group (DRG) relative weight.", example="89.4756", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DRG-WT", value="PIC 9(02)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99.9999") @Digits(integer=2, fraction=4) @FixedValue BigDecimal drgRelativeWeight;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The diagnosis-related group (DRG) relative weight fraction.", example="87.5233", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DRG-WT-FRCTN", value="PIC 9(02)V9999")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal drgRelativeWeightFraction;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The federal-specific portion percent.", example="0.43", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FSP-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal federalSpecificPortionPercent;
    @JsonIgnore
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal flx7Payment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The hospital readmission reduction adjustment.", example="1.2353", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-HOSP-HRR-ADJUSTMT", value="PIC 9V9(4)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal hospitalReadmissionReductionAdjustment;
    @Pattern(regexp="[01]", message="must be `0` or `1`")
    @Schema(description="The hospital readmission reduction indicator.", example="0", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-HOSP-READMISSION-REDU", value="PIC X")})})
    private @Pattern(regexp="[01]", message="must be `0` or `1`") String hospitalReadmissionReductionIndicator;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The hospital-specific portion percent.", example="4.55", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-HSP-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal hospitalSpecificPortionPercent;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The hospital-specific portion rate.", example="1234.896525245", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-HSP-RATE", value="PIC 9(08)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal hospitalSpecificPortionRate;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9999999.99")
    @Digits(integer=7, fraction=2)
    @Schema(description="The islet isolation add-on payment.", example="2094835.76", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-ISLET-ISOL-PAY-ADD-ON", value="PIC 9(07)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999999.99") @Digits(integer=7, fraction=2) @FixedValue BigDecimal isletIsolationAddOnPayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The low-volume payment.", example="4958.76", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LOW-VOL-PAYMENT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal lowVolumePayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99999.99")
    @Digits(integer=5, fraction=2)
    @Schema(description="The national labor cost.", example="54364.62", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-LABOR", value="PIC 9(05)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.99") @Digits(integer=5, fraction=2) @FixedValue BigDecimal nationalLaborCost;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The national labor percent.", example="0.5309", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-LABOR-PCT", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal nationalLaborPercent;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99999.99")
    @Digits(integer=5, fraction=2)
    @Schema(description="The national non-labor cost.", example="54364.62", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-NLABOR", value="PIC 9(05)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.99") @Digits(integer=5, fraction=2) @FixedValue BigDecimal nationalNonLaborCost;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The national non-labor percent.", example="0.4691", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-NONLABOR-PCT", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal nationalNonLaborPercent;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The national percent.", example="0.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal nationalPercent;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The new technology add-on payment.", example="9485.76", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NEW-TECH-PAY-ADD-ON", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal newTechnologyAddOnPayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The calculated pass-through total.", example="52.09")
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal passthroughTotalPlusMisc;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99999.99")
    @Digits(integer=5, fraction=2)
    @Schema(description="The regular labor cost.", example="54364.62", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-REG-LABOR", value="PIC 9(05)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.99") @Digits(integer=5, fraction=2) @FixedValue BigDecimal regularLaborCost;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99999.99")
    @Digits(integer=5, fraction=2)
    @Schema(description="The regular non-labor cost.", example="54364.62", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-REG-NLABOR", value="PIC 9(05)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.99") @Digits(integer=5, fraction=2) @FixedValue BigDecimal regularNonLaborCost;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The regular percent.", example="4.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-REG-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal regularPercent;
    @BigDecimalScale(scale=11, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The new technology add-on payment.", example="1.69398467593", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-VAL-BASED-PURCH-ADJUST", value="PIC 9V9(11)")})})
    @ValidDecimalOutputWithElevenFractionDigits
    private BigDecimal valueBasedPurchasingAdjustmentAmount;
    @Pattern(regexp="[YN]", message="must be `Y` or `N`")
    @Schema(description="Indicates whether the provider participates in Value-Based Purchasing (VBP).", example="N", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-VAL-BASED-PURCH-PARTIPNT", value="PIC X")})})
    private @Pattern(regexp="[YN]", message="must be `Y` or `N`") String valueBasedPurchasingParticipantIndicator;
    @JsonIgnore
    @Schema(description="Wage index.", example="4.5045", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-WAGE-INDEX", value="PIC 9(02)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal wageIndex;

    @Generated
    public AdditionalCapitalVariableData getAdditionalCapitalVariables() {
        return this.additionalCapitalVariables;
    }

    @Generated
    public AdditionalOperatingVariableData getAdditionalOperatingVariables() {
        return this.additionalOperatingVariables;
    }

    @Generated
    public AdditionalPaymentInformationData getAdditionalPaymentInformation() {
        return this.additionalPaymentInformation;
    }

    @Generated
    public BigDecimal getCostThreshold() {
        return this.costThreshold;
    }

    @Generated
    public BigDecimal getDischargeFraction() {
        return this.dischargeFraction;
    }

    @Generated
    public BigDecimal getDrgRelativeWeight() {
        return this.drgRelativeWeight;
    }

    @Generated
    public BigDecimal getDrgRelativeWeightFraction() {
        return this.drgRelativeWeightFraction;
    }

    @Generated
    public BigDecimal getFederalSpecificPortionPercent() {
        return this.federalSpecificPortionPercent;
    }

    @Generated
    public BigDecimal getFlx7Payment() {
        return this.flx7Payment;
    }

    @Generated
    public BigDecimal getHospitalReadmissionReductionAdjustment() {
        return this.hospitalReadmissionReductionAdjustment;
    }

    @Generated
    public String getHospitalReadmissionReductionIndicator() {
        return this.hospitalReadmissionReductionIndicator;
    }

    @Generated
    public BigDecimal getHospitalSpecificPortionPercent() {
        return this.hospitalSpecificPortionPercent;
    }

    @Generated
    public BigDecimal getHospitalSpecificPortionRate() {
        return this.hospitalSpecificPortionRate;
    }

    @Generated
    public BigDecimal getIsletIsolationAddOnPayment() {
        return this.isletIsolationAddOnPayment;
    }

    @Generated
    public BigDecimal getLowVolumePayment() {
        return this.lowVolumePayment;
    }

    @Generated
    public BigDecimal getNationalLaborCost() {
        return this.nationalLaborCost;
    }

    @Generated
    public BigDecimal getNationalLaborPercent() {
        return this.nationalLaborPercent;
    }

    @Generated
    public BigDecimal getNationalNonLaborCost() {
        return this.nationalNonLaborCost;
    }

    @Generated
    public BigDecimal getNationalNonLaborPercent() {
        return this.nationalNonLaborPercent;
    }

    @Generated
    public BigDecimal getNationalPercent() {
        return this.nationalPercent;
    }

    @Generated
    public BigDecimal getNewTechnologyAddOnPayment() {
        return this.newTechnologyAddOnPayment;
    }

    @Generated
    public BigDecimal getPassthroughTotalPlusMisc() {
        return this.passthroughTotalPlusMisc;
    }

    @Generated
    public BigDecimal getRegularLaborCost() {
        return this.regularLaborCost;
    }

    @Generated
    public BigDecimal getRegularNonLaborCost() {
        return this.regularNonLaborCost;
    }

    @Generated
    public BigDecimal getRegularPercent() {
        return this.regularPercent;
    }

    @Generated
    public BigDecimal getValueBasedPurchasingAdjustmentAmount() {
        return this.valueBasedPurchasingAdjustmentAmount;
    }

    @Generated
    public String getValueBasedPurchasingParticipantIndicator() {
        return this.valueBasedPurchasingParticipantIndicator;
    }

    @Generated
    public BigDecimal getWageIndex() {
        return this.wageIndex;
    }

    @Generated
    public void setAdditionalCapitalVariables(AdditionalCapitalVariableData additionalCapitalVariables) {
        this.additionalCapitalVariables = additionalCapitalVariables;
    }

    @Generated
    public void setAdditionalOperatingVariables(AdditionalOperatingVariableData additionalOperatingVariables) {
        this.additionalOperatingVariables = additionalOperatingVariables;
    }

    @Generated
    public void setAdditionalPaymentInformation(AdditionalPaymentInformationData additionalPaymentInformation) {
        this.additionalPaymentInformation = additionalPaymentInformation;
    }

    @Generated
    public void setCostThreshold(BigDecimal costThreshold) {
        this.costThreshold = costThreshold;
    }

    @Generated
    public void setDischargeFraction(BigDecimal dischargeFraction) {
        this.dischargeFraction = dischargeFraction;
    }

    @Generated
    public void setDrgRelativeWeight(BigDecimal drgRelativeWeight) {
        this.drgRelativeWeight = drgRelativeWeight;
    }

    @Generated
    public void setDrgRelativeWeightFraction(BigDecimal drgRelativeWeightFraction) {
        this.drgRelativeWeightFraction = drgRelativeWeightFraction;
    }

    @Generated
    public void setFederalSpecificPortionPercent(BigDecimal federalSpecificPortionPercent) {
        this.federalSpecificPortionPercent = federalSpecificPortionPercent;
    }

    @JsonIgnore
    @Generated
    public void setFlx7Payment(BigDecimal flx7Payment) {
        this.flx7Payment = flx7Payment;
    }

    @Generated
    public void setHospitalReadmissionReductionAdjustment(BigDecimal hospitalReadmissionReductionAdjustment) {
        this.hospitalReadmissionReductionAdjustment = hospitalReadmissionReductionAdjustment;
    }

    @Generated
    public void setHospitalReadmissionReductionIndicator(String hospitalReadmissionReductionIndicator) {
        this.hospitalReadmissionReductionIndicator = hospitalReadmissionReductionIndicator;
    }

    @Generated
    public void setHospitalSpecificPortionPercent(BigDecimal hospitalSpecificPortionPercent) {
        this.hospitalSpecificPortionPercent = hospitalSpecificPortionPercent;
    }

    @Generated
    public void setHospitalSpecificPortionRate(BigDecimal hospitalSpecificPortionRate) {
        this.hospitalSpecificPortionRate = hospitalSpecificPortionRate;
    }

    @Generated
    public void setIsletIsolationAddOnPayment(BigDecimal isletIsolationAddOnPayment) {
        this.isletIsolationAddOnPayment = isletIsolationAddOnPayment;
    }

    @Generated
    public void setLowVolumePayment(BigDecimal lowVolumePayment) {
        this.lowVolumePayment = lowVolumePayment;
    }

    @Generated
    public void setNationalLaborCost(BigDecimal nationalLaborCost) {
        this.nationalLaborCost = nationalLaborCost;
    }

    @Generated
    public void setNationalLaborPercent(BigDecimal nationalLaborPercent) {
        this.nationalLaborPercent = nationalLaborPercent;
    }

    @Generated
    public void setNationalNonLaborCost(BigDecimal nationalNonLaborCost) {
        this.nationalNonLaborCost = nationalNonLaborCost;
    }

    @Generated
    public void setNationalNonLaborPercent(BigDecimal nationalNonLaborPercent) {
        this.nationalNonLaborPercent = nationalNonLaborPercent;
    }

    @Generated
    public void setNationalPercent(BigDecimal nationalPercent) {
        this.nationalPercent = nationalPercent;
    }

    @Generated
    public void setNewTechnologyAddOnPayment(BigDecimal newTechnologyAddOnPayment) {
        this.newTechnologyAddOnPayment = newTechnologyAddOnPayment;
    }

    @Generated
    public void setPassthroughTotalPlusMisc(BigDecimal passthroughTotalPlusMisc) {
        this.passthroughTotalPlusMisc = passthroughTotalPlusMisc;
    }

    @Generated
    public void setRegularLaborCost(BigDecimal regularLaborCost) {
        this.regularLaborCost = regularLaborCost;
    }

    @Generated
    public void setRegularNonLaborCost(BigDecimal regularNonLaborCost) {
        this.regularNonLaborCost = regularNonLaborCost;
    }

    @Generated
    public void setRegularPercent(BigDecimal regularPercent) {
        this.regularPercent = regularPercent;
    }

    @Generated
    public void setValueBasedPurchasingAdjustmentAmount(BigDecimal valueBasedPurchasingAdjustmentAmount) {
        this.valueBasedPurchasingAdjustmentAmount = valueBasedPurchasingAdjustmentAmount;
    }

    @Generated
    public void setValueBasedPurchasingParticipantIndicator(String valueBasedPurchasingParticipantIndicator) {
        this.valueBasedPurchasingParticipantIndicator = valueBasedPurchasingParticipantIndicator;
    }

    @JsonIgnore
    @Generated
    public void setWageIndex(BigDecimal wageIndex) {
        this.wageIndex = wageIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalCalculationVariableData)) {
            return false;
        }
        AdditionalCalculationVariableData other = (AdditionalCalculationVariableData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdditionalCapitalVariableData this$additionalCapitalVariables = this.getAdditionalCapitalVariables();
        AdditionalCapitalVariableData other$additionalCapitalVariables = other.getAdditionalCapitalVariables();
        if (this$additionalCapitalVariables == null ? other$additionalCapitalVariables != null : !((Object)this$additionalCapitalVariables).equals(other$additionalCapitalVariables)) {
            return false;
        }
        AdditionalOperatingVariableData this$additionalOperatingVariables = this.getAdditionalOperatingVariables();
        AdditionalOperatingVariableData other$additionalOperatingVariables = other.getAdditionalOperatingVariables();
        if (this$additionalOperatingVariables == null ? other$additionalOperatingVariables != null : !((Object)this$additionalOperatingVariables).equals(other$additionalOperatingVariables)) {
            return false;
        }
        AdditionalPaymentInformationData this$additionalPaymentInformation = this.getAdditionalPaymentInformation();
        AdditionalPaymentInformationData other$additionalPaymentInformation = other.getAdditionalPaymentInformation();
        if (this$additionalPaymentInformation == null ? other$additionalPaymentInformation != null : !((Object)this$additionalPaymentInformation).equals(other$additionalPaymentInformation)) {
            return false;
        }
        BigDecimal this$costThreshold = this.getCostThreshold();
        BigDecimal other$costThreshold = other.getCostThreshold();
        if (this$costThreshold == null ? other$costThreshold != null : !((Object)this$costThreshold).equals(other$costThreshold)) {
            return false;
        }
        BigDecimal this$dischargeFraction = this.getDischargeFraction();
        BigDecimal other$dischargeFraction = other.getDischargeFraction();
        if (this$dischargeFraction == null ? other$dischargeFraction != null : !((Object)this$dischargeFraction).equals(other$dischargeFraction)) {
            return false;
        }
        BigDecimal this$drgRelativeWeight = this.getDrgRelativeWeight();
        BigDecimal other$drgRelativeWeight = other.getDrgRelativeWeight();
        if (this$drgRelativeWeight == null ? other$drgRelativeWeight != null : !((Object)this$drgRelativeWeight).equals(other$drgRelativeWeight)) {
            return false;
        }
        BigDecimal this$drgRelativeWeightFraction = this.getDrgRelativeWeightFraction();
        BigDecimal other$drgRelativeWeightFraction = other.getDrgRelativeWeightFraction();
        if (this$drgRelativeWeightFraction == null ? other$drgRelativeWeightFraction != null : !((Object)this$drgRelativeWeightFraction).equals(other$drgRelativeWeightFraction)) {
            return false;
        }
        BigDecimal this$federalSpecificPortionPercent = this.getFederalSpecificPortionPercent();
        BigDecimal other$federalSpecificPortionPercent = other.getFederalSpecificPortionPercent();
        if (this$federalSpecificPortionPercent == null ? other$federalSpecificPortionPercent != null : !((Object)this$federalSpecificPortionPercent).equals(other$federalSpecificPortionPercent)) {
            return false;
        }
        BigDecimal this$flx7Payment = this.getFlx7Payment();
        BigDecimal other$flx7Payment = other.getFlx7Payment();
        if (this$flx7Payment == null ? other$flx7Payment != null : !((Object)this$flx7Payment).equals(other$flx7Payment)) {
            return false;
        }
        BigDecimal this$hospitalReadmissionReductionAdjustment = this.getHospitalReadmissionReductionAdjustment();
        BigDecimal other$hospitalReadmissionReductionAdjustment = other.getHospitalReadmissionReductionAdjustment();
        if (this$hospitalReadmissionReductionAdjustment == null ? other$hospitalReadmissionReductionAdjustment != null : !((Object)this$hospitalReadmissionReductionAdjustment).equals(other$hospitalReadmissionReductionAdjustment)) {
            return false;
        }
        String this$hospitalReadmissionReductionIndicator = this.getHospitalReadmissionReductionIndicator();
        String other$hospitalReadmissionReductionIndicator = other.getHospitalReadmissionReductionIndicator();
        if (this$hospitalReadmissionReductionIndicator == null ? other$hospitalReadmissionReductionIndicator != null : !this$hospitalReadmissionReductionIndicator.equals(other$hospitalReadmissionReductionIndicator)) {
            return false;
        }
        BigDecimal this$hospitalSpecificPortionPercent = this.getHospitalSpecificPortionPercent();
        BigDecimal other$hospitalSpecificPortionPercent = other.getHospitalSpecificPortionPercent();
        if (this$hospitalSpecificPortionPercent == null ? other$hospitalSpecificPortionPercent != null : !((Object)this$hospitalSpecificPortionPercent).equals(other$hospitalSpecificPortionPercent)) {
            return false;
        }
        BigDecimal this$hospitalSpecificPortionRate = this.getHospitalSpecificPortionRate();
        BigDecimal other$hospitalSpecificPortionRate = other.getHospitalSpecificPortionRate();
        if (this$hospitalSpecificPortionRate == null ? other$hospitalSpecificPortionRate != null : !((Object)this$hospitalSpecificPortionRate).equals(other$hospitalSpecificPortionRate)) {
            return false;
        }
        BigDecimal this$isletIsolationAddOnPayment = this.getIsletIsolationAddOnPayment();
        BigDecimal other$isletIsolationAddOnPayment = other.getIsletIsolationAddOnPayment();
        if (this$isletIsolationAddOnPayment == null ? other$isletIsolationAddOnPayment != null : !((Object)this$isletIsolationAddOnPayment).equals(other$isletIsolationAddOnPayment)) {
            return false;
        }
        BigDecimal this$lowVolumePayment = this.getLowVolumePayment();
        BigDecimal other$lowVolumePayment = other.getLowVolumePayment();
        if (this$lowVolumePayment == null ? other$lowVolumePayment != null : !((Object)this$lowVolumePayment).equals(other$lowVolumePayment)) {
            return false;
        }
        BigDecimal this$nationalLaborCost = this.getNationalLaborCost();
        BigDecimal other$nationalLaborCost = other.getNationalLaborCost();
        if (this$nationalLaborCost == null ? other$nationalLaborCost != null : !((Object)this$nationalLaborCost).equals(other$nationalLaborCost)) {
            return false;
        }
        BigDecimal this$nationalLaborPercent = this.getNationalLaborPercent();
        BigDecimal other$nationalLaborPercent = other.getNationalLaborPercent();
        if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !((Object)this$nationalLaborPercent).equals(other$nationalLaborPercent)) {
            return false;
        }
        BigDecimal this$nationalNonLaborCost = this.getNationalNonLaborCost();
        BigDecimal other$nationalNonLaborCost = other.getNationalNonLaborCost();
        if (this$nationalNonLaborCost == null ? other$nationalNonLaborCost != null : !((Object)this$nationalNonLaborCost).equals(other$nationalNonLaborCost)) {
            return false;
        }
        BigDecimal this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
        BigDecimal other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
        if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !((Object)this$nationalNonLaborPercent).equals(other$nationalNonLaborPercent)) {
            return false;
        }
        BigDecimal this$nationalPercent = this.getNationalPercent();
        BigDecimal other$nationalPercent = other.getNationalPercent();
        if (this$nationalPercent == null ? other$nationalPercent != null : !((Object)this$nationalPercent).equals(other$nationalPercent)) {
            return false;
        }
        BigDecimal this$newTechnologyAddOnPayment = this.getNewTechnologyAddOnPayment();
        BigDecimal other$newTechnologyAddOnPayment = other.getNewTechnologyAddOnPayment();
        if (this$newTechnologyAddOnPayment == null ? other$newTechnologyAddOnPayment != null : !((Object)this$newTechnologyAddOnPayment).equals(other$newTechnologyAddOnPayment)) {
            return false;
        }
        BigDecimal this$passthroughTotalPlusMisc = this.getPassthroughTotalPlusMisc();
        BigDecimal other$passthroughTotalPlusMisc = other.getPassthroughTotalPlusMisc();
        if (this$passthroughTotalPlusMisc == null ? other$passthroughTotalPlusMisc != null : !((Object)this$passthroughTotalPlusMisc).equals(other$passthroughTotalPlusMisc)) {
            return false;
        }
        BigDecimal this$regularLaborCost = this.getRegularLaborCost();
        BigDecimal other$regularLaborCost = other.getRegularLaborCost();
        if (this$regularLaborCost == null ? other$regularLaborCost != null : !((Object)this$regularLaborCost).equals(other$regularLaborCost)) {
            return false;
        }
        BigDecimal this$regularNonLaborCost = this.getRegularNonLaborCost();
        BigDecimal other$regularNonLaborCost = other.getRegularNonLaborCost();
        if (this$regularNonLaborCost == null ? other$regularNonLaborCost != null : !((Object)this$regularNonLaborCost).equals(other$regularNonLaborCost)) {
            return false;
        }
        BigDecimal this$regularPercent = this.getRegularPercent();
        BigDecimal other$regularPercent = other.getRegularPercent();
        if (this$regularPercent == null ? other$regularPercent != null : !((Object)this$regularPercent).equals(other$regularPercent)) {
            return false;
        }
        BigDecimal this$valueBasedPurchasingAdjustmentAmount = this.getValueBasedPurchasingAdjustmentAmount();
        BigDecimal other$valueBasedPurchasingAdjustmentAmount = other.getValueBasedPurchasingAdjustmentAmount();
        if (this$valueBasedPurchasingAdjustmentAmount == null ? other$valueBasedPurchasingAdjustmentAmount != null : !((Object)this$valueBasedPurchasingAdjustmentAmount).equals(other$valueBasedPurchasingAdjustmentAmount)) {
            return false;
        }
        String this$valueBasedPurchasingParticipantIndicator = this.getValueBasedPurchasingParticipantIndicator();
        String other$valueBasedPurchasingParticipantIndicator = other.getValueBasedPurchasingParticipantIndicator();
        if (this$valueBasedPurchasingParticipantIndicator == null ? other$valueBasedPurchasingParticipantIndicator != null : !this$valueBasedPurchasingParticipantIndicator.equals(other$valueBasedPurchasingParticipantIndicator)) {
            return false;
        }
        BigDecimal this$wageIndex = this.getWageIndex();
        BigDecimal other$wageIndex = other.getWageIndex();
        return !(this$wageIndex == null ? other$wageIndex != null : !((Object)this$wageIndex).equals(other$wageIndex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalCalculationVariableData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdditionalCapitalVariableData $additionalCapitalVariables = this.getAdditionalCapitalVariables();
        result = result * 59 + ($additionalCapitalVariables == null ? 43 : ((Object)$additionalCapitalVariables).hashCode());
        AdditionalOperatingVariableData $additionalOperatingVariables = this.getAdditionalOperatingVariables();
        result = result * 59 + ($additionalOperatingVariables == null ? 43 : ((Object)$additionalOperatingVariables).hashCode());
        AdditionalPaymentInformationData $additionalPaymentInformation = this.getAdditionalPaymentInformation();
        result = result * 59 + ($additionalPaymentInformation == null ? 43 : ((Object)$additionalPaymentInformation).hashCode());
        BigDecimal $costThreshold = this.getCostThreshold();
        result = result * 59 + ($costThreshold == null ? 43 : ((Object)$costThreshold).hashCode());
        BigDecimal $dischargeFraction = this.getDischargeFraction();
        result = result * 59 + ($dischargeFraction == null ? 43 : ((Object)$dischargeFraction).hashCode());
        BigDecimal $drgRelativeWeight = this.getDrgRelativeWeight();
        result = result * 59 + ($drgRelativeWeight == null ? 43 : ((Object)$drgRelativeWeight).hashCode());
        BigDecimal $drgRelativeWeightFraction = this.getDrgRelativeWeightFraction();
        result = result * 59 + ($drgRelativeWeightFraction == null ? 43 : ((Object)$drgRelativeWeightFraction).hashCode());
        BigDecimal $federalSpecificPortionPercent = this.getFederalSpecificPortionPercent();
        result = result * 59 + ($federalSpecificPortionPercent == null ? 43 : ((Object)$federalSpecificPortionPercent).hashCode());
        BigDecimal $flx7Payment = this.getFlx7Payment();
        result = result * 59 + ($flx7Payment == null ? 43 : ((Object)$flx7Payment).hashCode());
        BigDecimal $hospitalReadmissionReductionAdjustment = this.getHospitalReadmissionReductionAdjustment();
        result = result * 59 + ($hospitalReadmissionReductionAdjustment == null ? 43 : ((Object)$hospitalReadmissionReductionAdjustment).hashCode());
        String $hospitalReadmissionReductionIndicator = this.getHospitalReadmissionReductionIndicator();
        result = result * 59 + ($hospitalReadmissionReductionIndicator == null ? 43 : $hospitalReadmissionReductionIndicator.hashCode());
        BigDecimal $hospitalSpecificPortionPercent = this.getHospitalSpecificPortionPercent();
        result = result * 59 + ($hospitalSpecificPortionPercent == null ? 43 : ((Object)$hospitalSpecificPortionPercent).hashCode());
        BigDecimal $hospitalSpecificPortionRate = this.getHospitalSpecificPortionRate();
        result = result * 59 + ($hospitalSpecificPortionRate == null ? 43 : ((Object)$hospitalSpecificPortionRate).hashCode());
        BigDecimal $isletIsolationAddOnPayment = this.getIsletIsolationAddOnPayment();
        result = result * 59 + ($isletIsolationAddOnPayment == null ? 43 : ((Object)$isletIsolationAddOnPayment).hashCode());
        BigDecimal $lowVolumePayment = this.getLowVolumePayment();
        result = result * 59 + ($lowVolumePayment == null ? 43 : ((Object)$lowVolumePayment).hashCode());
        BigDecimal $nationalLaborCost = this.getNationalLaborCost();
        result = result * 59 + ($nationalLaborCost == null ? 43 : ((Object)$nationalLaborCost).hashCode());
        BigDecimal $nationalLaborPercent = this.getNationalLaborPercent();
        result = result * 59 + ($nationalLaborPercent == null ? 43 : ((Object)$nationalLaborPercent).hashCode());
        BigDecimal $nationalNonLaborCost = this.getNationalNonLaborCost();
        result = result * 59 + ($nationalNonLaborCost == null ? 43 : ((Object)$nationalNonLaborCost).hashCode());
        BigDecimal $nationalNonLaborPercent = this.getNationalNonLaborPercent();
        result = result * 59 + ($nationalNonLaborPercent == null ? 43 : ((Object)$nationalNonLaborPercent).hashCode());
        BigDecimal $nationalPercent = this.getNationalPercent();
        result = result * 59 + ($nationalPercent == null ? 43 : ((Object)$nationalPercent).hashCode());
        BigDecimal $newTechnologyAddOnPayment = this.getNewTechnologyAddOnPayment();
        result = result * 59 + ($newTechnologyAddOnPayment == null ? 43 : ((Object)$newTechnologyAddOnPayment).hashCode());
        BigDecimal $passthroughTotalPlusMisc = this.getPassthroughTotalPlusMisc();
        result = result * 59 + ($passthroughTotalPlusMisc == null ? 43 : ((Object)$passthroughTotalPlusMisc).hashCode());
        BigDecimal $regularLaborCost = this.getRegularLaborCost();
        result = result * 59 + ($regularLaborCost == null ? 43 : ((Object)$regularLaborCost).hashCode());
        BigDecimal $regularNonLaborCost = this.getRegularNonLaborCost();
        result = result * 59 + ($regularNonLaborCost == null ? 43 : ((Object)$regularNonLaborCost).hashCode());
        BigDecimal $regularPercent = this.getRegularPercent();
        result = result * 59 + ($regularPercent == null ? 43 : ((Object)$regularPercent).hashCode());
        BigDecimal $valueBasedPurchasingAdjustmentAmount = this.getValueBasedPurchasingAdjustmentAmount();
        result = result * 59 + ($valueBasedPurchasingAdjustmentAmount == null ? 43 : ((Object)$valueBasedPurchasingAdjustmentAmount).hashCode());
        String $valueBasedPurchasingParticipantIndicator = this.getValueBasedPurchasingParticipantIndicator();
        result = result * 59 + ($valueBasedPurchasingParticipantIndicator == null ? 43 : $valueBasedPurchasingParticipantIndicator.hashCode());
        BigDecimal $wageIndex = this.getWageIndex();
        result = result * 59 + ($wageIndex == null ? 43 : ((Object)$wageIndex).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalCalculationVariableData(additionalCapitalVariables=" + this.getAdditionalCapitalVariables() + ", additionalOperatingVariables=" + this.getAdditionalOperatingVariables() + ", additionalPaymentInformation=" + this.getAdditionalPaymentInformation() + ", costThreshold=" + this.getCostThreshold() + ", dischargeFraction=" + this.getDischargeFraction() + ", drgRelativeWeight=" + this.getDrgRelativeWeight() + ", drgRelativeWeightFraction=" + this.getDrgRelativeWeightFraction() + ", federalSpecificPortionPercent=" + this.getFederalSpecificPortionPercent() + ", flx7Payment=" + this.getFlx7Payment() + ", hospitalReadmissionReductionAdjustment=" + this.getHospitalReadmissionReductionAdjustment() + ", hospitalReadmissionReductionIndicator=" + this.getHospitalReadmissionReductionIndicator() + ", hospitalSpecificPortionPercent=" + this.getHospitalSpecificPortionPercent() + ", hospitalSpecificPortionRate=" + this.getHospitalSpecificPortionRate() + ", isletIsolationAddOnPayment=" + this.getIsletIsolationAddOnPayment() + ", lowVolumePayment=" + this.getLowVolumePayment() + ", nationalLaborCost=" + this.getNationalLaborCost() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborCost=" + this.getNationalNonLaborCost() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", nationalPercent=" + this.getNationalPercent() + ", newTechnologyAddOnPayment=" + this.getNewTechnologyAddOnPayment() + ", passthroughTotalPlusMisc=" + this.getPassthroughTotalPlusMisc() + ", regularLaborCost=" + this.getRegularLaborCost() + ", regularNonLaborCost=" + this.getRegularNonLaborCost() + ", regularPercent=" + this.getRegularPercent() + ", valueBasedPurchasingAdjustmentAmount=" + this.getValueBasedPurchasingAdjustmentAmount() + ", valueBasedPurchasingParticipantIndicator=" + this.getValueBasedPurchasingParticipantIndicator() + ", wageIndex=" + this.getWageIndex() + ")";
    }

    @Generated
    public AdditionalCalculationVariableData() {
    }
}

