/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithNineFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="The additional capital variable information from claim pricing.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPITAL-VARIABLES", value="<structure>")}), @Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPITAL2-VARIABLES", value="<structure>")})})
public class AdditionalCapitalVariableData {
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital cost outlier.", example="1234.896525245", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-COST-OUTLIER", value="PIC 9(07)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal capitalCostOutlier;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital disproportionate share hospital adjustment.", example="90384.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-DSH-ADJ", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalDisproportionateShareHospitalAdjustment;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital disproportionate share hospital amount.", example="4.5045", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-DSH", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal capitalDisproportionateShareHospitalAmount;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital exception amount.", example="150.93", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-EXCEPTIONS", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalExceptionAmount = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99999.9999")
    @Digits(integer=5, fraction=4)
    @Schema(description="The capital federal rate.", example="234.6789", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-FED-RATE", value="PIC 9(05)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.9999") @Digits(integer=5, fraction=4) @FixedValue BigDecimal capitalFederalRate;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital federal-specific portion.", example="90384.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-FSP", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalFederalSpecificPortion;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital federal-specific portion 2B.", example="38945.76", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI2-B-FSP", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalFederalSpecificPortion2B;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The capital federal-specific portion percent.", example="4.5045", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-FSP-PCT", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal capitalFederalSpecificPortionPercent;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99999.9999")
    @Digits(integer=5, fraction=4)
    @Schema(description="The capital geographic adjustment factor.", example="234.6789", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-GAF", value="PIC 9(05)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99999.9999") @Digits(integer=5, fraction=4) @FixedValue BigDecimal capitalGeographicAdjustmentFactor;
    @BigDecimalScale(scale=4, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.9999")
    @Digits(integer=1, fraction=4)
    @Schema(description="The capital federal-specific portion.", example="4.5045", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-HSP", value="PIC 9(01)V9(04)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.9999") @Digits(integer=1, fraction=4) @FixedValue BigDecimal capitalHospitalSpecificPortion;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="999999.999999999")
    @Digits(integer=6, fraction=9)
    @Schema(description="The capital hospital-specific portion part.", example="783.924583092", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-HSP-PART", value="PIC 9(06)V9(09)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="999999.999999999") @Digits(integer=6, fraction=9) @FixedValue BigDecimal capitalHospitalSpecificPortionPart;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The capital hospital-specific portion percent.", example="4.55", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-HSP-PCT", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal capitalHospitalSpecificPortionPercent;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital indirect medical education adjustment.", example="92378.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-IME-ADJ", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalIndirectMedicalEducationAdjustment;
    @BigDecimalScale(scale=9, roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital indirect medical education amount.", example="1234.896525245", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-WK-CAPI-IME-TEACH", value="PIC 9(06)V9(09)")})})
    @ValidDecimalOutputWithNineFractionDigits
    private BigDecimal capitalIndirectMedicalEducationAmount;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The capital large-urban factor.", example="1.89", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-LARG-URBAN", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal capitalLargeUrbanFactor;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital old hold-harmless amount.", example="1252452.89", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-OLD-HARM", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalOldHoldHarmlessAmount;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital old hold-harmless rate.", example="165252452.89", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="H-CAPI-OLD-HARMLESS", value="PIC 9(09)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalOldHoldHarmlessRate;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital outlier.", example="654356.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-OUTLIER", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalOutlier;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital outlier 2B.", example="92378.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI2-B-OUTLIER", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalOutlier2B;
    @Pattern(regexp="[ABC]", message="must be `A`, `B` or `C`")
    @Schema(description="The code that indicates the type of capital payment methodology for hospitals.", example="A", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI2-PAY-CODE", value="PIC X(1)")})})
    private @Pattern(regexp="[ABC]", message="must be `A`, `B` or `C`") String capitalPaymentCode;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The capital total payment.", example="8345679.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CAPI-TOTAL-PAY", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal capitalTotalPayment;

    @Generated
    public BigDecimal getCapitalCostOutlier() {
        return this.capitalCostOutlier;
    }

    @Generated
    public BigDecimal getCapitalDisproportionateShareHospitalAdjustment() {
        return this.capitalDisproportionateShareHospitalAdjustment;
    }

    @Generated
    public BigDecimal getCapitalDisproportionateShareHospitalAmount() {
        return this.capitalDisproportionateShareHospitalAmount;
    }

    @Generated
    public BigDecimal getCapitalExceptionAmount() {
        return this.capitalExceptionAmount;
    }

    @Generated
    public BigDecimal getCapitalFederalRate() {
        return this.capitalFederalRate;
    }

    @Generated
    public BigDecimal getCapitalFederalSpecificPortion() {
        return this.capitalFederalSpecificPortion;
    }

    @Generated
    public BigDecimal getCapitalFederalSpecificPortion2B() {
        return this.capitalFederalSpecificPortion2B;
    }

    @Generated
    public BigDecimal getCapitalFederalSpecificPortionPercent() {
        return this.capitalFederalSpecificPortionPercent;
    }

    @Generated
    public BigDecimal getCapitalGeographicAdjustmentFactor() {
        return this.capitalGeographicAdjustmentFactor;
    }

    @Generated
    public BigDecimal getCapitalHospitalSpecificPortion() {
        return this.capitalHospitalSpecificPortion;
    }

    @Generated
    public BigDecimal getCapitalHospitalSpecificPortionPart() {
        return this.capitalHospitalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getCapitalHospitalSpecificPortionPercent() {
        return this.capitalHospitalSpecificPortionPercent;
    }

    @Generated
    public BigDecimal getCapitalIndirectMedicalEducationAdjustment() {
        return this.capitalIndirectMedicalEducationAdjustment;
    }

    @Generated
    public BigDecimal getCapitalIndirectMedicalEducationAmount() {
        return this.capitalIndirectMedicalEducationAmount;
    }

    @Generated
    public BigDecimal getCapitalLargeUrbanFactor() {
        return this.capitalLargeUrbanFactor;
    }

    @Generated
    public BigDecimal getCapitalOldHoldHarmlessAmount() {
        return this.capitalOldHoldHarmlessAmount;
    }

    @Generated
    public BigDecimal getCapitalOldHoldHarmlessRate() {
        return this.capitalOldHoldHarmlessRate;
    }

    @Generated
    public BigDecimal getCapitalOutlier() {
        return this.capitalOutlier;
    }

    @Generated
    public BigDecimal getCapitalOutlier2B() {
        return this.capitalOutlier2B;
    }

    @Generated
    public String getCapitalPaymentCode() {
        return this.capitalPaymentCode;
    }

    @Generated
    public BigDecimal getCapitalTotalPayment() {
        return this.capitalTotalPayment;
    }

    @Generated
    public void setCapitalCostOutlier(BigDecimal capitalCostOutlier) {
        this.capitalCostOutlier = capitalCostOutlier;
    }

    @Generated
    public void setCapitalDisproportionateShareHospitalAdjustment(BigDecimal capitalDisproportionateShareHospitalAdjustment) {
        this.capitalDisproportionateShareHospitalAdjustment = capitalDisproportionateShareHospitalAdjustment;
    }

    @Generated
    public void setCapitalDisproportionateShareHospitalAmount(BigDecimal capitalDisproportionateShareHospitalAmount) {
        this.capitalDisproportionateShareHospitalAmount = capitalDisproportionateShareHospitalAmount;
    }

    @Generated
    public void setCapitalExceptionAmount(BigDecimal capitalExceptionAmount) {
        this.capitalExceptionAmount = capitalExceptionAmount;
    }

    @Generated
    public void setCapitalFederalRate(BigDecimal capitalFederalRate) {
        this.capitalFederalRate = capitalFederalRate;
    }

    @Generated
    public void setCapitalFederalSpecificPortion(BigDecimal capitalFederalSpecificPortion) {
        this.capitalFederalSpecificPortion = capitalFederalSpecificPortion;
    }

    @Generated
    public void setCapitalFederalSpecificPortion2B(BigDecimal capitalFederalSpecificPortion2B) {
        this.capitalFederalSpecificPortion2B = capitalFederalSpecificPortion2B;
    }

    @Generated
    public void setCapitalFederalSpecificPortionPercent(BigDecimal capitalFederalSpecificPortionPercent) {
        this.capitalFederalSpecificPortionPercent = capitalFederalSpecificPortionPercent;
    }

    @Generated
    public void setCapitalGeographicAdjustmentFactor(BigDecimal capitalGeographicAdjustmentFactor) {
        this.capitalGeographicAdjustmentFactor = capitalGeographicAdjustmentFactor;
    }

    @Generated
    public void setCapitalHospitalSpecificPortion(BigDecimal capitalHospitalSpecificPortion) {
        this.capitalHospitalSpecificPortion = capitalHospitalSpecificPortion;
    }

    @Generated
    public void setCapitalHospitalSpecificPortionPart(BigDecimal capitalHospitalSpecificPortionPart) {
        this.capitalHospitalSpecificPortionPart = capitalHospitalSpecificPortionPart;
    }

    @Generated
    public void setCapitalHospitalSpecificPortionPercent(BigDecimal capitalHospitalSpecificPortionPercent) {
        this.capitalHospitalSpecificPortionPercent = capitalHospitalSpecificPortionPercent;
    }

    @Generated
    public void setCapitalIndirectMedicalEducationAdjustment(BigDecimal capitalIndirectMedicalEducationAdjustment) {
        this.capitalIndirectMedicalEducationAdjustment = capitalIndirectMedicalEducationAdjustment;
    }

    @Generated
    public void setCapitalIndirectMedicalEducationAmount(BigDecimal capitalIndirectMedicalEducationAmount) {
        this.capitalIndirectMedicalEducationAmount = capitalIndirectMedicalEducationAmount;
    }

    @Generated
    public void setCapitalLargeUrbanFactor(BigDecimal capitalLargeUrbanFactor) {
        this.capitalLargeUrbanFactor = capitalLargeUrbanFactor;
    }

    @Generated
    public void setCapitalOldHoldHarmlessAmount(BigDecimal capitalOldHoldHarmlessAmount) {
        this.capitalOldHoldHarmlessAmount = capitalOldHoldHarmlessAmount;
    }

    @Generated
    public void setCapitalOldHoldHarmlessRate(BigDecimal capitalOldHoldHarmlessRate) {
        this.capitalOldHoldHarmlessRate = capitalOldHoldHarmlessRate;
    }

    @Generated
    public void setCapitalOutlier(BigDecimal capitalOutlier) {
        this.capitalOutlier = capitalOutlier;
    }

    @Generated
    public void setCapitalOutlier2B(BigDecimal capitalOutlier2B) {
        this.capitalOutlier2B = capitalOutlier2B;
    }

    @Generated
    public void setCapitalPaymentCode(String capitalPaymentCode) {
        this.capitalPaymentCode = capitalPaymentCode;
    }

    @Generated
    public void setCapitalTotalPayment(BigDecimal capitalTotalPayment) {
        this.capitalTotalPayment = capitalTotalPayment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalCapitalVariableData)) {
            return false;
        }
        AdditionalCapitalVariableData other = (AdditionalCapitalVariableData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$capitalCostOutlier = this.getCapitalCostOutlier();
        BigDecimal other$capitalCostOutlier = other.getCapitalCostOutlier();
        if (this$capitalCostOutlier == null ? other$capitalCostOutlier != null : !((Object)this$capitalCostOutlier).equals(other$capitalCostOutlier)) {
            return false;
        }
        BigDecimal this$capitalDisproportionateShareHospitalAdjustment = this.getCapitalDisproportionateShareHospitalAdjustment();
        BigDecimal other$capitalDisproportionateShareHospitalAdjustment = other.getCapitalDisproportionateShareHospitalAdjustment();
        if (this$capitalDisproportionateShareHospitalAdjustment == null ? other$capitalDisproportionateShareHospitalAdjustment != null : !((Object)this$capitalDisproportionateShareHospitalAdjustment).equals(other$capitalDisproportionateShareHospitalAdjustment)) {
            return false;
        }
        BigDecimal this$capitalDisproportionateShareHospitalAmount = this.getCapitalDisproportionateShareHospitalAmount();
        BigDecimal other$capitalDisproportionateShareHospitalAmount = other.getCapitalDisproportionateShareHospitalAmount();
        if (this$capitalDisproportionateShareHospitalAmount == null ? other$capitalDisproportionateShareHospitalAmount != null : !((Object)this$capitalDisproportionateShareHospitalAmount).equals(other$capitalDisproportionateShareHospitalAmount)) {
            return false;
        }
        BigDecimal this$capitalExceptionAmount = this.getCapitalExceptionAmount();
        BigDecimal other$capitalExceptionAmount = other.getCapitalExceptionAmount();
        if (this$capitalExceptionAmount == null ? other$capitalExceptionAmount != null : !((Object)this$capitalExceptionAmount).equals(other$capitalExceptionAmount)) {
            return false;
        }
        BigDecimal this$capitalFederalRate = this.getCapitalFederalRate();
        BigDecimal other$capitalFederalRate = other.getCapitalFederalRate();
        if (this$capitalFederalRate == null ? other$capitalFederalRate != null : !((Object)this$capitalFederalRate).equals(other$capitalFederalRate)) {
            return false;
        }
        BigDecimal this$capitalFederalSpecificPortion = this.getCapitalFederalSpecificPortion();
        BigDecimal other$capitalFederalSpecificPortion = other.getCapitalFederalSpecificPortion();
        if (this$capitalFederalSpecificPortion == null ? other$capitalFederalSpecificPortion != null : !((Object)this$capitalFederalSpecificPortion).equals(other$capitalFederalSpecificPortion)) {
            return false;
        }
        BigDecimal this$capitalFederalSpecificPortion2B = this.getCapitalFederalSpecificPortion2B();
        BigDecimal other$capitalFederalSpecificPortion2B = other.getCapitalFederalSpecificPortion2B();
        if (this$capitalFederalSpecificPortion2B == null ? other$capitalFederalSpecificPortion2B != null : !((Object)this$capitalFederalSpecificPortion2B).equals(other$capitalFederalSpecificPortion2B)) {
            return false;
        }
        BigDecimal this$capitalFederalSpecificPortionPercent = this.getCapitalFederalSpecificPortionPercent();
        BigDecimal other$capitalFederalSpecificPortionPercent = other.getCapitalFederalSpecificPortionPercent();
        if (this$capitalFederalSpecificPortionPercent == null ? other$capitalFederalSpecificPortionPercent != null : !((Object)this$capitalFederalSpecificPortionPercent).equals(other$capitalFederalSpecificPortionPercent)) {
            return false;
        }
        BigDecimal this$capitalGeographicAdjustmentFactor = this.getCapitalGeographicAdjustmentFactor();
        BigDecimal other$capitalGeographicAdjustmentFactor = other.getCapitalGeographicAdjustmentFactor();
        if (this$capitalGeographicAdjustmentFactor == null ? other$capitalGeographicAdjustmentFactor != null : !((Object)this$capitalGeographicAdjustmentFactor).equals(other$capitalGeographicAdjustmentFactor)) {
            return false;
        }
        BigDecimal this$capitalHospitalSpecificPortion = this.getCapitalHospitalSpecificPortion();
        BigDecimal other$capitalHospitalSpecificPortion = other.getCapitalHospitalSpecificPortion();
        if (this$capitalHospitalSpecificPortion == null ? other$capitalHospitalSpecificPortion != null : !((Object)this$capitalHospitalSpecificPortion).equals(other$capitalHospitalSpecificPortion)) {
            return false;
        }
        BigDecimal this$capitalHospitalSpecificPortionPart = this.getCapitalHospitalSpecificPortionPart();
        BigDecimal other$capitalHospitalSpecificPortionPart = other.getCapitalHospitalSpecificPortionPart();
        if (this$capitalHospitalSpecificPortionPart == null ? other$capitalHospitalSpecificPortionPart != null : !((Object)this$capitalHospitalSpecificPortionPart).equals(other$capitalHospitalSpecificPortionPart)) {
            return false;
        }
        BigDecimal this$capitalHospitalSpecificPortionPercent = this.getCapitalHospitalSpecificPortionPercent();
        BigDecimal other$capitalHospitalSpecificPortionPercent = other.getCapitalHospitalSpecificPortionPercent();
        if (this$capitalHospitalSpecificPortionPercent == null ? other$capitalHospitalSpecificPortionPercent != null : !((Object)this$capitalHospitalSpecificPortionPercent).equals(other$capitalHospitalSpecificPortionPercent)) {
            return false;
        }
        BigDecimal this$capitalIndirectMedicalEducationAdjustment = this.getCapitalIndirectMedicalEducationAdjustment();
        BigDecimal other$capitalIndirectMedicalEducationAdjustment = other.getCapitalIndirectMedicalEducationAdjustment();
        if (this$capitalIndirectMedicalEducationAdjustment == null ? other$capitalIndirectMedicalEducationAdjustment != null : !((Object)this$capitalIndirectMedicalEducationAdjustment).equals(other$capitalIndirectMedicalEducationAdjustment)) {
            return false;
        }
        BigDecimal this$capitalIndirectMedicalEducationAmount = this.getCapitalIndirectMedicalEducationAmount();
        BigDecimal other$capitalIndirectMedicalEducationAmount = other.getCapitalIndirectMedicalEducationAmount();
        if (this$capitalIndirectMedicalEducationAmount == null ? other$capitalIndirectMedicalEducationAmount != null : !((Object)this$capitalIndirectMedicalEducationAmount).equals(other$capitalIndirectMedicalEducationAmount)) {
            return false;
        }
        BigDecimal this$capitalLargeUrbanFactor = this.getCapitalLargeUrbanFactor();
        BigDecimal other$capitalLargeUrbanFactor = other.getCapitalLargeUrbanFactor();
        if (this$capitalLargeUrbanFactor == null ? other$capitalLargeUrbanFactor != null : !((Object)this$capitalLargeUrbanFactor).equals(other$capitalLargeUrbanFactor)) {
            return false;
        }
        BigDecimal this$capitalOldHoldHarmlessAmount = this.getCapitalOldHoldHarmlessAmount();
        BigDecimal other$capitalOldHoldHarmlessAmount = other.getCapitalOldHoldHarmlessAmount();
        if (this$capitalOldHoldHarmlessAmount == null ? other$capitalOldHoldHarmlessAmount != null : !((Object)this$capitalOldHoldHarmlessAmount).equals(other$capitalOldHoldHarmlessAmount)) {
            return false;
        }
        BigDecimal this$capitalOldHoldHarmlessRate = this.getCapitalOldHoldHarmlessRate();
        BigDecimal other$capitalOldHoldHarmlessRate = other.getCapitalOldHoldHarmlessRate();
        if (this$capitalOldHoldHarmlessRate == null ? other$capitalOldHoldHarmlessRate != null : !((Object)this$capitalOldHoldHarmlessRate).equals(other$capitalOldHoldHarmlessRate)) {
            return false;
        }
        BigDecimal this$capitalOutlier = this.getCapitalOutlier();
        BigDecimal other$capitalOutlier = other.getCapitalOutlier();
        if (this$capitalOutlier == null ? other$capitalOutlier != null : !((Object)this$capitalOutlier).equals(other$capitalOutlier)) {
            return false;
        }
        BigDecimal this$capitalOutlier2B = this.getCapitalOutlier2B();
        BigDecimal other$capitalOutlier2B = other.getCapitalOutlier2B();
        if (this$capitalOutlier2B == null ? other$capitalOutlier2B != null : !((Object)this$capitalOutlier2B).equals(other$capitalOutlier2B)) {
            return false;
        }
        String this$capitalPaymentCode = this.getCapitalPaymentCode();
        String other$capitalPaymentCode = other.getCapitalPaymentCode();
        if (this$capitalPaymentCode == null ? other$capitalPaymentCode != null : !this$capitalPaymentCode.equals(other$capitalPaymentCode)) {
            return false;
        }
        BigDecimal this$capitalTotalPayment = this.getCapitalTotalPayment();
        BigDecimal other$capitalTotalPayment = other.getCapitalTotalPayment();
        return !(this$capitalTotalPayment == null ? other$capitalTotalPayment != null : !((Object)this$capitalTotalPayment).equals(other$capitalTotalPayment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalCapitalVariableData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $capitalCostOutlier = this.getCapitalCostOutlier();
        result = result * 59 + ($capitalCostOutlier == null ? 43 : ((Object)$capitalCostOutlier).hashCode());
        BigDecimal $capitalDisproportionateShareHospitalAdjustment = this.getCapitalDisproportionateShareHospitalAdjustment();
        result = result * 59 + ($capitalDisproportionateShareHospitalAdjustment == null ? 43 : ((Object)$capitalDisproportionateShareHospitalAdjustment).hashCode());
        BigDecimal $capitalDisproportionateShareHospitalAmount = this.getCapitalDisproportionateShareHospitalAmount();
        result = result * 59 + ($capitalDisproportionateShareHospitalAmount == null ? 43 : ((Object)$capitalDisproportionateShareHospitalAmount).hashCode());
        BigDecimal $capitalExceptionAmount = this.getCapitalExceptionAmount();
        result = result * 59 + ($capitalExceptionAmount == null ? 43 : ((Object)$capitalExceptionAmount).hashCode());
        BigDecimal $capitalFederalRate = this.getCapitalFederalRate();
        result = result * 59 + ($capitalFederalRate == null ? 43 : ((Object)$capitalFederalRate).hashCode());
        BigDecimal $capitalFederalSpecificPortion = this.getCapitalFederalSpecificPortion();
        result = result * 59 + ($capitalFederalSpecificPortion == null ? 43 : ((Object)$capitalFederalSpecificPortion).hashCode());
        BigDecimal $capitalFederalSpecificPortion2B = this.getCapitalFederalSpecificPortion2B();
        result = result * 59 + ($capitalFederalSpecificPortion2B == null ? 43 : ((Object)$capitalFederalSpecificPortion2B).hashCode());
        BigDecimal $capitalFederalSpecificPortionPercent = this.getCapitalFederalSpecificPortionPercent();
        result = result * 59 + ($capitalFederalSpecificPortionPercent == null ? 43 : ((Object)$capitalFederalSpecificPortionPercent).hashCode());
        BigDecimal $capitalGeographicAdjustmentFactor = this.getCapitalGeographicAdjustmentFactor();
        result = result * 59 + ($capitalGeographicAdjustmentFactor == null ? 43 : ((Object)$capitalGeographicAdjustmentFactor).hashCode());
        BigDecimal $capitalHospitalSpecificPortion = this.getCapitalHospitalSpecificPortion();
        result = result * 59 + ($capitalHospitalSpecificPortion == null ? 43 : ((Object)$capitalHospitalSpecificPortion).hashCode());
        BigDecimal $capitalHospitalSpecificPortionPart = this.getCapitalHospitalSpecificPortionPart();
        result = result * 59 + ($capitalHospitalSpecificPortionPart == null ? 43 : ((Object)$capitalHospitalSpecificPortionPart).hashCode());
        BigDecimal $capitalHospitalSpecificPortionPercent = this.getCapitalHospitalSpecificPortionPercent();
        result = result * 59 + ($capitalHospitalSpecificPortionPercent == null ? 43 : ((Object)$capitalHospitalSpecificPortionPercent).hashCode());
        BigDecimal $capitalIndirectMedicalEducationAdjustment = this.getCapitalIndirectMedicalEducationAdjustment();
        result = result * 59 + ($capitalIndirectMedicalEducationAdjustment == null ? 43 : ((Object)$capitalIndirectMedicalEducationAdjustment).hashCode());
        BigDecimal $capitalIndirectMedicalEducationAmount = this.getCapitalIndirectMedicalEducationAmount();
        result = result * 59 + ($capitalIndirectMedicalEducationAmount == null ? 43 : ((Object)$capitalIndirectMedicalEducationAmount).hashCode());
        BigDecimal $capitalLargeUrbanFactor = this.getCapitalLargeUrbanFactor();
        result = result * 59 + ($capitalLargeUrbanFactor == null ? 43 : ((Object)$capitalLargeUrbanFactor).hashCode());
        BigDecimal $capitalOldHoldHarmlessAmount = this.getCapitalOldHoldHarmlessAmount();
        result = result * 59 + ($capitalOldHoldHarmlessAmount == null ? 43 : ((Object)$capitalOldHoldHarmlessAmount).hashCode());
        BigDecimal $capitalOldHoldHarmlessRate = this.getCapitalOldHoldHarmlessRate();
        result = result * 59 + ($capitalOldHoldHarmlessRate == null ? 43 : ((Object)$capitalOldHoldHarmlessRate).hashCode());
        BigDecimal $capitalOutlier = this.getCapitalOutlier();
        result = result * 59 + ($capitalOutlier == null ? 43 : ((Object)$capitalOutlier).hashCode());
        BigDecimal $capitalOutlier2B = this.getCapitalOutlier2B();
        result = result * 59 + ($capitalOutlier2B == null ? 43 : ((Object)$capitalOutlier2B).hashCode());
        String $capitalPaymentCode = this.getCapitalPaymentCode();
        result = result * 59 + ($capitalPaymentCode == null ? 43 : $capitalPaymentCode.hashCode());
        BigDecimal $capitalTotalPayment = this.getCapitalTotalPayment();
        result = result * 59 + ($capitalTotalPayment == null ? 43 : ((Object)$capitalTotalPayment).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalCapitalVariableData(capitalCostOutlier=" + this.getCapitalCostOutlier() + ", capitalDisproportionateShareHospitalAdjustment=" + this.getCapitalDisproportionateShareHospitalAdjustment() + ", capitalDisproportionateShareHospitalAmount=" + this.getCapitalDisproportionateShareHospitalAmount() + ", capitalExceptionAmount=" + this.getCapitalExceptionAmount() + ", capitalFederalRate=" + this.getCapitalFederalRate() + ", capitalFederalSpecificPortion=" + this.getCapitalFederalSpecificPortion() + ", capitalFederalSpecificPortion2B=" + this.getCapitalFederalSpecificPortion2B() + ", capitalFederalSpecificPortionPercent=" + this.getCapitalFederalSpecificPortionPercent() + ", capitalGeographicAdjustmentFactor=" + this.getCapitalGeographicAdjustmentFactor() + ", capitalHospitalSpecificPortion=" + this.getCapitalHospitalSpecificPortion() + ", capitalHospitalSpecificPortionPart=" + this.getCapitalHospitalSpecificPortionPart() + ", capitalHospitalSpecificPortionPercent=" + this.getCapitalHospitalSpecificPortionPercent() + ", capitalIndirectMedicalEducationAdjustment=" + this.getCapitalIndirectMedicalEducationAdjustment() + ", capitalIndirectMedicalEducationAmount=" + this.getCapitalIndirectMedicalEducationAmount() + ", capitalLargeUrbanFactor=" + this.getCapitalLargeUrbanFactor() + ", capitalOldHoldHarmlessAmount=" + this.getCapitalOldHoldHarmlessAmount() + ", capitalOldHoldHarmlessRate=" + this.getCapitalOldHoldHarmlessRate() + ", capitalOutlier=" + this.getCapitalOutlier() + ", capitalOutlier2B=" + this.getCapitalOutlier2B() + ", capitalPaymentCode=" + this.getCapitalPaymentCode() + ", capitalTotalPayment=" + this.getCapitalTotalPayment() + ")";
    }

    @Generated
    public AdditionalCapitalVariableData() {
    }
}

