/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidSignedDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

@Schema(description="The additional payment variable information from claim pricing.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-ADDITIONAL-PAY-INFO-DATA", value="<structure>")}), @Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-ADDITIONAL-PAY-INFO-DATA2", value="<structure>")})})
public class AdditionalPaymentInformationData {
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The bundled adjustment payment.", example="665423.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BUNDLE-ADJUST-AMT", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal bundledAdjustmentPayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The electronic health record adjustment payment.", example="6542.54", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-EHR-ADJUST-AMT", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal electronicHealthRecordAdjustmentPayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The hospital-acquired condition payment.", example="5644.25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-HAC-PAYMENT-AMT", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal hospitalAcquiredConditionPayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The hospital readmission reduction adjustment payment.", example="564.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-READMIS-ADJUST-AMT", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal hospitalReadmissionReductionAdjustmentPayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The standard value.", example="90384.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-STNDRD-VALUE", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal standardValue;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The uncompensated care payment.", example="2365.42", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-UNCOMP-CARE-AMOUNT", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal uncompensatedCarePayment;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The value-based purchasing adjustment payment.", example="90384.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-VAL-BASED-PURCH-ADJUST-AMT", value="PIC S9(07)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal valueBasedPurchasingAdjustmentPayment;

    @Generated
    public BigDecimal getBundledAdjustmentPayment() {
        return this.bundledAdjustmentPayment;
    }

    @Generated
    public BigDecimal getElectronicHealthRecordAdjustmentPayment() {
        return this.electronicHealthRecordAdjustmentPayment;
    }

    @Generated
    public BigDecimal getHospitalAcquiredConditionPayment() {
        return this.hospitalAcquiredConditionPayment;
    }

    @Generated
    public BigDecimal getHospitalReadmissionReductionAdjustmentPayment() {
        return this.hospitalReadmissionReductionAdjustmentPayment;
    }

    @Generated
    public BigDecimal getStandardValue() {
        return this.standardValue;
    }

    @Generated
    public BigDecimal getUncompensatedCarePayment() {
        return this.uncompensatedCarePayment;
    }

    @Generated
    public BigDecimal getValueBasedPurchasingAdjustmentPayment() {
        return this.valueBasedPurchasingAdjustmentPayment;
    }

    @Generated
    public void setBundledAdjustmentPayment(BigDecimal bundledAdjustmentPayment) {
        this.bundledAdjustmentPayment = bundledAdjustmentPayment;
    }

    @Generated
    public void setElectronicHealthRecordAdjustmentPayment(BigDecimal electronicHealthRecordAdjustmentPayment) {
        this.electronicHealthRecordAdjustmentPayment = electronicHealthRecordAdjustmentPayment;
    }

    @Generated
    public void setHospitalAcquiredConditionPayment(BigDecimal hospitalAcquiredConditionPayment) {
        this.hospitalAcquiredConditionPayment = hospitalAcquiredConditionPayment;
    }

    @Generated
    public void setHospitalReadmissionReductionAdjustmentPayment(BigDecimal hospitalReadmissionReductionAdjustmentPayment) {
        this.hospitalReadmissionReductionAdjustmentPayment = hospitalReadmissionReductionAdjustmentPayment;
    }

    @Generated
    public void setStandardValue(BigDecimal standardValue) {
        this.standardValue = standardValue;
    }

    @Generated
    public void setUncompensatedCarePayment(BigDecimal uncompensatedCarePayment) {
        this.uncompensatedCarePayment = uncompensatedCarePayment;
    }

    @Generated
    public void setValueBasedPurchasingAdjustmentPayment(BigDecimal valueBasedPurchasingAdjustmentPayment) {
        this.valueBasedPurchasingAdjustmentPayment = valueBasedPurchasingAdjustmentPayment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalPaymentInformationData)) {
            return false;
        }
        AdditionalPaymentInformationData other = (AdditionalPaymentInformationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$bundledAdjustmentPayment = this.getBundledAdjustmentPayment();
        BigDecimal other$bundledAdjustmentPayment = other.getBundledAdjustmentPayment();
        if (this$bundledAdjustmentPayment == null ? other$bundledAdjustmentPayment != null : !((Object)this$bundledAdjustmentPayment).equals(other$bundledAdjustmentPayment)) {
            return false;
        }
        BigDecimal this$electronicHealthRecordAdjustmentPayment = this.getElectronicHealthRecordAdjustmentPayment();
        BigDecimal other$electronicHealthRecordAdjustmentPayment = other.getElectronicHealthRecordAdjustmentPayment();
        if (this$electronicHealthRecordAdjustmentPayment == null ? other$electronicHealthRecordAdjustmentPayment != null : !((Object)this$electronicHealthRecordAdjustmentPayment).equals(other$electronicHealthRecordAdjustmentPayment)) {
            return false;
        }
        BigDecimal this$hospitalAcquiredConditionPayment = this.getHospitalAcquiredConditionPayment();
        BigDecimal other$hospitalAcquiredConditionPayment = other.getHospitalAcquiredConditionPayment();
        if (this$hospitalAcquiredConditionPayment == null ? other$hospitalAcquiredConditionPayment != null : !((Object)this$hospitalAcquiredConditionPayment).equals(other$hospitalAcquiredConditionPayment)) {
            return false;
        }
        BigDecimal this$hospitalReadmissionReductionAdjustmentPayment = this.getHospitalReadmissionReductionAdjustmentPayment();
        BigDecimal other$hospitalReadmissionReductionAdjustmentPayment = other.getHospitalReadmissionReductionAdjustmentPayment();
        if (this$hospitalReadmissionReductionAdjustmentPayment == null ? other$hospitalReadmissionReductionAdjustmentPayment != null : !((Object)this$hospitalReadmissionReductionAdjustmentPayment).equals(other$hospitalReadmissionReductionAdjustmentPayment)) {
            return false;
        }
        BigDecimal this$standardValue = this.getStandardValue();
        BigDecimal other$standardValue = other.getStandardValue();
        if (this$standardValue == null ? other$standardValue != null : !((Object)this$standardValue).equals(other$standardValue)) {
            return false;
        }
        BigDecimal this$uncompensatedCarePayment = this.getUncompensatedCarePayment();
        BigDecimal other$uncompensatedCarePayment = other.getUncompensatedCarePayment();
        if (this$uncompensatedCarePayment == null ? other$uncompensatedCarePayment != null : !((Object)this$uncompensatedCarePayment).equals(other$uncompensatedCarePayment)) {
            return false;
        }
        BigDecimal this$valueBasedPurchasingAdjustmentPayment = this.getValueBasedPurchasingAdjustmentPayment();
        BigDecimal other$valueBasedPurchasingAdjustmentPayment = other.getValueBasedPurchasingAdjustmentPayment();
        return !(this$valueBasedPurchasingAdjustmentPayment == null ? other$valueBasedPurchasingAdjustmentPayment != null : !((Object)this$valueBasedPurchasingAdjustmentPayment).equals(other$valueBasedPurchasingAdjustmentPayment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalPaymentInformationData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $bundledAdjustmentPayment = this.getBundledAdjustmentPayment();
        result = result * 59 + ($bundledAdjustmentPayment == null ? 43 : ((Object)$bundledAdjustmentPayment).hashCode());
        BigDecimal $electronicHealthRecordAdjustmentPayment = this.getElectronicHealthRecordAdjustmentPayment();
        result = result * 59 + ($electronicHealthRecordAdjustmentPayment == null ? 43 : ((Object)$electronicHealthRecordAdjustmentPayment).hashCode());
        BigDecimal $hospitalAcquiredConditionPayment = this.getHospitalAcquiredConditionPayment();
        result = result * 59 + ($hospitalAcquiredConditionPayment == null ? 43 : ((Object)$hospitalAcquiredConditionPayment).hashCode());
        BigDecimal $hospitalReadmissionReductionAdjustmentPayment = this.getHospitalReadmissionReductionAdjustmentPayment();
        result = result * 59 + ($hospitalReadmissionReductionAdjustmentPayment == null ? 43 : ((Object)$hospitalReadmissionReductionAdjustmentPayment).hashCode());
        BigDecimal $standardValue = this.getStandardValue();
        result = result * 59 + ($standardValue == null ? 43 : ((Object)$standardValue).hashCode());
        BigDecimal $uncompensatedCarePayment = this.getUncompensatedCarePayment();
        result = result * 59 + ($uncompensatedCarePayment == null ? 43 : ((Object)$uncompensatedCarePayment).hashCode());
        BigDecimal $valueBasedPurchasingAdjustmentPayment = this.getValueBasedPurchasingAdjustmentPayment();
        result = result * 59 + ($valueBasedPurchasingAdjustmentPayment == null ? 43 : ((Object)$valueBasedPurchasingAdjustmentPayment).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalPaymentInformationData(bundledAdjustmentPayment=" + this.getBundledAdjustmentPayment() + ", electronicHealthRecordAdjustmentPayment=" + this.getElectronicHealthRecordAdjustmentPayment() + ", hospitalAcquiredConditionPayment=" + this.getHospitalAcquiredConditionPayment() + ", hospitalReadmissionReductionAdjustmentPayment=" + this.getHospitalReadmissionReductionAdjustmentPayment() + ", standardValue=" + this.getStandardValue() + ", uncompensatedCarePayment=" + this.getUncompensatedCarePayment() + ", valueBasedPurchasingAdjustmentPayment=" + this.getValueBasedPurchasingAdjustmentPayment() + ")";
    }

    @Generated
    public AdditionalPaymentInformationData() {
    }
}

