/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidDiagnosisRelatedGroup;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The IPPS claim data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-NEW-DATA", value="<structure>")})})
public class IppsClaimData
extends ClaimData {
    @ArraySchema(arraySchema=@Schema(description="The condition codes related to this claim.", example="[\n\"ZA\",\n\"ZB\",\n\"ZC\",\n\"ZD\",\n\"ZE\"\n]", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-CONDITION-CODE-TABLE", value="B-CONDITION-CODE    PIC X(07) OCCURS 25 TIMES\nINDEXED BY IDX-COND", parseValue=true)})}), uniqueItems=true)
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> conditionCodes;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @NotNull
    @Schema(description="The charges covered by the claim.", example="903845.76", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-CHARGES-CLAIMED", value="PIC 9(09)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) @NotNull BigDecimal coveredCharges;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The covered days.", example="3", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-COVERED-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer coveredDays;
    @ArraySchema(arraySchema=@Schema(description="The demo codes related to this claim.", example="[\"61\"]", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DEMO-DATA", value="B-DEMO-CODE1           PIC X(02)\nB-DEMO-CODE2           PIC X(02)\nB-DEMO-CODE3           PIC X(02)\nB-DEMO-CODE4           PIC X(02)", parseValue=true)})}))
    @Size(max=4, min=1)
    private @Size(max=4, min=1) List<@Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String> demoCodes;
    @ArraySchema(arraySchema=@Schema(description="The diagnosis codes related to this claim.", example="[\n\"N390\",\n\"B952\",\n\"I130\",\n\"I5032\",\n\"N179\",\n\"M25511\",\n\"M549\"\n]", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DIAGNOSIS-CODE-TABLE", value="B-DIAGNOSIS-CODE    PIC X(07) OCCURS 25 TIMES\nINDEXED BY IDX-DIAG", parseValue=true)})}))
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> diagnosisCodes;
    @NotNull
    @ValidDiagnosisRelatedGroup
    @Schema(description="The diagnosis-related group.", example="001", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DRG", value="PIC 9(03)")})})
    private String diagnosisRelatedGroup;
    @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character")
    @Schema(description="The diagnosis-related group severity.", example="X")
    private @Pattern(regexp="[A-Z\\d]", message="must be an alphanumeric character") String diagnosisRelatedGroupSeverity;
    @NotNull
    @Schema(description="The discharge date.", example="2020-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DISCHARGE-DATE", value="B-DISCHG-CC        PIC 9(02)\nB-DISCHG-YY        PIC 9(02)\nB-DISCHG-MM        PIC 9(02)\nB-DISCHG-DD        PIC 9(02)", parseValue=true)})})
    @StrictLocalDate
    private LocalDate dischargeDate;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The length of stay (LOS).", example="3", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LOS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer lengthOfStay;
    @Max(value=99L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The lifetime reserve days.", example="2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LTR-DAYS", value="PIC 9(02)")})})
    private @Max(value=99L) @Min(value=0L) @NotNull Integer lifetimeReserveDays;
    @Pattern(regexp="\\d{4}|\\d{2}", message="must be two or four digits")
    @Schema(description="The condition codes related to this claim.", example="6120", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="P-NEW-GEO-LOC-MSA9", value="REDEFINES P-NEW-GEO-LOC-MSAX  PIC 9(04)")})})
    private @Pattern(regexp="\\d{4}|\\d{2}", message="must be two or four digits") String midnightAdjustmentGeolocation;
    @ArraySchema(arraySchema=@Schema(description="The national drug codes related to this claim.", example="[\n\"70842012001\",\n\"65293000901\",\n\"389475235\",\n\"0934764436\"\n]", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-NDC-DATA", value="B-NDC-NUMBER        PIC X(11) OCCURS 449 TIMES\nINDEXED BY IDX-NDC", parseValue=true)})}))
    @Size(max=449, min=1)
    private @Size(max=449, min=1) List<@Pattern(regexp="\\d{9,11}", message="must be nine to eleven digits") String> nationalDrugCodes;
    @ArraySchema(arraySchema=@Schema(description="The procedure codes related to this claim.", example="[\n\"04VD3FZ\",\n\"XNS0032\",\n\"XW033F3\",\n\"3E0J7U1\",\n\"3E0J7U1\",\n\"0JH60DZ\"\n]", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PROCEDURE-CODE-TABLE", value="B-PROCEDURE-CODE    PIC X(07) OCCURS 25 TIMES\nINDEXED BY IDX-PROC", parseValue=true)})}))
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> procedureCodes;
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be two digits")
    @Schema(description="The code indicating the state of claim review.", example="11", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-REVIEW-CODE", value="PIC 9(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be two digits") String reviewCode;

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> getConditionCodes() {
        return this.conditionCodes;
    }

    @Generated
    public BigDecimal getCoveredCharges() {
        return this.coveredCharges;
    }

    @Generated
    public Integer getCoveredDays() {
        return this.coveredDays;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String> getDemoCodes() {
        return this.demoCodes;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> getDiagnosisCodes() {
        return this.diagnosisCodes;
    }

    @Generated
    public String getDiagnosisRelatedGroup() {
        return this.diagnosisRelatedGroup;
    }

    @Generated
    public String getDiagnosisRelatedGroupSeverity() {
        return this.diagnosisRelatedGroupSeverity;
    }

    @Generated
    public LocalDate getDischargeDate() {
        return this.dischargeDate;
    }

    @Generated
    public Integer getLengthOfStay() {
        return this.lengthOfStay;
    }

    @Generated
    public Integer getLifetimeReserveDays() {
        return this.lifetimeReserveDays;
    }

    @Generated
    public String getMidnightAdjustmentGeolocation() {
        return this.midnightAdjustmentGeolocation;
    }

    @Generated
    public List<@Pattern(regexp="\\d{9,11}", message="must be nine to eleven digits") String> getNationalDrugCodes() {
        return this.nationalDrugCodes;
    }

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> getProcedureCodes() {
        return this.procedureCodes;
    }

    @Generated
    public String getReviewCode() {
        return this.reviewCode;
    }

    @Generated
    public void setConditionCodes(List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> conditionCodes) {
        this.conditionCodes = conditionCodes;
    }

    @Generated
    public void setCoveredCharges(BigDecimal coveredCharges) {
        this.coveredCharges = coveredCharges;
    }

    @Generated
    public void setCoveredDays(Integer coveredDays) {
        this.coveredDays = coveredDays;
    }

    @Generated
    public void setDemoCodes(List<@Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String> demoCodes) {
        this.demoCodes = demoCodes;
    }

    @Generated
    public void setDiagnosisCodes(List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> diagnosisCodes) {
        this.diagnosisCodes = diagnosisCodes;
    }

    @Generated
    public void setDiagnosisRelatedGroup(String diagnosisRelatedGroup) {
        this.diagnosisRelatedGroup = diagnosisRelatedGroup;
    }

    @Generated
    public void setDiagnosisRelatedGroupSeverity(String diagnosisRelatedGroupSeverity) {
        this.diagnosisRelatedGroupSeverity = diagnosisRelatedGroupSeverity;
    }

    @Generated
    public void setDischargeDate(LocalDate dischargeDate) {
        this.dischargeDate = dischargeDate;
    }

    @Generated
    public void setLengthOfStay(Integer lengthOfStay) {
        this.lengthOfStay = lengthOfStay;
    }

    @Generated
    public void setLifetimeReserveDays(Integer lifetimeReserveDays) {
        this.lifetimeReserveDays = lifetimeReserveDays;
    }

    @Generated
    public void setMidnightAdjustmentGeolocation(String midnightAdjustmentGeolocation) {
        this.midnightAdjustmentGeolocation = midnightAdjustmentGeolocation;
    }

    @Generated
    public void setNationalDrugCodes(List<@Pattern(regexp="\\d{9,11}", message="must be nine to eleven digits") String> nationalDrugCodes) {
        this.nationalDrugCodes = nationalDrugCodes;
    }

    @Generated
    public void setProcedureCodes(List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> procedureCodes) {
        this.procedureCodes = procedureCodes;
    }

    @Generated
    public void setReviewCode(String reviewCode) {
        this.reviewCode = reviewCode;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IppsClaimData)) {
            return false;
        }
        IppsClaimData other = (IppsClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$coveredDays = this.getCoveredDays();
        Integer other$coveredDays = other.getCoveredDays();
        if (this$coveredDays == null ? other$coveredDays != null : !((Object)this$coveredDays).equals(other$coveredDays)) {
            return false;
        }
        Integer this$lengthOfStay = this.getLengthOfStay();
        Integer other$lengthOfStay = other.getLengthOfStay();
        if (this$lengthOfStay == null ? other$lengthOfStay != null : !((Object)this$lengthOfStay).equals(other$lengthOfStay)) {
            return false;
        }
        Integer this$lifetimeReserveDays = this.getLifetimeReserveDays();
        Integer other$lifetimeReserveDays = other.getLifetimeReserveDays();
        if (this$lifetimeReserveDays == null ? other$lifetimeReserveDays != null : !((Object)this$lifetimeReserveDays).equals(other$lifetimeReserveDays)) {
            return false;
        }
        List<String> this$conditionCodes = this.getConditionCodes();
        List<String> other$conditionCodes = other.getConditionCodes();
        if (this$conditionCodes == null ? other$conditionCodes != null : !((Object)this$conditionCodes).equals(other$conditionCodes)) {
            return false;
        }
        BigDecimal this$coveredCharges = this.getCoveredCharges();
        BigDecimal other$coveredCharges = other.getCoveredCharges();
        if (this$coveredCharges == null ? other$coveredCharges != null : !((Object)this$coveredCharges).equals(other$coveredCharges)) {
            return false;
        }
        List<String> this$demoCodes = this.getDemoCodes();
        List<String> other$demoCodes = other.getDemoCodes();
        if (this$demoCodes == null ? other$demoCodes != null : !((Object)this$demoCodes).equals(other$demoCodes)) {
            return false;
        }
        List<String> this$diagnosisCodes = this.getDiagnosisCodes();
        List<String> other$diagnosisCodes = other.getDiagnosisCodes();
        if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !((Object)this$diagnosisCodes).equals(other$diagnosisCodes)) {
            return false;
        }
        String this$diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
        String other$diagnosisRelatedGroup = other.getDiagnosisRelatedGroup();
        if (this$diagnosisRelatedGroup == null ? other$diagnosisRelatedGroup != null : !this$diagnosisRelatedGroup.equals(other$diagnosisRelatedGroup)) {
            return false;
        }
        String this$diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
        String other$diagnosisRelatedGroupSeverity = other.getDiagnosisRelatedGroupSeverity();
        if (this$diagnosisRelatedGroupSeverity == null ? other$diagnosisRelatedGroupSeverity != null : !this$diagnosisRelatedGroupSeverity.equals(other$diagnosisRelatedGroupSeverity)) {
            return false;
        }
        LocalDate this$dischargeDate = this.getDischargeDate();
        LocalDate other$dischargeDate = other.getDischargeDate();
        if (this$dischargeDate == null ? other$dischargeDate != null : !((Object)this$dischargeDate).equals(other$dischargeDate)) {
            return false;
        }
        String this$midnightAdjustmentGeolocation = this.getMidnightAdjustmentGeolocation();
        String other$midnightAdjustmentGeolocation = other.getMidnightAdjustmentGeolocation();
        if (this$midnightAdjustmentGeolocation == null ? other$midnightAdjustmentGeolocation != null : !this$midnightAdjustmentGeolocation.equals(other$midnightAdjustmentGeolocation)) {
            return false;
        }
        List<String> this$nationalDrugCodes = this.getNationalDrugCodes();
        List<String> other$nationalDrugCodes = other.getNationalDrugCodes();
        if (this$nationalDrugCodes == null ? other$nationalDrugCodes != null : !((Object)this$nationalDrugCodes).equals(other$nationalDrugCodes)) {
            return false;
        }
        List<String> this$procedureCodes = this.getProcedureCodes();
        List<String> other$procedureCodes = other.getProcedureCodes();
        if (this$procedureCodes == null ? other$procedureCodes != null : !((Object)this$procedureCodes).equals(other$procedureCodes)) {
            return false;
        }
        String this$reviewCode = this.getReviewCode();
        String other$reviewCode = other.getReviewCode();
        return !(this$reviewCode == null ? other$reviewCode != null : !this$reviewCode.equals(other$reviewCode));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IppsClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $coveredDays = this.getCoveredDays();
        result = result * 59 + ($coveredDays == null ? 43 : ((Object)$coveredDays).hashCode());
        Integer $lengthOfStay = this.getLengthOfStay();
        result = result * 59 + ($lengthOfStay == null ? 43 : ((Object)$lengthOfStay).hashCode());
        Integer $lifetimeReserveDays = this.getLifetimeReserveDays();
        result = result * 59 + ($lifetimeReserveDays == null ? 43 : ((Object)$lifetimeReserveDays).hashCode());
        List<String> $conditionCodes = this.getConditionCodes();
        result = result * 59 + ($conditionCodes == null ? 43 : ((Object)$conditionCodes).hashCode());
        BigDecimal $coveredCharges = this.getCoveredCharges();
        result = result * 59 + ($coveredCharges == null ? 43 : ((Object)$coveredCharges).hashCode());
        List<String> $demoCodes = this.getDemoCodes();
        result = result * 59 + ($demoCodes == null ? 43 : ((Object)$demoCodes).hashCode());
        List<String> $diagnosisCodes = this.getDiagnosisCodes();
        result = result * 59 + ($diagnosisCodes == null ? 43 : ((Object)$diagnosisCodes).hashCode());
        String $diagnosisRelatedGroup = this.getDiagnosisRelatedGroup();
        result = result * 59 + ($diagnosisRelatedGroup == null ? 43 : $diagnosisRelatedGroup.hashCode());
        String $diagnosisRelatedGroupSeverity = this.getDiagnosisRelatedGroupSeverity();
        result = result * 59 + ($diagnosisRelatedGroupSeverity == null ? 43 : $diagnosisRelatedGroupSeverity.hashCode());
        LocalDate $dischargeDate = this.getDischargeDate();
        result = result * 59 + ($dischargeDate == null ? 43 : ((Object)$dischargeDate).hashCode());
        String $midnightAdjustmentGeolocation = this.getMidnightAdjustmentGeolocation();
        result = result * 59 + ($midnightAdjustmentGeolocation == null ? 43 : $midnightAdjustmentGeolocation.hashCode());
        List<String> $nationalDrugCodes = this.getNationalDrugCodes();
        result = result * 59 + ($nationalDrugCodes == null ? 43 : ((Object)$nationalDrugCodes).hashCode());
        List<String> $procedureCodes = this.getProcedureCodes();
        result = result * 59 + ($procedureCodes == null ? 43 : ((Object)$procedureCodes).hashCode());
        String $reviewCode = this.getReviewCode();
        result = result * 59 + ($reviewCode == null ? 43 : $reviewCode.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IppsClaimData(conditionCodes=" + this.getConditionCodes() + ", coveredCharges=" + this.getCoveredCharges() + ", coveredDays=" + this.getCoveredDays() + ", demoCodes=" + this.getDemoCodes() + ", diagnosisCodes=" + this.getDiagnosisCodes() + ", diagnosisRelatedGroup=" + this.getDiagnosisRelatedGroup() + ", diagnosisRelatedGroupSeverity=" + this.getDiagnosisRelatedGroupSeverity() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", midnightAdjustmentGeolocation=" + this.getMidnightAdjustmentGeolocation() + ", nationalDrugCodes=" + this.getNationalDrugCodes() + ", procedureCodes=" + this.getProcedureCodes() + ", reviewCode=" + this.getReviewCode() + ")";
    }

    @Generated
    public IppsClaimData() {
    }
}

