/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(description="The IPPS prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DATA", value="<structure>")})})
public class IppsPaymentData
extends PaymentData {
    @BigDecimalScale(scale=1, roundingMode=RoundingMode.HALF_UP)
    @DecimalMin(value="0")
    @DecimalMax(value="99.9")
    @Digits(integer=2, fraction=1)
    @NotNull
    @Schema(description="The average length of stay.", example="12.1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-AVG-LOS", value="PIC 9(02)V9(01)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99.9") @Digits(integer=2, fraction=1) @NotNull @FixedValue BigDecimal averageLengthOfStay = BigDecimal.ZERO.setScale(1, RoundingMode.HALF_UP);
    @DecimalMin(value="0")
    @DecimalMax(value="99.9")
    @Digits(integer=2, fraction=1)
    @Schema(description="The number of days cut off.", example="15.2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DAYS-CUTOFF", value="PIC 9(02)V9(01)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99.9") @Digits(integer=2, fraction=1) @FixedValue BigDecimal daysCutoff;
    @Max(value=99L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of lifetime reserve days used.", example="12", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LTR-DAYS-USED", value="PIC 9(02)")})})
    private @Max(value=99L) @Min(value=0L) @NotNull int lifetimeReserveDaysUsed;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @NotNull
    @Schema(description="The operating disproportionate share hospital adjustment.", example="345879.06", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OPER-DSH-ADJ", value="PIC 9(06)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal operatingDisproportionateShareHospitalAdjustment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @NotNull
    @Schema(description="The operating federal-specific portion part.", example="39084.75", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OPER-FSP-PART", value="PIC 9(06)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal operatingFederalSpecificPortionPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @NotNull
    @Schema(description="The operating hospital-specific portion part.", example="98734.56", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OPER-HSP-PART", value="PIC 9(06)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal operatingHospitalSpecificPortionPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @NotNull
    @Schema(description="The operating indirect medical education adjustment.", example="239048.57", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OPER-IME-ADJ", value="PIC 9(06)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal operatingIndirectMedicalEducationAdjustment = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @NotNull
    @Schema(description="The operating outlier payment part.", example="9823705.46", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OPER-OUTLIER-PART", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal operatingOutlierPaymentPart = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of outlier days.", example="3", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OUTLIER-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull int outlierDays;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of regular days used.", example="90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-REG-DAYS-USED", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) @NotNull int regularDaysUsed;

    @Generated
    public BigDecimal getAverageLengthOfStay() {
        return this.averageLengthOfStay;
    }

    @Generated
    public BigDecimal getDaysCutoff() {
        return this.daysCutoff;
    }

    @Generated
    public int getLifetimeReserveDaysUsed() {
        return this.lifetimeReserveDaysUsed;
    }

    @Generated
    public BigDecimal getOperatingDisproportionateShareHospitalAdjustment() {
        return this.operatingDisproportionateShareHospitalAdjustment;
    }

    @Generated
    public BigDecimal getOperatingFederalSpecificPortionPart() {
        return this.operatingFederalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getOperatingHospitalSpecificPortionPart() {
        return this.operatingHospitalSpecificPortionPart;
    }

    @Generated
    public BigDecimal getOperatingIndirectMedicalEducationAdjustment() {
        return this.operatingIndirectMedicalEducationAdjustment;
    }

    @Generated
    public BigDecimal getOperatingOutlierPaymentPart() {
        return this.operatingOutlierPaymentPart;
    }

    @Generated
    public int getOutlierDays() {
        return this.outlierDays;
    }

    @Generated
    public int getRegularDaysUsed() {
        return this.regularDaysUsed;
    }

    @Generated
    public void setAverageLengthOfStay(BigDecimal averageLengthOfStay) {
        this.averageLengthOfStay = averageLengthOfStay;
    }

    @Generated
    public void setDaysCutoff(BigDecimal daysCutoff) {
        this.daysCutoff = daysCutoff;
    }

    @Generated
    public void setLifetimeReserveDaysUsed(int lifetimeReserveDaysUsed) {
        this.lifetimeReserveDaysUsed = lifetimeReserveDaysUsed;
    }

    @Generated
    public void setOperatingDisproportionateShareHospitalAdjustment(BigDecimal operatingDisproportionateShareHospitalAdjustment) {
        this.operatingDisproportionateShareHospitalAdjustment = operatingDisproportionateShareHospitalAdjustment;
    }

    @Generated
    public void setOperatingFederalSpecificPortionPart(BigDecimal operatingFederalSpecificPortionPart) {
        this.operatingFederalSpecificPortionPart = operatingFederalSpecificPortionPart;
    }

    @Generated
    public void setOperatingHospitalSpecificPortionPart(BigDecimal operatingHospitalSpecificPortionPart) {
        this.operatingHospitalSpecificPortionPart = operatingHospitalSpecificPortionPart;
    }

    @Generated
    public void setOperatingIndirectMedicalEducationAdjustment(BigDecimal operatingIndirectMedicalEducationAdjustment) {
        this.operatingIndirectMedicalEducationAdjustment = operatingIndirectMedicalEducationAdjustment;
    }

    @Generated
    public void setOperatingOutlierPaymentPart(BigDecimal operatingOutlierPaymentPart) {
        this.operatingOutlierPaymentPart = operatingOutlierPaymentPart;
    }

    @Generated
    public void setOutlierDays(int outlierDays) {
        this.outlierDays = outlierDays;
    }

    @Generated
    public void setRegularDaysUsed(int regularDaysUsed) {
        this.regularDaysUsed = regularDaysUsed;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IppsPaymentData)) {
            return false;
        }
        IppsPaymentData other = (IppsPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLifetimeReserveDaysUsed() != other.getLifetimeReserveDaysUsed()) {
            return false;
        }
        if (this.getOutlierDays() != other.getOutlierDays()) {
            return false;
        }
        if (this.getRegularDaysUsed() != other.getRegularDaysUsed()) {
            return false;
        }
        BigDecimal this$averageLengthOfStay = this.getAverageLengthOfStay();
        BigDecimal other$averageLengthOfStay = other.getAverageLengthOfStay();
        if (this$averageLengthOfStay == null ? other$averageLengthOfStay != null : !((Object)this$averageLengthOfStay).equals(other$averageLengthOfStay)) {
            return false;
        }
        BigDecimal this$daysCutoff = this.getDaysCutoff();
        BigDecimal other$daysCutoff = other.getDaysCutoff();
        if (this$daysCutoff == null ? other$daysCutoff != null : !((Object)this$daysCutoff).equals(other$daysCutoff)) {
            return false;
        }
        BigDecimal this$operatingDisproportionateShareHospitalAdjustment = this.getOperatingDisproportionateShareHospitalAdjustment();
        BigDecimal other$operatingDisproportionateShareHospitalAdjustment = other.getOperatingDisproportionateShareHospitalAdjustment();
        if (this$operatingDisproportionateShareHospitalAdjustment == null ? other$operatingDisproportionateShareHospitalAdjustment != null : !((Object)this$operatingDisproportionateShareHospitalAdjustment).equals(other$operatingDisproportionateShareHospitalAdjustment)) {
            return false;
        }
        BigDecimal this$operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
        BigDecimal other$operatingFederalSpecificPortionPart = other.getOperatingFederalSpecificPortionPart();
        if (this$operatingFederalSpecificPortionPart == null ? other$operatingFederalSpecificPortionPart != null : !((Object)this$operatingFederalSpecificPortionPart).equals(other$operatingFederalSpecificPortionPart)) {
            return false;
        }
        BigDecimal this$operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
        BigDecimal other$operatingHospitalSpecificPortionPart = other.getOperatingHospitalSpecificPortionPart();
        if (this$operatingHospitalSpecificPortionPart == null ? other$operatingHospitalSpecificPortionPart != null : !((Object)this$operatingHospitalSpecificPortionPart).equals(other$operatingHospitalSpecificPortionPart)) {
            return false;
        }
        BigDecimal this$operatingIndirectMedicalEducationAdjustment = this.getOperatingIndirectMedicalEducationAdjustment();
        BigDecimal other$operatingIndirectMedicalEducationAdjustment = other.getOperatingIndirectMedicalEducationAdjustment();
        if (this$operatingIndirectMedicalEducationAdjustment == null ? other$operatingIndirectMedicalEducationAdjustment != null : !((Object)this$operatingIndirectMedicalEducationAdjustment).equals(other$operatingIndirectMedicalEducationAdjustment)) {
            return false;
        }
        BigDecimal this$operatingOutlierPaymentPart = this.getOperatingOutlierPaymentPart();
        BigDecimal other$operatingOutlierPaymentPart = other.getOperatingOutlierPaymentPart();
        return !(this$operatingOutlierPaymentPart == null ? other$operatingOutlierPaymentPart != null : !((Object)this$operatingOutlierPaymentPart).equals(other$operatingOutlierPaymentPart));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IppsPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLifetimeReserveDaysUsed();
        result = result * 59 + this.getOutlierDays();
        result = result * 59 + this.getRegularDaysUsed();
        BigDecimal $averageLengthOfStay = this.getAverageLengthOfStay();
        result = result * 59 + ($averageLengthOfStay == null ? 43 : ((Object)$averageLengthOfStay).hashCode());
        BigDecimal $daysCutoff = this.getDaysCutoff();
        result = result * 59 + ($daysCutoff == null ? 43 : ((Object)$daysCutoff).hashCode());
        BigDecimal $operatingDisproportionateShareHospitalAdjustment = this.getOperatingDisproportionateShareHospitalAdjustment();
        result = result * 59 + ($operatingDisproportionateShareHospitalAdjustment == null ? 43 : ((Object)$operatingDisproportionateShareHospitalAdjustment).hashCode());
        BigDecimal $operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
        result = result * 59 + ($operatingFederalSpecificPortionPart == null ? 43 : ((Object)$operatingFederalSpecificPortionPart).hashCode());
        BigDecimal $operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
        result = result * 59 + ($operatingHospitalSpecificPortionPart == null ? 43 : ((Object)$operatingHospitalSpecificPortionPart).hashCode());
        BigDecimal $operatingIndirectMedicalEducationAdjustment = this.getOperatingIndirectMedicalEducationAdjustment();
        result = result * 59 + ($operatingIndirectMedicalEducationAdjustment == null ? 43 : ((Object)$operatingIndirectMedicalEducationAdjustment).hashCode());
        BigDecimal $operatingOutlierPaymentPart = this.getOperatingOutlierPaymentPart();
        result = result * 59 + ($operatingOutlierPaymentPart == null ? 43 : ((Object)$operatingOutlierPaymentPart).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IppsPaymentData(averageLengthOfStay=" + this.getAverageLengthOfStay() + ", daysCutoff=" + this.getDaysCutoff() + ", lifetimeReserveDaysUsed=" + this.getLifetimeReserveDaysUsed() + ", operatingDisproportionateShareHospitalAdjustment=" + this.getOperatingDisproportionateShareHospitalAdjustment() + ", operatingFederalSpecificPortionPart=" + this.getOperatingFederalSpecificPortionPart() + ", operatingHospitalSpecificPortionPart=" + this.getOperatingHospitalSpecificPortionPart() + ", operatingIndirectMedicalEducationAdjustment=" + this.getOperatingIndirectMedicalEducationAdjustment() + ", operatingOutlierPaymentPart=" + this.getOperatingOutlierPaymentPart() + ", outlierDays=" + this.getOutlierDays() + ", regularDaysUsed=" + this.getRegularDaysUsed() + ")";
    }

    @Generated
    public IppsPaymentData() {
    }
}

