/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v1.DrgsTableEntry;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateFractionalAdjustments
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        DrgsTableEntry drgsTableEntry = calculationContext.getDrgsTableEntry();
        calculationContext.setDischargeFraction(BigDecimal.ONE);
        calculationContext.setDrgWeightFraction(calculationContext.getDischargeFraction().multiply(drgsTableEntry.getWeight()).setScale(4, RoundingMode.HALF_UP));
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal perDiemDays = calculationContext.getPerDiemDays();
        if ((calculationContext.isPayPerDiemDays() || calculationContext.isPayTransferNoCost() || calculationContext.isPayTransferSpecialDrug() && calculationContext.isDrgPostacutePerDiem()) && BigDecimalUtils.isGreaterThanZero(paymentData.getAverageLengthOfStay())) {
            calculationContext.setTransferAdjustment(perDiemDays.divide(paymentData.getAverageLengthOfStay(), 4, RoundingMode.HALF_UP));
            calculationContext.setDischargeFraction(perDiemDays.divide(paymentData.getAverageLengthOfStay(), 4, RoundingMode.HALF_UP));
            if (BigDecimalUtils.isGreaterThan(calculationContext.getDischargeFraction(), BigDecimal.ONE)) {
                calculationContext.setDischargeFraction(BigDecimal.ONE);
                calculationContext.setTransferAdjustment(BigDecimal.ONE);
            } else {
                calculationContext.setDrgWeightFraction(calculationContext.getTransferAdjustment().multiply(drgsTableEntry.getWeight()).setScale(4, RoundingMode.HALF_UP));
            }
        }
        if (calculationContext.isPayTransferSpecialDrug() && calculationContext.isDrgPostacute5050() && BigDecimalUtils.isGreaterThanZero(paymentData.getAverageLengthOfStay())) {
            calculationContext.setTransferAdjustment(perDiemDays.divide(paymentData.getAverageLengthOfStay(), 4, RoundingMode.HALF_UP));
            calculationContext.setDischargeFraction(new BigDecimal("0.5").add(perDiemDays.multiply(new BigDecimal("0.5")).divide(paymentData.getAverageLengthOfStay(), 4, RoundingMode.HALF_UP)));
            if (BigDecimalUtils.isGreaterThan(calculationContext.getDischargeFraction(), BigDecimal.ONE)) {
                calculationContext.setDischargeFraction(BigDecimal.ONE);
                calculationContext.setTransferAdjustment(BigDecimal.ONE);
            } else {
                calculationContext.setDrgWeightFraction(perDiemDays.multiply(new BigDecimal("0.5")).divide(paymentData.getAverageLengthOfStay(), 5, RoundingMode.DOWN).add(new BigDecimal("0.5")).multiply(drgsTableEntry.getWeight()).setScale(4, RoundingMode.HALF_UP));
            }
        }
    }
}

