/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.api.v2.IppsPaymentData;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;

public class CalculateStayUtilization
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        IppsClaimData claimData = calculationContext.getClaimData();
        IppsPaymentData paymentData = calculationContext.getPaymentData();
        if (calculationContext.getRegularDays() > 0) {
            if (calculationContext.getRegularDays() > claimData.getLengthOfStay()) {
                paymentData.setRegularDaysUsed(claimData.getLengthOfStay());
            } else {
                paymentData.setRegularDaysUsed(calculationContext.getRegularDays());
            }
        } else if (claimData.getLifetimeReserveDays() > claimData.getLengthOfStay()) {
            paymentData.setLifetimeReserveDaysUsed(claimData.getLengthOfStay());
        } else {
            paymentData.setLifetimeReserveDaysUsed(claimData.getLifetimeReserveDays());
        }
    }
}

