/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.tech_addons;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.tables.ClaimCodeType;
import gov.cms.fiss.pricers.ipps.core.tables.DataTables;
import java.math.BigDecimal;

public class AddIsletIsolationCosts
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    private static final String TECHNOLOGY_NAME = "ISLET";

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        DataTables dataTables = calculationContext.getDataTables();
        IppsClaimData claimData = calculationContext.getClaimData();
        int isletCount = dataTables.countMatchingCodes(TECHNOLOGY_NAME, ClaimCodeType.PROC, claimData.getProcedureCodes());
        if (dataTables.codesMatch(TECHNOLOGY_NAME, ClaimCodeType.DIAG, calculationContext.getClaimData().getDiagnosisCodes()) && isletCount != 0) {
            calculationContext.setIsletIsolationPaymentAddOn(this.isletIsolationAddOn(isletCount));
        }
    }

    protected @FixedValue BigDecimal isletIsolationAddOn(int isletCount) {
        if (isletCount == 1) {
            return new BigDecimal("18848.0");
        }
        return new BigDecimal("37696.0");
    }
}

