/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.calculate_payment.totals;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimData;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateStandardizedCharges
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public void calculate(IppsPricerContext calculationContext) {
        BigDecimal operBillStdzCosts = this.calculateOperatingBillStdCost(calculationContext);
        BigDecimal capiBillStdzCosts = this.calculateCapitalBillStdCost(calculationContext);
        BigDecimal operStdzDollarThreshold = this.calculateOperatingStdThreshold(calculationContext);
        BigDecimal capiStdzDollarThreshold = this.calculateCapitalStdThreshold(calculationContext);
        BigDecimal stdzCosts = operBillStdzCosts.add(capiBillStdzCosts);
        BigDecimal stdzThreshold = operStdzDollarThreshold.add(capiStdzDollarThreshold);
        BigDecimal operStdzCostOutlier = BigDecimal.ZERO;
        BigDecimal capiStdzCostOutlier = BigDecimal.ZERO;
        if (BigDecimalUtils.isGreaterThan(stdzCosts, stdzThreshold)) {
            if (BigDecimalUtils.isGreaterThan(operBillStdzCosts, operStdzDollarThreshold)) {
                operStdzCostOutlier = operBillStdzCosts.subtract(operStdzDollarThreshold).multiply(calculationContext.getCostOutlierPct()).setScale(9, RoundingMode.HALF_UP);
            }
            if (BigDecimalUtils.isGreaterThan(capiBillStdzCosts, capiStdzDollarThreshold)) {
                capiStdzCostOutlier = calculationContext.getCostOutlierPct().multiply(capiBillStdzCosts.subtract(capiStdzDollarThreshold)).setScale(9, RoundingMode.HALF_UP);
            }
        }
        BigDecimal baseCalc = calculationContext.getOperatingBaseRate().add(calculationContext.getCapitalBaseRate()).multiply(calculationContext.getDrgWeightFraction());
        calculationContext.setStandardAllowedAmount(baseCalc.add(operStdzCostOutlier.add(capiStdzCostOutlier.add(calculationContext.getNewTechAddOnPayment()))).setScale(2, RoundingMode.HALF_UP));
    }

    protected BigDecimal calculateOperatingBillStdCost(IppsPricerContext calculationContext) {
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        IppsClaimData claimData = calculationContext.getClaimData();
        if (BigDecimalUtils.isGreaterThanZero(calculationContext.getNationalLaborPct().multiply(cbsaReference.getWageIndex()).add(calculationContext.getNationalNonLaborPct().multiply(calculationContext.getOperatingCostOfLivingAdjustment())))) {
            return claimData.getCoveredCharges().multiply(calculationContext.getOperatingCostToChargeRatio()).divide(calculationContext.getNationalLaborPct().multiply(cbsaReference.getWageIndex()).add(calculationContext.getNationalNonLaborPct().multiply(calculationContext.getOperatingCostOfLivingAdjustment())), 2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    protected BigDecimal calculateCapitalBillStdCost(IppsPricerContext calculationContext) {
        if (BigDecimalUtils.isGreaterThanZero(calculationContext.getCapitalGeographicAdjFactor().multiply(calculationContext.getCapitalCostOfLivingAdjustment()))) {
            return calculationContext.getClaimData().getCoveredCharges().multiply(calculationContext.getCapitalOperatingCostToChargeRatio()).divide(calculationContext.getCapitalGeographicAdjFactor().multiply(calculationContext.getCapitalCostOfLivingAdjustment()), 2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    protected BigDecimal calculateOperatingStdThreshold(IppsPricerContext calculationContext) {
        BigDecimal threshold = calculationContext.getOperatingShareDollarThreshold().multiply(calculationContext.getCostThreshold());
        BigDecimal baseDRG = calculationContext.getOperatingBaseRate().multiply(calculationContext.getDrgWeightFraction());
        return threshold.add(baseDRG).add(calculationContext.getNewTechAddOnPayment()).setScale(9, RoundingMode.HALF_UP);
    }

    protected BigDecimal calculateCapitalStdThreshold(IppsPricerContext calculationContext) {
        return calculationContext.getCapitalShareDollarThreshold().multiply(calculationContext.getCostThreshold()).add(calculationContext.getCapitalBaseRate().multiply(calculationContext.getDrgWeightFraction())).setScale(2, RoundingMode.HALF_UP);
    }
}

