/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.rules.wage_index;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingRequest;
import gov.cms.fiss.pricers.ipps.api.v2.IppsClaimPricingResponse;
import gov.cms.fiss.pricers.ipps.core.CbsaReference;
import gov.cms.fiss.pricers.ipps.core.IppsPricerContext;
import gov.cms.fiss.pricers.ipps.core.ResultCode;
import gov.cms.fiss.pricers.ipps.core.tables.CbsaWageIndexEntry;
import org.apache.commons.lang3.StringUtils;

public class UpdateCbsaReference
implements CalculationRule<IppsClaimPricingRequest, IppsClaimPricingResponse, IppsPricerContext> {
    @Override
    public boolean shouldExecute(IppsPricerContext calculationContext) {
        return ResultCode.RC_00_OK == calculationContext.getResultCode();
    }

    @Override
    public void calculate(IppsPricerContext calculationContext) {
        CbsaWageIndexEntry cbsaTableEntry = calculationContext.getCbsaWageIndexEntry(calculationContext.getCbsaLocation());
        CbsaReference cbsaReference = calculationContext.getCbsaReference();
        if (LocalDateUtils.isAfterOrEqual(calculationContext.getDischargeDate(), cbsaTableEntry.getEffectiveDate()) && (StringUtils.equalsAny(calculationContext.getCbsaLocation(), "98", "99") || LocalDateUtils.inRange(cbsaTableEntry.getEffectiveDate(), calculationContext.fiscalYearStart(), calculationContext.fiscalYearEnd()))) {
            cbsaReference.setCbsa(cbsaTableEntry.getCbsa());
            cbsaReference.setEffectiveDate(cbsaTableEntry.getEffectiveDate());
            cbsaReference.setWageIndex(cbsaTableEntry.getGeographicWageIndex());
            if (calculationContext.isCbsaSpecialPaymentIndicatorReclassified()) {
                cbsaReference.setWageIndex(cbsaTableEntry.getReclassifiedWageIndex());
            }
        }
    }
}

