/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.MidnightTableEntry;
import java.util.List;
import java.util.Map;

public class MidnightTableEntryLookupGenerator {
    private static final String CSV_FILE_NAME = "/midnight.csv";
    private final CsvContentReader<MidnightTableEntry> contentProvider = new CsvContentReader<MidnightTableEntry>(MidnightTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public MidnightTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, MidnightTableEntry> generate() {
        return this.generate(CSV_FILE_NAME);
    }

    public Map<String, MidnightTableEntry> generate(String csvFilename) {
        List<MidnightTableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(MidnightTableEntry::getMsa, content);
    }
}

